
package cn.smarthse.modules.giian.service.other;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.giian.entity.other.OtherFriendlyLink;
import cn.smarthse.modules.giian.model.other.OtherFriendlyLinkModel;
import cn.smarthse.modules.giian.model.other.OtherFriendlyLinkQueryParam;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 其它编辑_友情链接
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月4日 上午10:40:32
 */
public interface IOtherFriendlyLinkService extends IBaseService<OtherFriendlyLink>{

	/**
	 * 查询友情链接列表
	 * @author liaoly
	 * @date 2020年11月4日 上午10:50:07
	 * @param param : 综合查询参数对象
	 * @return PageInfo<HomeModel>
	 */
	List<OtherFriendlyLinkModel> getOtherFriendlyLinkList(OtherFriendlyLinkQueryParam param);
	
	/**
	 * 查询友情链接列表(分页)
	 * @author liaoly
	 * @date 2020年11月4日 上午10:50:07
	 * @param param : 综合查询参数对象
	 * @return PageInfo<HomeModel>
	 */
	PageInfo<OtherFriendlyLinkModel> getOtherFriendlyLinkListData(OtherFriendlyLinkQueryParam param);

	/**
	 * 查询友情链接详情
	 * @author liaoly
	 * @date 2020年11月4日 上午11:06:38
	 * @param id : OtherFriendlyLink.id
	 * @return OtherFriendlyLink
	 */
	OtherFriendlyLinkModel getOtherFriendlyLink(Long id);

	/**
	 * 新增友情链接
	 * @author liaoly
	 * @date 2020年11月4日 上午11:30:49
	 * @param record : 友情链接参数对象
	 * @return OtherFriendlyLinkModel
	 */
	OtherFriendlyLinkModel addOtherFriendlyLink(OtherFriendlyLink record);

	/**
	 * 保存友情链接
	 * @author liaoly
	 * @date 2020年11月4日 下午3:19:20
	 * @param record void
	 */
	void saveOtherFriendlyLink(OtherFriendlyLinkModel record);

	/**
	 * 排序调整
	 * @author liaoly
	 * @date 2020年11月4日 下午3:37:33
	 * @param id : OtherFriendlyLink.id
	 * @param up_down : (上移还是下移1：上移；2：下移)
	 * @param adminId : 操作账号id
	 * void
	 */
	void sort(Long id, Integer up_down, Long adminId);

	/**
	 * 更新状态
	 * @author liaoly
	 * @date 2020年11月4日 下午4:18:44
	 * @param id : OtherFriendlyLink.id
	 * @param status : 状态标志位(1：未使用；2：使用中)
	 * @param adminId : 操作账号id
	 * void
	 */
	void saveStatus(Long id, Integer status, Long adminId);

	/**
	 * 查询友情链接(提供给www的,默认查询所有status=2已发布的)
	 * @author liaoly
	 * @date 2020年11月10日 下午3:46:54
	 * @return List<OtherFriendlyLinkModel>
	 */
	List<OtherFriendlyLinkModel> getOtherFriendlyLinkList_www();

	/**
	 * 删除友情链接
	 * @author liaoly
	 * @date 2020年11月11日 下午3:33:50
	 * @param id : 友情链接id
	 * @param adminId 
	 * void
	 */
	void delOtherFriendlyLink(Long id, Long adminId);

	/**
	 * 批量删除友情链接
	 * @author liaoly
	 * @date 2020年11月20日 上午11:19:59
	 * @param idArr : 友情链接id集合
	 * @param adminId 
	 * void
	 */
	void batchDelFriendlyLink(Long[] idArr, Long adminId);
}
