package cn.smarthse.modules.giian.service.informationPublicity;

import cn.smarthse.modules.giian.entity.informationPublicity.SafetyEvaluationProject;
import cn.smarthse.modules.giian.model.informationPublicity.SafetyEvaluationProjectModel;
import cn.smarthse.modules.giian.model.informationPublicity.SafetyEvaluationProjectSearchModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;
import com.github.pagehelper.PageInfo;

import java.util.List;

/*
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @author <开发者>
 * @since 2020-11-04 01:19
 */
public interface ISafetyEvaluationProjectService extends IBaseService<SafetyEvaluationProject> {

    /**
     * @Author Wuxq
     * @Description //   新增修改
     * @Date 14:05 2020/11/5
     * @Param [safetyEvaluationProject, currentAccountId]
     * @return void
     **/

    void saveSafetyEvaluationProject(SafetyEvaluationProjectModel safetyEvaluationProject, Long currentAccountId);
    /**
     * @Author Wuxq
     * @Description //  获取安全评价项目分页列表数据
     * @Date 14:56 2020/11/5
     * @Param [searchModel]
     * @return com.github.pagehelper.PageInfo<cn.smarthse.modules.giian.model.informationPublicity.SafetyEvaluationProjectModel>
     **/

    PageInfo<SafetyEvaluationProjectModel> getSafetyEvaluationProjectPageData(SafetyEvaluationProjectSearchModel searchModel);

    /**
     * @Author Wuxq
     * @Description //   获取安全评价项目集合数据
     * @Date 15:02 2020/11/5
     * @Param [searchModel]
     * @return java.util.List<cn.smarthse.modules.giian.model.informationPublicity.SafetyEvaluationProjectModel>
     **/
    List<SafetyEvaluationProjectModel> getSafetyEvaluationProjectList(SafetyEvaluationProjectSearchModel searchModel);

    /**
     * @Author Wuxq
     * @Description //   根据id查询项目详情
     * @Date 15:11 2020/11/5
     * @Param [safetyEvaluationProjectId]
     * @return cn.smarthse.modules.giian.model.informationPublicity.SafetyEvaluationProjectModel
     **/
    SafetyEvaluationProjectModel getSafetyEvaluationProjectById(Long safetyEvaluationProjectId);

    /**
     * @Author Wuxq
     * @Description //   更新发布状态
     * @Date 15:15 2020/11/5
     * @Param [id, type, currentAccountId]
     * @return void
     **/
    void updateIsSureStatus(Long id, Integer type, Long currentAccountId);

    /**
     * @Author Wuxq
     * @Description //   删除/批量删除
     * @Date 15:18 2020/11/5
     * @Param [ids, currentAccountId]
     * @return void
     **/
    void delByBatch(String ids, Long currentAccountId);
}
