/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2020
 */


package cn.smarthse.modules.giian.service.informationPublicity;


import cn.smarthse.modules.giian.entity.informationPublicity.OccupationalHealthProject;
import cn.smarthse.modules.giian.model.informationPublicity.InformationPublicityModel;
import cn.smarthse.modules.giian.model.informationPublicity.OccupationalHealthProjectModel;
import cn.smarthse.modules.giian.model.informationPublicity.OccupationalHealthProjectSearchModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 *
 *
 *
 *
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @author <开发者>
 * @since 2020-11-04 01:18
 */
public interface IOccupationalHealthProjectService extends IBaseService<OccupationalHealthProject> {

    /**
     * @Author Wuxq
     * @Description //  发布/存草稿（新增修改保存）
     * @Date 14:17 2020/11/4
     * @Param [occupationalHealthProject, currentAccountId]
     * @return void
     **/
    void saveOccupationalHealthProject(OccupationalHealthProjectModel model, Long currentAccountId);

    /**
     * @Author Wuxq
     * @Description //  职业卫生项目列表分页数据
     * @Date 15:09 2020/11/4
     * @Param [searchModel]
     * @return com.github.pagehelper.PageInfo<cn.smarthse.modules.giian.entity.informationPublicity.OccupationalHealthProject>
     **/
    PageInfo<OccupationalHealthProjectModel> getOccupationalHealthProjectPageData(OccupationalHealthProjectSearchModel searchModel);

    /**
     * @Author Wuxq
     * @Description //  职业卫生项目数据
     * @Date 15:25 2020/11/4
     * @Param [searchModel]
     * @return java.util.List<cn.smarthse.modules.giian.entity.informationPublicity.OccupationalHealthProject>
     **/
    List<OccupationalHealthProjectModel> getOccupationalHealthProjectList(OccupationalHealthProjectSearchModel searchModel);

    /**
     * @Author Wuxq
     * @Description //  根据 id 查询项目详情
     * @Date 10:02 2020/11/5
     * @Param [occupationalHealthProjectId]
     * @return cn.smarthse.modules.giian.entity.business.ServiceScope
     **/
    OccupationalHealthProjectModel getOccupationalHealthProjectById(Long occupationalHealthProjectId);

    /**
     * @Author Wuxq
     * @Description //  更新发布状态
     * @Date 10:19 2020/11/5
     * @Param [id, type, currentAccountId]
     * @return void
     **/
    void updateIsSureStatus(Long id, Integer type, Long currentAccountId);

    /**
     * @Author Wuxq
     * @Description //  批量删除
     * @Date 10:35 2020/11/5
     * @Param [ids, currentAccountId]
     * @return void
     **/
    void delByBatch(String ids, Long currentAccountId);

	/**
	 * 查询查询信息公示列表分页数据(分为两种："1：职业卫生信息评价项目信息公示）2：安全评价项目信息公示")
	 * @author liaoly
	 * @date 2020年11月11日 上午9:16:27
	 * @param param
	 * @return PageInfo<InformationPublicityModel>
	 */
	PageInfo<InformationPublicityModel> getInformationPublicityModelListData_www(OccupationalHealthProjectSearchModel param);
}
