
package cn.smarthse.modules.giian.service.home;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.giian.entity.home.Home;
import cn.smarthse.modules.giian.model.home.HomeModel;
import cn.smarthse.modules.giian.model.home.HomeQueryParam;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 建安首页service
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月3日 下午3:05:35
 */
public interface IHomeService extends IBaseService<Home>{

	/**
	 * 查询历次的首页数据
	 * @author liaoly
	 * @date 2020年11月3日 下午3:13:45
	 * @param logQueryParam : 综合查询参数对象
	 * @return PageInfo<HomeModel>
	 */
	List<HomeModel> getHomeList(HomeQueryParam logQueryParam);
	
	/**
	 * 查询历次的首页数据
	 * @author liaoly
	 * @date 2020年11月3日 下午3:13:45
	 * @param logQueryParam : 综合查询参数对象
	 * @return PageInfo<HomeModel>
	 */
	PageInfo<HomeModel> getHomeListData(HomeQueryParam logQueryParam);

	/**
	 * 查询最新的首页配置
	 * @author liaoly
	 * @date 2020年11月3日 下午3:57:27
	 * @return HomeModel
	 */
	HomeModel getHomeModel();

	/**
	 * 保存首页配置(id为空则查询现有的数据；没查询到则添加，否则更新；id非空则update)
	 * @author liaoly
	 * @date 2020年11月3日 下午4:16:46
	 * @param homeModel : 参数对象
	 * void
	 */
	void saveHomeModel(Home home);

}
