/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2020
 */


package cn.smarthse.modules.giian.service.business;

import cn.smarthse.modules.giian.entity.business.ClientCase;
import cn.smarthse.modules.giian.model.business.ClientCaseModel;
import cn.smarthse.modules.giian.model.business.ClientCaseSearchModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;
import com.github.pagehelper.PageInfo;

import java.util.List;


/**
 *
 *
 *
 *
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @author <开发者>
 * @since 2020-11-03 02:23
 */
public interface IClientCaseService extends IBaseService<ClientCase> {

    /**
     * 查询客户案例列表分页数据
     * @author haosw
     * @date 2020/11/3 15:05
     * @param searchModel:
     * @return
    */
    PageInfo<ClientCaseModel> getClientCasePageData(ClientCaseSearchModel searchModel);

    /**
     * 查询客户案例数据
     * @author haosw
     * @date 2020/11/3 15:06
     * @param searchModel:
     * @return
    */
    List<ClientCaseModel> getClientCaseList(ClientCaseSearchModel searchModel);

    /**
     * 保存、新增或修改
     * @author haosw
     * @date 2020/11/3 16:33
     * @param clientCaseModel:
     * @param currentAccountId:
     * @return
    */
    void saveClientCase(ClientCaseModel clientCaseModel, Long currentAccountId);

    /**
     * 根据id删除
     * @author haosw
     * @date 2020/11/3 16:56
     * @param id:
     * @param delUserId:
     * @return
    */
    int delClientCaseById(Long id,Long delUserId);

    /**
     * 批量删除
     * @author haosw
     * @date 2020/11/3 16:50
     * @param ids:
     * @param delUserId:
     * @return
    */
    void delByBatch(String ids, Long delUserId);

    /**
     * 根据id查询
     * @author haosw
     * @date 2020/11/4 8:56
     * @param clientCaseId:
     * @return
    */
    ClientCase getClientCaseById(Long clientCaseId);

    /**
     * 根据id查询
     * @author haosw
     * @date 2020/11/16 11:30
     * @param clientCaseId:
     * @return
    */
    ClientCaseModel getClientCaseModelById(Long clientCaseId);

    /**
     * 设置或取消首页展示(根据ids,多个id以,分割）
     * @author haosw
     * @date 2020/11/4 9:12
     * @param ids:
     * @param type:
     * @param currentAccountId:
     * @return
    */
    void setHomeShow(String ids,Integer type, Long currentAccountId);

    /**
     * 发布或存草稿根据id
     * @author haosw
     * @date 2020/11/4 9:21
     * @param id: 
     * @param type: 
     * @param currentAccountId: 
     * @return
    */
    void updateIssueStatus(Long id,Integer type, Long currentAccountId);

    /**
     * 排序调整
     * @author haosw
     * @date 2020/11/16 14:47
     * @param id: 客户案例id
     * @param up_dwon: 状态标志位(1：未使用；2：使用中)
     * @param adminId: 操作账号id
     * @return
    */
    void sort(Long id, Integer up_dwon, Long adminId);
}
