
package cn.smarthse.modules.giian.service.aboutGiian;

import java.util.List;

import cn.smarthse.modules.giian.entity.aboutGiian.AboutUsPic;
import cn.smarthse.modules.giian.model.aboutGiian.AboutUsPicModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 关于建安_关于我们_宣传图
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月16日 下午3:12:58
 */
public interface IAboutUsPicService extends IBaseService<AboutUsPic>{

	/**
	 * 保存 关于我们_宣传图(id为空则添加，反之更新)
	 * @author liaoly
	 * @date 2020年11月16日 下午3:22:16
	 * @param aboutUsPicModel void
	 */
	void saveAboutUsPic(AboutUsPicModel aboutUsPicModel);

	/**
	 * 查询  最新的AboutUs的 所有关于我们_宣传图列表
	 * @author liaoly
	 * @date 2020年11月16日 下午3:35:40
	 * @return List<AboutUsPicModel>
	 */
	List<AboutUsPicModel> getAllAboutUsPicList();

	/**
	 * 添加3条系统内置的 关于我们_宣传图 数据
	 * @author liaoly
	 * @date 2020年11月17日 上午11:23:32
	 * @param aboutUsId : aboutUs.id
	 * @param adminId : 操作账号id
	 * void
	 */
	void addDefaultAboutUsPic(Long aboutUsId, Long adminId);

	/**
	 * 删除
	 * @author liaoly
	 * @date 2020年11月18日 上午9:28:12
	 * @param aboutUsPicId : 关于我们_宣传图id
	 * @param adminId : 操作账号id
	 * @param adminName : 操作账号昵称
	 * void
	 */
	void delAboutUsPic(Long aboutUsPicId, Long adminId, String adminName);
}
