package cn.smarthse.modules.giian.model.informationPublicity;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * www 查询信息公示的结果model
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月11日 上午8:56:17
 */
public @Data class InformationPublicityModel implements Serializable {
	
	private static final long serialVersionUID = 1517731186139381130L;
	
	@ApiModelProperty(value = "项目id")
	private Long id;
	
	@ApiModelProperty(value = "项目名称")
	private String projectName;
	
	@ApiModelProperty(value = "项目类型（1：职业卫生信息评价项目信息公示）2：安全评价项目信息公示")
	private Integer projecType;
	
	@ApiModelProperty(value = "项目类型（1：职业卫生信息评价项目信息公示）2：安全评价项目信息公示")
	private String projecTypeName;
	
	@ApiModelProperty(value = "采样、检测人员")
	private String samplingCheckMan;
	
	@ApiModelProperty(value = "采样、检测时间")
	private String samplingCheckTime;
	
	@ApiModelProperty(value = "发布时间")
	private Date issureTime;
	
	@ApiModelProperty(value = "行业类别")
	private String industry;
	
	@ApiModelProperty(value = "报告提交时间")
	private Date reportSubmitTime;
	
	public void setProjecType(Integer projectType) {
		
		this.projecType = projectType;
		if (projecType == null) {
			return;
		}
		if (projectType == 1) { //1：职业卫生信息评价项目信息公示）2：安全评价项目信息公示
			this.projecTypeName = "职业卫生信息评价项目信息公示";
		} else if (projectType == 2) {
			this.projecTypeName = "安全评价项目信息公示";
		}
	}
}
