package cn.smarthse.modules.giian.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

import cn.smarthse.modules.giian.enums.business.BusinessTypeEnum;

/**
 * 修改记录枚举(表示来自哪个表的数据)
 * @author wuxq
 * @date 2020/11/6 14:00
*/
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum GiianlogEnum {
    // 1、职业卫生 2、放射卫生 3、公共卫生 4、安全 5、环境 6、其他,
    home("首页", "home"),
    about_us("关于建安_关于我们", "about_us");
    //成员变量
    private String name;
	
    private String value;

    private GiianlogEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    //普通方法
    public static String getName(String value){
        if(value == null){
            return null;
        }
        for(BusinessTypeEnum c: BusinessTypeEnum.values()){
            if(c.getCode().equals(value)){
                return c.getName();
            }
        }
        return null;
    }
    
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
