package cn.smarthse.modules.giian.enums.business;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 客户案例中的客户行业
 * @author haosw
 * @date 2020/11/4 14:00
*/
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum ClientTradeEnum {
    //0、集团 1、建筑 2、轨道 3、化工 4、烟草 5、港口 6、汽车 7、政府 8、其他
    Bloc("集团",0),
    Build("建筑",1),
    Orbit("轨道",2),
    Chemical("化工",3),
    Tobacoo("烟草",4),
    Port("港口",5),
    Car("汽车",6),
    Government("政府",7),
    Other("其他",8),
    ;
    //成员变量
    private String name;
    private Integer code;

    private ClientTradeEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    //普通方法
    public static String getName(Integer code){
        if(code == null){
            return null;
        }
        for(ClientTradeEnum c:ClientTradeEnum.values()){
            if(c.getCode().equals(code)){
                return c.getName();
            }
        }
        return null;
    }

    //普通方法
    public static Integer getCodeByName(String name){
        if(name == null || "".equals(name)){
            return null;
        }
        for(ClientTradeEnum c:ClientTradeEnum.values()){
            if(c.getName().equals(name)){
                return c.getCode();
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
