package cn.smarthse.modules.giian.enums.business;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 业务类型数据
 * @author wuxq
 * @date 2020/11/6 14:00
*/
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum BusinessTypeEnum {
    // 1、职业卫生 2、放射卫生 3、公共卫生 4、安全 5、环境 6、其他,
    OCCUPATIONAL_HEALTH("职业卫生",1),
    RADIOLOGICAL_HEALTH("放射卫生",2),
    PUBLIC_HEALTH("公共卫生",3),
    SAFETY("安全",4),
    ENVIRONMENT("环境",5),
    OTHER("其他",0);
    //成员变量
    private String name;
    private Integer code;

    private BusinessTypeEnum(String name, Integer code) {
        this.name = name;
        this.code = code;
    }

    //普通方法
    public static String getName(Integer code){
        if(code == null){
            return null;
        }
        for(BusinessTypeEnum c: BusinessTypeEnum.values()){
            if(c.getCode().equals(code)){
                return c.getName();
            }
        }
        return null;
    }

    //普通方法
    public static Integer getCodeByName(String name){
        if(name == null || "".equals(name)){
            return null;
        }
        for(BusinessTypeEnum c: BusinessTypeEnum.values()){
            if(c.getName().equals(name)){
                return c.getCode();
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
