
package cn.smarthse.modules.giian.entity.home;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.modules.giian.model.sys.Giianlog;
import lombok.Data;

/**
 * 建安首页
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月3日 下午3:03:12
 */
@Table(name = "home")
public @Data class Home implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
	private Long id;
	/**
	 * 状态(1：草稿；2：发布)
	 */
	private Integer status;
	/**
	 * 大标题
	 */
	@Giianlog(title="大标题")
	private String title;
	/**
	 * 副标题
	 */
	@Giianlog(title="副标题")
	private String subtitle;
	/**
	 * banner背景图
	 */
	@Giianlog(title="banner背景图")
	private String bannerBgPic;
	/**
	 * 建安简介_右侧配图
	 */
	@Giianlog(title="建安简介_右侧配图")
	private String briefRightPic;
	/**
	 * 建安简介_建安简介
	 */
	@Giianlog(title="建安简介_建安简介")
	private String briefIntroduction;
	/**
	 * 中部banner图
	 */
	@Giianlog(title="中部banner图")
	private String centerBannerPic;
	/**
	 * 联系我们
	 */
	@Giianlog(title="联系我们")
	private String connect;
	/**
	 * 修改人
	 */
	@Transient
	private String updator;
	/**
	 * 创建人
	 */
	private Long createBy;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 更新时间
	 */
	private Long updateBy;
	/**
	 * 更新人
	 */
	private java.util.Date updateDate;
	/**
	 * 是否有效
	 */
	private Boolean isValid;


}
