package cn.smarthse.modules.giian.entity.business;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


 /**
 *
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @author <开发者>
 * @since 2020-11-02 09:35
 */
@Table(name = "service_scope")
public @Data class ServiceScope implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;
	/**
	 * 业务名称
	 */
	private String businessName;
	/**
	 * 业务类型
	 */
	private String businessType;
	/**
	 * 服务区域
	 */
	private String serviceArea;
	 /**
	  * 服务区域
	  */
	 private String serviceAreaName;
	/**
	 * 联系人
	 */
	private String linkman;
	/**
	 * 联系电话
	 */
	private String linkmanTel;
	/**
	 * 摘要
	 */
	private String abstractContent;
	/**
	 * 文章内容
	 */
	private String articleContent;
	/**
	 * 配图
	 */
	private String fileUrl;
	/**
	 * 发布状态：0，未发布（默认）；1，已发布
	 */
	private Integer issureStatus;
	/**
	 * 首页展示：0，未展示；1，已展示
	 */
	private Integer topPage;
	/**
	 * 创建人
	 */
	private Long createBy;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 最后修改人ID
	 */
	private Long updateBy;
	/**
	 * 最后修改时间
	 */
	private Date updateDate;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
	private Boolean isValid;


}
