package cn.smarthse.modules.giian.entity.aboutGiian;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @author yangzp
 * @since 2020-11-03 13:46
 */
@Table(name = "honor_qualification")
public @Data class HonorQualification implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 图片url
     */
    private String fileUrl;
    /**
     * 资质证书名称
     */
    private String certificateName;
    /**
     * 发布状态：0，草稿（默认）；1，已发布
     */
    private Byte certificateStatus;
    /**
     * 排序值(越大越靠前,0为草稿)
     */
    private Integer sort;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     *创建时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm", timezone="GMT+8")
    private Date createDate;
    /**
     *最后修改人ID
     */
    private Long updateBy;
    /**
     *最后修改时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm", timezone="GMT+8")
    private Date updateDate;
    /**
     *是否有效（0-无效，1-有效）
     */
    private Boolean isValid;
    @Transient
    /**
     * 更新人姓名
     */
    private String updateName;
}