/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.allocation;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AllocationRecord
implements JsonpSerializable {
    @Nullable
    private final String shards;
    @Nullable
    private final String shardsUndesired;
    @Nullable
    private final Double writeLoadForecast;
    @Nullable
    private final String diskIndicesForecast;
    @Nullable
    private final String diskIndices;
    @Nullable
    private final String diskUsed;
    @Nullable
    private final String diskAvail;
    @Nullable
    private final String diskTotal;
    @Nullable
    private final String diskPercent;
    @Nullable
    private final String host;
    @Nullable
    private final String ip;
    @Nullable
    private final String node;
    @Nullable
    private final String nodeRole;
    public static final JsonpDeserializer<AllocationRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationRecord::setupAllocationRecordDeserializer);

    private AllocationRecord(Builder builder) {
        this.shards = builder.shards;
        this.shardsUndesired = builder.shardsUndesired;
        this.writeLoadForecast = builder.writeLoadForecast;
        this.diskIndicesForecast = builder.diskIndicesForecast;
        this.diskIndices = builder.diskIndices;
        this.diskUsed = builder.diskUsed;
        this.diskAvail = builder.diskAvail;
        this.diskTotal = builder.diskTotal;
        this.diskPercent = builder.diskPercent;
        this.host = builder.host;
        this.ip = builder.ip;
        this.node = builder.node;
        this.nodeRole = builder.nodeRole;
    }

    public static AllocationRecord of(Function<Builder, ObjectBuilder<AllocationRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String shards() {
        return this.shards;
    }

    @Nullable
    public final String shardsUndesired() {
        return this.shardsUndesired;
    }

    @Nullable
    public final Double writeLoadForecast() {
        return this.writeLoadForecast;
    }

    @Nullable
    public final String diskIndicesForecast() {
        return this.diskIndicesForecast;
    }

    @Nullable
    public final String diskIndices() {
        return this.diskIndices;
    }

    @Nullable
    public final String diskUsed() {
        return this.diskUsed;
    }

    @Nullable
    public final String diskAvail() {
        return this.diskAvail;
    }

    @Nullable
    public final String diskTotal() {
        return this.diskTotal;
    }

    @Nullable
    public final String diskPercent() {
        return this.diskPercent;
    }

    @Nullable
    public final String host() {
        return this.host;
    }

    @Nullable
    public final String ip() {
        return this.ip;
    }

    @Nullable
    public final String node() {
        return this.node;
    }

    @Nullable
    public final String nodeRole() {
        return this.nodeRole;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.shards != null) {
            generator.writeKey("shards");
            generator.write(this.shards);
        }
        if (this.shardsUndesired != null) {
            generator.writeKey("shards.undesired");
            generator.write(this.shardsUndesired);
        }
        if (this.writeLoadForecast != null) {
            generator.writeKey("write_load.forecast");
            JsonpUtils.serializeDoubleOrNull(generator, this.writeLoadForecast, 0.0);
        }
        if (this.diskIndicesForecast != null) {
            generator.writeKey("disk.indices.forecast");
            generator.write(this.diskIndicesForecast);
        }
        if (this.diskIndices != null) {
            generator.writeKey("disk.indices");
            generator.write(this.diskIndices);
        }
        if (this.diskUsed != null) {
            generator.writeKey("disk.used");
            generator.write(this.diskUsed);
        }
        if (this.diskAvail != null) {
            generator.writeKey("disk.avail");
            generator.write(this.diskAvail);
        }
        if (this.diskTotal != null) {
            generator.writeKey("disk.total");
            generator.write(this.diskTotal);
        }
        if (this.diskPercent != null) {
            generator.writeKey("disk.percent");
            generator.write(this.diskPercent);
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.ip != null) {
            generator.writeKey("ip");
            generator.write(this.ip);
        }
        if (this.node != null) {
            generator.writeKey("node");
            generator.write(this.node);
        }
        if (this.nodeRole != null) {
            generator.writeKey("node.role");
            generator.write(this.nodeRole);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAllocationRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringDeserializer(), "shards", "s");
        op.add(Builder::shardsUndesired, JsonpDeserializer.stringDeserializer(), "shards.undesired");
        op.add(Builder::writeLoadForecast, JsonpDeserializer.doubleOrNullDeserializer(0.0), "write_load.forecast", "wlf", "writeLoadForecast");
        op.add(Builder::diskIndicesForecast, JsonpDeserializer.stringDeserializer(), "disk.indices.forecast", "dif", "diskIndicesForecast");
        op.add(Builder::diskIndices, JsonpDeserializer.stringDeserializer(), "disk.indices", "di", "diskIndices");
        op.add(Builder::diskUsed, JsonpDeserializer.stringDeserializer(), "disk.used", "du", "diskUsed");
        op.add(Builder::diskAvail, JsonpDeserializer.stringDeserializer(), "disk.avail", "da", "diskAvail");
        op.add(Builder::diskTotal, JsonpDeserializer.stringDeserializer(), "disk.total", "dt", "diskTotal");
        op.add(Builder::diskPercent, JsonpDeserializer.stringDeserializer(), "disk.percent", "dp", "diskPercent");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host", "h");
        op.add(Builder::ip, JsonpDeserializer.stringDeserializer(), "ip");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", "n");
        op.add(Builder::nodeRole, JsonpDeserializer.stringDeserializer(), "node.role", "r", "role", "nodeRole");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AllocationRecord> {
        @Nullable
        private String shards;
        @Nullable
        private String shardsUndesired;
        @Nullable
        private Double writeLoadForecast;
        @Nullable
        private String diskIndicesForecast;
        @Nullable
        private String diskIndices;
        @Nullable
        private String diskUsed;
        @Nullable
        private String diskAvail;
        @Nullable
        private String diskTotal;
        @Nullable
        private String diskPercent;
        @Nullable
        private String host;
        @Nullable
        private String ip;
        @Nullable
        private String node;
        @Nullable
        private String nodeRole;

        public final Builder shards(@Nullable String value) {
            this.shards = value;
            return this;
        }

        public final Builder shardsUndesired(@Nullable String value) {
            this.shardsUndesired = value;
            return this;
        }

        public final Builder writeLoadForecast(@Nullable Double value) {
            this.writeLoadForecast = value;
            return this;
        }

        public final Builder diskIndicesForecast(@Nullable String value) {
            this.diskIndicesForecast = value;
            return this;
        }

        public final Builder diskIndices(@Nullable String value) {
            this.diskIndices = value;
            return this;
        }

        public final Builder diskUsed(@Nullable String value) {
            this.diskUsed = value;
            return this;
        }

        public final Builder diskAvail(@Nullable String value) {
            this.diskAvail = value;
            return this;
        }

        public final Builder diskTotal(@Nullable String value) {
            this.diskTotal = value;
            return this;
        }

        public final Builder diskPercent(@Nullable String value) {
            this.diskPercent = value;
            return this;
        }

        public final Builder host(@Nullable String value) {
            this.host = value;
            return this;
        }

        public final Builder ip(@Nullable String value) {
            this.ip = value;
            return this;
        }

        public final Builder node(@Nullable String value) {
            this.node = value;
            return this;
        }

        public final Builder nodeRole(@Nullable String value) {
            this.nodeRole = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AllocationRecord build() {
            this._checkSingleUse();
            return new AllocationRecord(this);
        }
    }
}

