/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cluster.PutComponentTemplateResponse;
import co.elastic.clients.elasticsearch.indices.IndexState;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutComponentTemplateRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, JsonData> meta;
    @Nullable
    private final String cause;
    @Nullable
    private final Boolean create;
    @Nullable
    private final Boolean deprecated;
    @Nullable
    private final Time masterTimeout;
    private final String name;
    private final IndexState template;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<PutComponentTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutComponentTemplateRequest::setupPutComponentTemplateRequestDeserializer);
    public static final Endpoint<PutComponentTemplateRequest, PutComponentTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutComponentTemplateRequest, PutComponentTemplateResponse>("es/cluster.put_component_template", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_component_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.create != null) {
            params.put("create", String.valueOf(request.create));
        }
        if (request.cause != null) {
            params.put("cause", request.cause);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutComponentTemplateResponse._DESERIALIZER);

    private PutComponentTemplateRequest(Builder builder) {
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.cause = builder.cause;
        this.create = builder.create;
        this.deprecated = builder.deprecated;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
        this.version = builder.version;
    }

    public static PutComponentTemplateRequest of(Function<Builder, ObjectBuilder<PutComponentTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final String cause() {
        return this.cause;
    }

    @Nullable
    public final Boolean create() {
        return this.create;
    }

    @Nullable
    public final Boolean deprecated() {
        return this.deprecated;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String name() {
        return this.name;
    }

    public final IndexState template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.deprecated != null) {
            generator.writeKey("deprecated");
            generator.write(this.deprecated.booleanValue());
        }
        generator.writeKey("template");
        this.template.serialize(generator, mapper);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupPutComponentTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::deprecated, JsonpDeserializer.booleanDeserializer(), "deprecated");
        op.add(Builder::template, IndexState._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutComponentTemplateRequest> {
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private String cause;
        @Nullable
        private Boolean create;
        @Nullable
        private Boolean deprecated;
        @Nullable
        private Time masterTimeout;
        private String name;
        private IndexState template;
        @Nullable
        private Long version;

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder cause(@Nullable String value) {
            this.cause = value;
            return this;
        }

        public final Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        public final Builder deprecated(@Nullable Boolean value) {
            this.deprecated = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder template(IndexState value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<IndexState.Builder, ObjectBuilder<IndexState>> fn) {
            return this.template(fn.apply(new IndexState.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutComponentTemplateRequest build() {
            this._checkSingleUse();
            return new PutComponentTemplateRequest(this);
        }
    }
}

