/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.GlobalPrivilege;
import co.elastic.clients.elasticsearch.security.RemoteClusterPrivileges;
import co.elastic.clients.elasticsearch.security.RemoteUserIndicesPrivileges;
import co.elastic.clients.elasticsearch.security.UserIndicesPrivileges;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetUserPrivilegesResponse
implements JsonpSerializable {
    private final List<ApplicationPrivileges> applications;
    private final List<String> cluster;
    private final List<RemoteClusterPrivileges> remoteCluster;
    private final List<GlobalPrivilege> global;
    private final List<UserIndicesPrivileges> indices;
    private final List<RemoteUserIndicesPrivileges> remoteIndices;
    private final List<String> runAs;
    public static final JsonpDeserializer<GetUserPrivilegesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetUserPrivilegesResponse::setupGetUserPrivilegesResponseDeserializer);

    private GetUserPrivilegesResponse(Builder builder) {
        this.applications = ApiTypeHelper.unmodifiableRequired(builder.applications, (Object)this, "applications");
        this.cluster = ApiTypeHelper.unmodifiableRequired(builder.cluster, (Object)this, "cluster");
        this.remoteCluster = ApiTypeHelper.unmodifiable(builder.remoteCluster);
        this.global = ApiTypeHelper.unmodifiableRequired(builder.global, (Object)this, "global");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.remoteIndices = ApiTypeHelper.unmodifiable(builder.remoteIndices);
        this.runAs = ApiTypeHelper.unmodifiableRequired(builder.runAs, (Object)this, "runAs");
    }

    public static GetUserPrivilegesResponse of(Function<Builder, ObjectBuilder<GetUserPrivilegesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final List<RemoteClusterPrivileges> remoteCluster() {
        return this.remoteCluster;
    }

    public final List<GlobalPrivilege> global() {
        return this.global;
    }

    public final List<UserIndicesPrivileges> indices() {
        return this.indices;
    }

    public final List<RemoteUserIndicesPrivileges> remoteIndices() {
        return this.remoteIndices;
    }

    public final List<String> runAs() {
        return this.runAs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.applications)) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteCluster)) {
            generator.writeKey("remote_cluster");
            generator.writeStartArray();
            for (RemoteClusterPrivileges remoteClusterPrivileges : this.remoteCluster) {
                remoteClusterPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.global)) {
            generator.writeKey("global");
            generator.writeStartArray();
            for (GlobalPrivilege globalPrivilege : this.global) {
                globalPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (UserIndicesPrivileges userIndicesPrivileges : this.indices) {
                userIndicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteIndices)) {
            generator.writeKey("remote_indices");
            generator.writeStartArray();
            for (RemoteUserIndicesPrivileges remoteUserIndicesPrivileges : this.remoteIndices) {
                remoteUserIndicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.runAs)) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetUserPrivilegesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications");
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(Builder::remoteCluster, JsonpDeserializer.arrayDeserializer(RemoteClusterPrivileges._DESERIALIZER), "remote_cluster");
        op.add(Builder::global, JsonpDeserializer.arrayDeserializer(GlobalPrivilege._DESERIALIZER), "global");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(UserIndicesPrivileges._DESERIALIZER), "indices");
        op.add(Builder::remoteIndices, JsonpDeserializer.arrayDeserializer(RemoteUserIndicesPrivileges._DESERIALIZER), "remote_indices");
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetUserPrivilegesResponse> {
        private List<ApplicationPrivileges> applications;
        private List<String> cluster;
        @Nullable
        private List<RemoteClusterPrivileges> remoteCluster;
        private List<GlobalPrivilege> global;
        private List<UserIndicesPrivileges> indices;
        @Nullable
        private List<RemoteUserIndicesPrivileges> remoteIndices;
        private List<String> runAs;

        public final Builder applications(List<ApplicationPrivileges> list) {
            this.applications = Builder._listAddAll(this.applications, list);
            return this;
        }

        public final Builder applications(ApplicationPrivileges value, ApplicationPrivileges ... values) {
            this.applications = Builder._listAdd(this.applications, value, values);
            return this;
        }

        public final Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build(), new ApplicationPrivileges[0]);
        }

        public final Builder cluster(List<String> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(String value, String ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder remoteCluster(List<RemoteClusterPrivileges> list) {
            this.remoteCluster = Builder._listAddAll(this.remoteCluster, list);
            return this;
        }

        public final Builder remoteCluster(RemoteClusterPrivileges value, RemoteClusterPrivileges ... values) {
            this.remoteCluster = Builder._listAdd(this.remoteCluster, value, values);
            return this;
        }

        public final Builder remoteCluster(Function<RemoteClusterPrivileges.Builder, ObjectBuilder<RemoteClusterPrivileges>> fn) {
            return this.remoteCluster(fn.apply(new RemoteClusterPrivileges.Builder()).build(), new RemoteClusterPrivileges[0]);
        }

        public final Builder global(List<GlobalPrivilege> list) {
            this.global = Builder._listAddAll(this.global, list);
            return this;
        }

        public final Builder global(GlobalPrivilege value, GlobalPrivilege ... values) {
            this.global = Builder._listAdd(this.global, value, values);
            return this;
        }

        public final Builder global(Function<GlobalPrivilege.Builder, ObjectBuilder<GlobalPrivilege>> fn) {
            return this.global(fn.apply(new GlobalPrivilege.Builder()).build(), new GlobalPrivilege[0]);
        }

        public final Builder indices(List<UserIndicesPrivileges> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(UserIndicesPrivileges value, UserIndicesPrivileges ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<UserIndicesPrivileges.Builder, ObjectBuilder<UserIndicesPrivileges>> fn) {
            return this.indices(fn.apply(new UserIndicesPrivileges.Builder()).build(), new UserIndicesPrivileges[0]);
        }

        public final Builder remoteIndices(List<RemoteUserIndicesPrivileges> list) {
            this.remoteIndices = Builder._listAddAll(this.remoteIndices, list);
            return this;
        }

        public final Builder remoteIndices(RemoteUserIndicesPrivileges value, RemoteUserIndicesPrivileges ... values) {
            this.remoteIndices = Builder._listAdd(this.remoteIndices, value, values);
            return this;
        }

        public final Builder remoteIndices(Function<RemoteUserIndicesPrivileges.Builder, ObjectBuilder<RemoteUserIndicesPrivileges>> fn) {
            return this.remoteIndices(fn.apply(new RemoteUserIndicesPrivileges.Builder()).build(), new RemoteUserIndicesPrivileges[0]);
        }

        public final Builder runAs(List<String> list) {
            this.runAs = Builder._listAddAll(this.runAs, list);
            return this;
        }

        public final Builder runAs(String value, String ... values) {
            this.runAs = Builder._listAdd(this.runAs, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetUserPrivilegesResponse build() {
            this._checkSingleUse();
            return new GetUserPrivilegesResponse(this);
        }
    }
}

