/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration.deprecations;

import co.elastic.clients.elasticsearch.migration.deprecations.DeprecationLevel;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Deprecation
implements JsonpSerializable {
    private final String details;
    private final DeprecationLevel level;
    private final String message;
    private final String url;
    public static final JsonpDeserializer<Deprecation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Deprecation::setupDeprecationDeserializer);

    private Deprecation(Builder builder) {
        this.details = ApiTypeHelper.requireNonNull(builder.details, this, "details");
        this.level = ApiTypeHelper.requireNonNull(builder.level, this, "level");
        this.message = ApiTypeHelper.requireNonNull(builder.message, this, "message");
        this.url = ApiTypeHelper.requireNonNull(builder.url, this, "url");
    }

    public static Deprecation of(Function<Builder, ObjectBuilder<Deprecation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String details() {
        return this.details;
    }

    public final DeprecationLevel level() {
        return this.level;
    }

    public final String message() {
        return this.message;
    }

    public final String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("details");
        generator.write(this.details);
        generator.writeKey("level");
        this.level.serialize(generator, mapper);
        generator.writeKey("message");
        generator.write(this.message);
        generator.writeKey("url");
        generator.write(this.url);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDeprecationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::details, JsonpDeserializer.stringDeserializer(), "details");
        op.add(Builder::level, DeprecationLevel._DESERIALIZER, "level");
        op.add(Builder::message, JsonpDeserializer.stringDeserializer(), "message");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Deprecation> {
        private String details;
        private DeprecationLevel level;
        private String message;
        private String url;

        public final Builder details(String value) {
            this.details = value;
            return this;
        }

        public final Builder level(DeprecationLevel value) {
            this.level = value;
            return this;
        }

        public final Builder message(String value) {
            this.message = value;
            return this;
        }

        public final Builder url(String value) {
            this.url = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Deprecation build() {
            this._checkSingleUse();
            return new Deprecation(this);
        }
    }
}

