/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.analyze.AnalyzeDetail;
import co.elastic.clients.elasticsearch.indices.analyze.AnalyzeToken;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnalyzeResponse
implements JsonpSerializable {
    @Nullable
    private final AnalyzeDetail detail;
    private final List<AnalyzeToken> tokens;
    public static final JsonpDeserializer<AnalyzeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeResponse::setupAnalyzeResponseDeserializer);

    private AnalyzeResponse(Builder builder) {
        this.detail = builder.detail;
        this.tokens = ApiTypeHelper.unmodifiable(builder.tokens);
    }

    public static AnalyzeResponse of(Function<Builder, ObjectBuilder<AnalyzeResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AnalyzeDetail detail() {
        return this.detail;
    }

    public final List<AnalyzeToken> tokens() {
        return this.tokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.detail != null) {
            generator.writeKey("detail");
            this.detail.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.tokens)) {
            generator.writeKey("tokens");
            generator.writeStartArray();
            for (AnalyzeToken item0 : this.tokens) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAnalyzeResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::detail, AnalyzeDetail._DESERIALIZER, "detail");
        op.add(Builder::tokens, JsonpDeserializer.arrayDeserializer(AnalyzeToken._DESERIALIZER), "tokens");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnalyzeResponse> {
        @Nullable
        private AnalyzeDetail detail;
        @Nullable
        private List<AnalyzeToken> tokens;

        public final Builder detail(@Nullable AnalyzeDetail value) {
            this.detail = value;
            return this;
        }

        public final Builder detail(Function<AnalyzeDetail.Builder, ObjectBuilder<AnalyzeDetail>> fn) {
            return this.detail(fn.apply(new AnalyzeDetail.Builder()).build());
        }

        public final Builder tokens(List<AnalyzeToken> list) {
            this.tokens = Builder._listAddAll(this.tokens, list);
            return this;
        }

        public final Builder tokens(AnalyzeToken value, AnalyzeToken ... values) {
            this.tokens = Builder._listAdd(this.tokens, value, values);
            return this;
        }

        public final Builder tokens(Function<AnalyzeToken.Builder, ObjectBuilder<AnalyzeToken>> fn) {
            return this.tokens(fn.apply(new AnalyzeToken.Builder()).build(), new AnalyzeToken[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnalyzeResponse build() {
            this._checkSingleUse();
            return new AnalyzeResponse(this);
        }
    }
}

