/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.AllocationExplainDecision;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class AllocationDecision
implements JsonpSerializable {
    private final String decider;
    private final AllocationExplainDecision decision;
    private final String explanation;
    public static final JsonpDeserializer<AllocationDecision> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationDecision::setupAllocationDecisionDeserializer);

    private AllocationDecision(Builder builder) {
        this.decider = ApiTypeHelper.requireNonNull(builder.decider, this, "decider");
        this.decision = ApiTypeHelper.requireNonNull(builder.decision, this, "decision");
        this.explanation = ApiTypeHelper.requireNonNull(builder.explanation, this, "explanation");
    }

    public static AllocationDecision of(Function<Builder, ObjectBuilder<AllocationDecision>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String decider() {
        return this.decider;
    }

    public final AllocationExplainDecision decision() {
        return this.decision;
    }

    public final String explanation() {
        return this.explanation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("decider");
        generator.write(this.decider);
        generator.writeKey("decision");
        this.decision.serialize(generator, mapper);
        generator.writeKey("explanation");
        generator.write(this.explanation);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAllocationDecisionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::decider, JsonpDeserializer.stringDeserializer(), "decider");
        op.add(Builder::decision, AllocationExplainDecision._DESERIALIZER, "decision");
        op.add(Builder::explanation, JsonpDeserializer.stringDeserializer(), "explanation");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AllocationDecision> {
        private String decider;
        private AllocationExplainDecision decision;
        private String explanation;

        public final Builder decider(String value) {
            this.decider = value;
            return this;
        }

        public final Builder decision(AllocationExplainDecision value) {
            this.decision = value;
            return this;
        }

        public final Builder explanation(String value) {
            this.explanation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AllocationDecision build() {
            this._checkSingleUse();
            return new AllocationDecision(this);
        }
    }
}

