/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TokenPruningConfig
implements JsonpSerializable {
    @Nullable
    private final Integer tokensFreqRatioThreshold;
    @Nullable
    private final Float tokensWeightThreshold;
    @Nullable
    private final Boolean onlyScorePrunedTokens;
    public static final JsonpDeserializer<TokenPruningConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TokenPruningConfig::setupTokenPruningConfigDeserializer);

    private TokenPruningConfig(Builder builder) {
        this.tokensFreqRatioThreshold = builder.tokensFreqRatioThreshold;
        this.tokensWeightThreshold = builder.tokensWeightThreshold;
        this.onlyScorePrunedTokens = builder.onlyScorePrunedTokens;
    }

    public static TokenPruningConfig of(Function<Builder, ObjectBuilder<TokenPruningConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer tokensFreqRatioThreshold() {
        return this.tokensFreqRatioThreshold;
    }

    @Nullable
    public final Float tokensWeightThreshold() {
        return this.tokensWeightThreshold;
    }

    @Nullable
    public final Boolean onlyScorePrunedTokens() {
        return this.onlyScorePrunedTokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.tokensFreqRatioThreshold != null) {
            generator.writeKey("tokens_freq_ratio_threshold");
            generator.write(this.tokensFreqRatioThreshold.intValue());
        }
        if (this.tokensWeightThreshold != null) {
            generator.writeKey("tokens_weight_threshold");
            generator.write((double)this.tokensWeightThreshold.floatValue());
        }
        if (this.onlyScorePrunedTokens != null) {
            generator.writeKey("only_score_pruned_tokens");
            generator.write(this.onlyScorePrunedTokens.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTokenPruningConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::tokensFreqRatioThreshold, JsonpDeserializer.integerDeserializer(), "tokens_freq_ratio_threshold");
        op.add(Builder::tokensWeightThreshold, JsonpDeserializer.floatDeserializer(), "tokens_weight_threshold");
        op.add(Builder::onlyScorePrunedTokens, JsonpDeserializer.booleanDeserializer(), "only_score_pruned_tokens");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TokenPruningConfig> {
        @Nullable
        private Integer tokensFreqRatioThreshold;
        @Nullable
        private Float tokensWeightThreshold;
        @Nullable
        private Boolean onlyScorePrunedTokens;

        public final Builder tokensFreqRatioThreshold(@Nullable Integer value) {
            this.tokensFreqRatioThreshold = value;
            return this;
        }

        public final Builder tokensWeightThreshold(@Nullable Float value) {
            this.tokensWeightThreshold = value;
            return this;
        }

        public final Builder onlyScorePrunedTokens(@Nullable Boolean value) {
            this.onlyScorePrunedTokens = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TokenPruningConfig build() {
            this._checkSingleUse();
            return new TokenPruningConfig(this);
        }
    }
}

