/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.NumberPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UnsignedLongNumberProperty
extends NumberPropertyBase
implements PropertyVariant {
    @Nullable
    private final Number nullValue;
    public static final JsonpDeserializer<UnsignedLongNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UnsignedLongNumberProperty::setupUnsignedLongNumberPropertyDeserializer);

    private UnsignedLongNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static UnsignedLongNumberProperty of(Function<Builder, ObjectBuilder<UnsignedLongNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.UnsignedLong;
    }

    @Nullable
    public final Number nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "unsigned_long");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.doubleValue());
        }
    }

    protected static void setupUnsignedLongNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        NumberPropertyBase.setupNumberPropertyBaseDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.numberDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends NumberPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UnsignedLongNumberProperty> {
        @Nullable
        private Number nullValue;

        public final Builder nullValue(@Nullable Number value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UnsignedLongNumberProperty build() {
            this._checkSingleUse();
            return new UnsignedLongNumberProperty(this);
        }
    }
}

