/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class TimeSeriesBucket
extends MultiBucketBase {
    private final Map<String, FieldValue> key;
    public static final JsonpDeserializer<TimeSeriesBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeSeriesBucket::setupTimeSeriesBucketDeserializer);

    private TimeSeriesBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.unmodifiableRequired(builder.key, (Object)this, "key");
    }

    public static TimeSeriesBucket of(Function<Builder, ObjectBuilder<TimeSeriesBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, FieldValue> key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.key)) {
            generator.writeKey("key");
            generator.writeStartObject();
            for (Map.Entry<String, FieldValue> item0 : this.key.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTimeSeriesBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.stringMapDeserializer(FieldValue._DESERIALIZER), "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TimeSeriesBucket> {
        private Map<String, FieldValue> key;

        public final Builder key(Map<String, FieldValue> map) {
            this.key = Builder._mapPutAll(this.key, map);
            return this;
        }

        public final Builder key(String key, FieldValue value) {
            this.key = Builder._mapPut(this.key, key, value);
            return this;
        }

        public final Builder key(String key, Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.key(key, fn.apply(new FieldValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TimeSeriesBucket build() {
            this._checkSingleUse();
            return new TimeSeriesBucket(this);
        }
    }
}

