/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch.watcher.Action;
import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.Trigger;
import co.elastic.clients.elasticsearch.watcher.WatchStatus;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Watch
implements JsonpSerializable {
    private final Map<String, Action> actions;
    private final Condition condition;
    private final Input input;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final WatchStatus status;
    @Nullable
    private final String throttlePeriod;
    @Nullable
    private final Transform transform;
    private final Trigger trigger;
    @Nullable
    private final Long throttlePeriodInMillis;
    public static final JsonpDeserializer<Watch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Watch::setupWatchDeserializer);

    private Watch(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiableRequired(builder.actions, (Object)this, "actions");
        this.condition = ApiTypeHelper.requireNonNull(builder.condition, this, "condition");
        this.input = ApiTypeHelper.requireNonNull(builder.input, this, "input");
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.status = builder.status;
        this.throttlePeriod = builder.throttlePeriod;
        this.transform = builder.transform;
        this.trigger = ApiTypeHelper.requireNonNull(builder.trigger, this, "trigger");
        this.throttlePeriodInMillis = builder.throttlePeriodInMillis;
    }

    public static Watch of(Function<Builder, ObjectBuilder<Watch>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Action> actions() {
        return this.actions;
    }

    public final Condition condition() {
        return this.condition;
    }

    public final Input input() {
        return this.input;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final WatchStatus status() {
        return this.status;
    }

    @Nullable
    public final String throttlePeriod() {
        return this.throttlePeriod;
    }

    @Nullable
    public final Transform transform() {
        return this.transform;
    }

    public final Trigger trigger() {
        return this.trigger;
    }

    @Nullable
    public final Long throttlePeriodInMillis() {
        return this.throttlePeriodInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartObject();
            for (Map.Entry<String, Action> entry : this.actions.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("condition");
        this.condition.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        if (this.throttlePeriod != null) {
            generator.writeKey("throttle_period");
            generator.write(this.throttlePeriod);
        }
        if (this.transform != null) {
            generator.writeKey("transform");
            this.transform.serialize(generator, mapper);
        }
        generator.writeKey("trigger");
        this.trigger.serialize(generator, mapper);
        if (this.throttlePeriodInMillis != null) {
            generator.writeKey("throttle_period_in_millis");
            generator.write(this.throttlePeriodInMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupWatchDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(Action._DESERIALIZER), "actions");
        op.add(Builder::condition, Condition._DESERIALIZER, "condition");
        op.add(Builder::input, Input._DESERIALIZER, "input");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::status, WatchStatus._DESERIALIZER, "status");
        op.add(Builder::throttlePeriod, JsonpDeserializer.stringDeserializer(), "throttle_period");
        op.add(Builder::transform, Transform._DESERIALIZER, "transform");
        op.add(Builder::trigger, Trigger._DESERIALIZER, "trigger");
        op.add(Builder::throttlePeriodInMillis, JsonpDeserializer.longDeserializer(), "throttle_period_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Watch> {
        private Map<String, Action> actions;
        private Condition condition;
        private Input input;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private WatchStatus status;
        @Nullable
        private String throttlePeriod;
        @Nullable
        private Transform transform;
        private Trigger trigger;
        @Nullable
        private Long throttlePeriodInMillis;

        public final Builder actions(Map<String, Action> map) {
            this.actions = Builder._mapPutAll(this.actions, map);
            return this;
        }

        public final Builder actions(String key, Action value) {
            this.actions = Builder._mapPut(this.actions, key, value);
            return this;
        }

        public final Builder actions(String key, Function<Action.Builder, ObjectBuilder<Action>> fn) {
            return this.actions(key, fn.apply(new Action.Builder()).build());
        }

        public final Builder condition(Condition value) {
            this.condition = value;
            return this;
        }

        public final Builder condition(Function<Condition.Builder, ObjectBuilder<Condition>> fn) {
            return this.condition(fn.apply(new Condition.Builder()).build());
        }

        public final Builder input(Input value) {
            this.input = value;
            return this;
        }

        public final Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder status(@Nullable WatchStatus value) {
            this.status = value;
            return this;
        }

        public final Builder status(Function<WatchStatus.Builder, ObjectBuilder<WatchStatus>> fn) {
            return this.status(fn.apply(new WatchStatus.Builder()).build());
        }

        public final Builder throttlePeriod(@Nullable String value) {
            this.throttlePeriod = value;
            return this;
        }

        public final Builder transform(@Nullable Transform value) {
            this.transform = value;
            return this;
        }

        public final Builder transform(Function<Transform.Builder, ObjectBuilder<Transform>> fn) {
            return this.transform(fn.apply(new Transform.Builder()).build());
        }

        public final Builder trigger(Trigger value) {
            this.trigger = value;
            return this;
        }

        public final Builder trigger(Function<Trigger.Builder, ObjectBuilder<Trigger>> fn) {
            return this.trigger(fn.apply(new Trigger.Builder()).build());
        }

        public final Builder throttlePeriodInMillis(@Nullable Long value) {
            this.throttlePeriodInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Watch build() {
            this._checkSingleUse();
            return new Watch(this);
        }
    }
}

