/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HitsEvent<TEvent>
implements JsonpSerializable {
    private final String index;
    private final String id;
    private final TEvent source;
    private final Map<String, List<JsonData>> fields;
    @Nullable
    private final JsonpSerializer<TEvent> tEventSerializer;
    public static final JsonpDeserializer<HitsEvent<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> HitsEvent.createHitsEventDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:eql._types.TEvent")));

    private HitsEvent(Builder<TEvent> builder) {
        this.index = ApiTypeHelper.requireNonNull(((Builder)builder).index, this, "index");
        this.id = ApiTypeHelper.requireNonNull(((Builder)builder).id, this, "id");
        this.source = ApiTypeHelper.requireNonNull(((Builder)builder).source, this, "source");
        this.fields = ApiTypeHelper.unmodifiable(((Builder)builder).fields);
        this.tEventSerializer = ((Builder)builder).tEventSerializer;
    }

    public static <TEvent> HitsEvent<TEvent> of(Function<Builder<TEvent>, ObjectBuilder<HitsEvent<TEvent>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final String id() {
        return this.id;
    }

    public final TEvent source() {
        return this.source;
    }

    public final Map<String, List<JsonData>> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_source");
        JsonpUtils.serialize(this.source, generator, this.tEventSerializer, mapper);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, List<JsonData>> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (JsonData item1 : item0.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <TEvent> JsonpDeserializer<HitsEvent<TEvent>> createHitsEventDeserializer(JsonpDeserializer<TEvent> tEventDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> HitsEvent.setupHitsEventDeserializer(op, tEventDeserializer));
    }

    protected static <TEvent> void setupHitsEventDeserializer(ObjectDeserializer<Builder<TEvent>> op, JsonpDeserializer<TEvent> tEventDeserializer) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::source, tEventDeserializer, "_source");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER)), "fields");
    }

    public static class Builder<TEvent>
    extends WithJsonObjectBuilderBase<Builder<TEvent>>
    implements ObjectBuilder<HitsEvent<TEvent>> {
        private String index;
        private String id;
        private TEvent source;
        @Nullable
        private Map<String, List<JsonData>> fields;
        @Nullable
        private JsonpSerializer<TEvent> tEventSerializer;

        public final Builder<TEvent> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TEvent> id(String value) {
            this.id = value;
            return this;
        }

        public final Builder<TEvent> source(TEvent value) {
            this.source = value;
            return this;
        }

        public final Builder<TEvent> fields(Map<String, List<JsonData>> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder<TEvent> fields(String key, List<JsonData> value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder<TEvent> tEventSerializer(@Nullable JsonpSerializer<TEvent> value) {
            this.tEventSerializer = value;
            return this;
        }

        @Override
        protected Builder<TEvent> self() {
            return this;
        }

        @Override
        public HitsEvent<TEvent> build() {
            this._checkSingleUse();
            return new HitsEvent(this);
        }
    }
}

