/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PatternCaptureTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final List<String> patterns;
    @Nullable
    private final Boolean preserveOriginal;
    public static final JsonpDeserializer<PatternCaptureTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternCaptureTokenFilter::setupPatternCaptureTokenFilterDeserializer);

    private PatternCaptureTokenFilter(Builder builder) {
        super(builder);
        this.patterns = ApiTypeHelper.unmodifiableRequired(builder.patterns, (Object)this, "patterns");
        this.preserveOriginal = builder.preserveOriginal;
    }

    public static PatternCaptureTokenFilter of(Function<Builder, ObjectBuilder<PatternCaptureTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.PatternCapture;
    }

    public final List<String> patterns() {
        return this.patterns;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern_capture");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.patterns)) {
            generator.writeKey("patterns");
            generator.writeStartArray();
            for (String item0 : this.patterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal.booleanValue());
        }
    }

    protected static void setupPatternCaptureTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::patterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "patterns");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternCaptureTokenFilter> {
        private List<String> patterns;
        @Nullable
        private Boolean preserveOriginal;

        public final Builder patterns(List<String> list) {
            this.patterns = Builder._listAddAll(this.patterns, list);
            return this;
        }

        public final Builder patterns(String value, String ... values) {
            this.patterns = Builder._listAdd(this.patterns, value, values);
            return this;
        }

        public final Builder preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternCaptureTokenFilter build() {
            this._checkSingleUse();
            return new PatternCaptureTokenFilter(this);
        }
    }
}

