/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.HoltWintersType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HoltWintersModelSettings
implements JsonpSerializable {
    @Nullable
    private final Float alpha;
    @Nullable
    private final Float beta;
    @Nullable
    private final Float gamma;
    @Nullable
    private final Boolean pad;
    @Nullable
    private final Integer period;
    @Nullable
    private final HoltWintersType type;
    public static final JsonpDeserializer<HoltWintersModelSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HoltWintersModelSettings::setupHoltWintersModelSettingsDeserializer);

    private HoltWintersModelSettings(Builder builder) {
        this.alpha = builder.alpha;
        this.beta = builder.beta;
        this.gamma = builder.gamma;
        this.pad = builder.pad;
        this.period = builder.period;
        this.type = builder.type;
    }

    public static HoltWintersModelSettings of(Function<Builder, ObjectBuilder<HoltWintersModelSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float alpha() {
        return this.alpha;
    }

    @Nullable
    public final Float beta() {
        return this.beta;
    }

    @Nullable
    public final Float gamma() {
        return this.gamma;
    }

    @Nullable
    public final Boolean pad() {
        return this.pad;
    }

    @Nullable
    public final Integer period() {
        return this.period;
    }

    @Nullable
    public final HoltWintersType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alpha != null) {
            generator.writeKey("alpha");
            generator.write((double)this.alpha.floatValue());
        }
        if (this.beta != null) {
            generator.writeKey("beta");
            generator.write((double)this.beta.floatValue());
        }
        if (this.gamma != null) {
            generator.writeKey("gamma");
            generator.write((double)this.gamma.floatValue());
        }
        if (this.pad != null) {
            generator.writeKey("pad");
            generator.write(this.pad.booleanValue());
        }
        if (this.period != null) {
            generator.writeKey("period");
            generator.write(this.period.intValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHoltWintersModelSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alpha, JsonpDeserializer.floatDeserializer(), "alpha");
        op.add(Builder::beta, JsonpDeserializer.floatDeserializer(), "beta");
        op.add(Builder::gamma, JsonpDeserializer.floatDeserializer(), "gamma");
        op.add(Builder::pad, JsonpDeserializer.booleanDeserializer(), "pad");
        op.add(Builder::period, JsonpDeserializer.integerDeserializer(), "period");
        op.add(Builder::type, HoltWintersType._DESERIALIZER, "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HoltWintersModelSettings> {
        @Nullable
        private Float alpha;
        @Nullable
        private Float beta;
        @Nullable
        private Float gamma;
        @Nullable
        private Boolean pad;
        @Nullable
        private Integer period;
        @Nullable
        private HoltWintersType type;

        public final Builder alpha(@Nullable Float value) {
            this.alpha = value;
            return this;
        }

        public final Builder beta(@Nullable Float value) {
            this.beta = value;
            return this;
        }

        public final Builder gamma(@Nullable Float value) {
            this.gamma = value;
            return this;
        }

        public final Builder pad(@Nullable Boolean value) {
            this.pad = value;
            return this;
        }

        public final Builder period(@Nullable Integer value) {
            this.period = value;
            return this;
        }

        public final Builder type(@Nullable HoltWintersType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HoltWintersModelSettings build() {
            this._checkSingleUse();
            return new HoltWintersModelSettings(this);
        }
    }
}

