/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.ErrorResponse;

public class ElasticsearchException
extends RuntimeException {
    private final ErrorResponse response;
    private final String endpointId;

    public ElasticsearchException(String endpointId, ErrorResponse response) {
        super("[" + endpointId + "] failed: [" + response.error().type() + "] " + response.error().reason());
        this.response = response;
        this.endpointId = endpointId;
    }

    public String endpointId() {
        return this.endpointId;
    }

    public ErrorResponse response() {
        return this.response;
    }

    public ErrorCause error() {
        return this.response.error();
    }

    public int status() {
        return this.response.status();
    }
}

