/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.bulk;

import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperationBase;
import co.elastic.clients.elasticsearch.core.bulk.CreateOperation;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.BinaryData;
import javax.annotation.Nullable;

public class IngesterOperation {
    private final BulkOperation operation;
    private final long size;

    public IngesterOperation(BulkOperation operation, long size) {
        this.operation = operation;
        this.size = size;
    }

    public static IngesterOperation of(BulkOperation operation, JsonpMapper mapper) {
        switch (operation._kind()) {
            case Create: {
                return IngesterOperation.createOperation(operation, mapper);
            }
            case Index: {
                return IngesterOperation.indexOperation(operation, mapper);
            }
            case Update: {
                return IngesterOperation.updateOperation(operation, mapper);
            }
            case Delete: {
                return IngesterOperation.deleteOperation(operation);
            }
        }
        throw new IllegalStateException("Unknown bulk operation type " + operation._kind());
    }

    public BulkOperation operation() {
        return this.operation;
    }

    public long size() {
        return this.size;
    }

    private static IngesterOperation createOperation(BulkOperation operation, JsonpMapper mapper) {
        BulkOperation newOperation;
        CreateOperation create = operation.create();
        long size = IngesterOperation.basePropertiesSize(create);
        if (create.document() instanceof BinaryData) {
            newOperation = operation;
            size += ((BinaryData)create.document()).size();
        } else {
            BinaryData binaryDoc = BinaryData.of(create.document(), mapper);
            size += binaryDoc.size();
            newOperation = BulkOperation.of(bo -> bo.create(idx -> {
                IngesterOperation.copyBaseProperties(create, idx);
                return idx.document(binaryDoc);
            }));
        }
        return new IngesterOperation(newOperation, size);
    }

    private static IngesterOperation indexOperation(BulkOperation operation, JsonpMapper mapper) {
        BulkOperation newOperation;
        IndexOperation index = operation.index();
        long size = IngesterOperation.basePropertiesSize(index);
        if (index.document() instanceof BinaryData) {
            newOperation = operation;
            size += ((BinaryData)index.document()).size();
        } else {
            BinaryData binaryDoc = BinaryData.of(index.document(), mapper);
            size += binaryDoc.size();
            newOperation = BulkOperation.of(bo -> bo.index(idx -> {
                IngesterOperation.copyBaseProperties(index, idx);
                return idx.document(binaryDoc);
            }));
        }
        return new IngesterOperation(newOperation, size);
    }

    private static IngesterOperation updateOperation(BulkOperation operation, JsonpMapper mapper) {
        BulkOperation newOperation;
        UpdateOperation update = operation.update();
        long size = IngesterOperation.basePropertiesSize(update) + IngesterOperation.size("retry_on_conflict", update.retryOnConflict()) + IngesterOperation.size("require_alias", update.requireAlias());
        if (update.binaryAction() != null) {
            newOperation = operation;
            size += update.binaryAction().size();
        } else {
            BinaryData action = BinaryData.of(update.action(), mapper);
            size += action.size();
            newOperation = BulkOperation.of(bo -> bo.update(u -> {
                IngesterOperation.copyBaseProperties(update, u);
                return u.binaryAction(action).requireAlias(update.requireAlias()).retryOnConflict(update.retryOnConflict());
            }));
        }
        return new IngesterOperation(newOperation, size);
    }

    private static IngesterOperation deleteOperation(BulkOperation operation) {
        DeleteOperation delete = operation.delete();
        return new IngesterOperation(operation, IngesterOperation.basePropertiesSize(delete));
    }

    private static void copyBaseProperties(BulkOperationBase op, BulkOperationBase.AbstractBuilder<?> builder) {
        ((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)((BulkOperationBase.AbstractBuilder)builder.id(op.id())).index(op.index())).ifPrimaryTerm(op.ifPrimaryTerm())).ifSeqNo(op.ifSeqNo())).routing(op.routing())).version(op.version())).versionType(op.versionType());
    }

    private static int size(String name, @Nullable Boolean value) {
        if (value != null) {
            return name.length() + 12;
        }
        return 0;
    }

    private static int size(String name, @Nullable String value) {
        if (value != null) {
            return name.length() + value.length() + 6;
        }
        return 0;
    }

    private static int size(String name, @Nullable Long value) {
        if (value != null) {
            int mag = 32 - Long.numberOfLeadingZeros(value);
            int chars = Math.max((mag + 2) / 3, 1);
            return name.length() + chars + 4;
        }
        return 0;
    }

    private static int size(String name, @Nullable Integer value) {
        if (value != null) {
            int mag = 32 - Integer.numberOfLeadingZeros(value);
            int chars = Math.max((mag + 2) / 3, 1);
            return name.length() + chars + 4;
        }
        return 0;
    }

    private static int size(String name, @Nullable JsonEnum value) {
        if (value != null) {
            return name.length() + value.jsonValue().length() + 6;
        }
        return 0;
    }

    private static int basePropertiesSize(BulkOperationBase op) {
        return IngesterOperation.size("id", op.id()) + IngesterOperation.size("index", op.index()) + IngesterOperation.size("if_primary_term", op.ifPrimaryTerm()) + IngesterOperation.size("if_seq_no", op.ifSeqNo()) + IngesterOperation.size("routing", op.routing()) + IngesterOperation.size("version", op.version()) + IngesterOperation.size("version_type", op.versionType()) + 4;
    }
}

