/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

class LanguageRuntimeVersions {
    LanguageRuntimeVersions() {
    }

    public static String getRuntimeMetadata() {
        StringBuilder s = new StringBuilder();
        String version = LanguageRuntimeVersions.kotlinVersion();
        if (version != null) {
            s.append(",kt=").append(version);
        }
        if ((version = LanguageRuntimeVersions.scalaVersion()) != null) {
            s.append(",sc=").append(version);
        }
        if ((version = LanguageRuntimeVersions.clojureVersion()) != null) {
            s.append(",clj=").append(version);
        }
        if ((version = LanguageRuntimeVersions.groovyVersion()) != null) {
            s.append(",gy=").append(version);
        }
        if ((version = LanguageRuntimeVersions.jRubyVersion()) != null) {
            s.append(",jrb=").append(version);
        }
        return s.toString();
    }

    public static String kotlinVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.getStaticField("kotlin.KotlinVersion", "CURRENT"));
    }

    public static String scalaVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.callStaticMethod("scala.util.Properties", "versionNumberString"));
    }

    public static String clojureVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.callStaticMethod("clojure.core$clojure_version", "invokeStatic"));
    }

    public static String groovyVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.callStaticMethod("groovy.lang.GroovySystem", "getVersion"));
    }

    public static String jRubyVersion() {
        return LanguageRuntimeVersions.keepMajorMinor(LanguageRuntimeVersions.getStaticField("org.jruby.runtime.Constants", "VERSION"));
    }

    private static String getStaticField(String className, String fieldName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            Field field = clazz.getField(fieldName);
            return field.get(null).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String callStaticMethod(String className, String methodName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            Method m = clazz.getMethod(methodName, new Class[0]);
            return m.invoke(null, new Object[0]).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static String keepMajorMinor(String version) {
        if (version == null) {
            return null;
        }
        int firstDot = version.indexOf(46);
        int secondDot = version.indexOf(46, firstDot + 1);
        if (secondDot < 0) {
            return version;
        }
        return version.substring(0, secondDot);
    }
}

