/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetDataFrameAnalyticsStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetDataFrameAnalyticsStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Integer from;
    @Nullable
    private final String id;
    @Nullable
    private final Integer size;
    @Nullable
    private final Boolean verbose;
    public static final Endpoint<GetDataFrameAnalyticsStatsRequest, GetDataFrameAnalyticsStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetDataFrameAnalyticsStatsRequest, GetDataFrameAnalyticsStatsResponse>("es/ml.get_data_frame_analytics_stats", request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.verbose != null) {
            params.put("verbose", String.valueOf(request.verbose));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDataFrameAnalyticsStatsResponse._DESERIALIZER);

    private GetDataFrameAnalyticsStatsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.id = builder.id;
        this.size = builder.size;
        this.verbose = builder.verbose;
    }

    public static GetDataFrameAnalyticsStatsRequest of(Function<Builder, ObjectBuilder<GetDataFrameAnalyticsStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Boolean verbose() {
        return this.verbose;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetDataFrameAnalyticsStatsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Integer from;
        @Nullable
        private String id;
        @Nullable
        private Integer size;
        @Nullable
        private Boolean verbose;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetDataFrameAnalyticsStatsRequest build() {
            this._checkSingleUse();
            return new GetDataFrameAnalyticsStatsRequest(this);
        }
    }
}

