/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OverlappingIndexTemplate
implements JsonpSerializable {
    private final String name;
    private final List<String> indexPatterns;
    public static final JsonpDeserializer<OverlappingIndexTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OverlappingIndexTemplate::setupOverlappingIndexTemplateDeserializer);

    private OverlappingIndexTemplate(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.indexPatterns = ApiTypeHelper.unmodifiable(builder.indexPatterns);
    }

    public static OverlappingIndexTemplate of(Function<Builder, ObjectBuilder<OverlappingIndexTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String item0 : this.indexPatterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupOverlappingIndexTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OverlappingIndexTemplate> {
        private String name;
        @Nullable
        private List<String> indexPatterns;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OverlappingIndexTemplate build() {
            this._checkSingleUse();
            return new OverlappingIndexTemplate(this);
        }
    }
}

