/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMappingException;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.function.Supplier;

public class NamedValue<T> {
    private final String name;
    private final T value;

    public NamedValue(String name, T value) {
        this.name = name;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public T value() {
        return this.value;
    }

    public static <T> NamedValue<T> of(String name, T value) {
        return new NamedValue<T>(name, value);
    }

    public static <T> JsonpDeserializer<NamedValue<T>> deserializer(Supplier<JsonpDeserializer<T>> valueParserBuilder) {
        return NamedValue.deserializer(valueParserBuilder.get());
    }

    public static <T> JsonpDeserializer<NamedValue<T>> deserializer(final JsonpDeserializer<T> valueDeserializer) {
        return new JsonpDeserializerBase<NamedValue<T>>(EnumSet.of(JsonParser.Event.START_OBJECT)){

            @Override
            public NamedValue<T> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                JsonpUtils.expectNextEvent(parser, JsonParser.Event.KEY_NAME);
                String name = parser.getString();
                try {
                    Object value = valueDeserializer.deserialize(parser, mapper);
                    JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
                    return new NamedValue(name, value);
                }
                catch (Exception e) {
                    throw JsonpMappingException.from(e, null, name, parser);
                }
            }
        };
    }
}

