/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Schedule;
import co.elastic.clients.elasticsearch.watcher.TriggerVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Trigger
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Trigger> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Trigger::setupTriggerDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Trigger(TriggerVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._triggerKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Trigger(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Trigger of(Function<Builder, ObjectBuilder<Trigger>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isSchedule() {
        return this._kind == Kind.Schedule;
    }

    public Schedule schedule() {
        return (Schedule)TaggedUnionUtils.get(this, Kind.Schedule);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTriggerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::schedule, Schedule._DESERIALIZER, "schedule");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Trigger> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Trigger> schedule(Schedule v) {
            this._kind = Kind.Schedule;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Trigger> schedule(Function<Schedule.Builder, ObjectBuilder<Schedule>> fn) {
            return this.schedule(fn.apply(new Schedule.Builder()).build());
        }

        @Override
        public Trigger build() {
            this._checkSingleUse();
            return new Trigger(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Schedule("schedule");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

