/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.reindex_rethrottle;

import co.elastic.clients.elasticsearch._types.BaseNode;
import co.elastic.clients.elasticsearch.core.reindex_rethrottle.ReindexTask;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ReindexNode
extends BaseNode {
    private final Map<String, ReindexTask> tasks;
    public static final JsonpDeserializer<ReindexNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexNode::setupReindexNodeDeserializer);

    private ReindexNode(Builder builder) {
        super(builder);
        this.tasks = ApiTypeHelper.unmodifiableRequired(builder.tasks, (Object)this, "tasks");
    }

    public static ReindexNode of(Function<Builder, ObjectBuilder<ReindexNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ReindexTask> tasks() {
        return this.tasks;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.tasks)) {
            generator.writeKey("tasks");
            generator.writeStartObject();
            for (Map.Entry<String, ReindexTask> item0 : this.tasks.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupReindexNodeDeserializer(ObjectDeserializer<Builder> op) {
        BaseNode.setupBaseNodeDeserializer(op);
        op.add(Builder::tasks, JsonpDeserializer.stringMapDeserializer(ReindexTask._DESERIALIZER), "tasks");
    }

    public static class Builder
    extends BaseNode.AbstractBuilder<Builder>
    implements ObjectBuilder<ReindexNode> {
        private Map<String, ReindexTask> tasks;

        public final Builder tasks(Map<String, ReindexTask> map) {
            this.tasks = Builder._mapPutAll(this.tasks, map);
            return this;
        }

        public final Builder tasks(String key, ReindexTask value) {
            this.tasks = Builder._mapPut(this.tasks, key, value);
            return this;
        }

        public final Builder tasks(String key, Function<ReindexTask.Builder, ObjectBuilder<ReindexTask>> fn) {
            return this.tasks(key, fn.apply(new ReindexTask.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReindexNode build() {
            this._checkSingleUse();
            return new ReindexNode(this);
        }
    }
}

