/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ParentAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final String type;
    public static final JsonpDeserializer<ParentAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ParentAggregation::setupParentAggregationDeserializer);

    private ParentAggregation(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    public static ParentAggregation of(Function<Builder, ObjectBuilder<ParentAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Parent;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    protected static void setupParentAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ParentAggregation> {
        @Nullable
        private String type;

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ParentAggregation build() {
            this._checkSingleUse();
            return new ParentAggregation(this);
        }
    }
}

