/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TrainedModelInferenceStats;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelStats
implements JsonpSerializable {
    private final String modelId;
    private final int pipelineCount;
    @Nullable
    private final TrainedModelInferenceStats inferenceStats;
    private final Map<String, JsonData> ingest;
    public static final JsonpDeserializer<TrainedModelStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelStats::setupTrainedModelStatsDeserializer);

    private TrainedModelStats(Builder builder) {
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.pipelineCount = ApiTypeHelper.requireNonNull(builder.pipelineCount, this, "pipelineCount");
        this.inferenceStats = builder.inferenceStats;
        this.ingest = ApiTypeHelper.unmodifiable(builder.ingest);
    }

    public static TrainedModelStats of(Function<Builder, ObjectBuilder<TrainedModelStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    public final int pipelineCount() {
        return this.pipelineCount;
    }

    @Nullable
    public final TrainedModelInferenceStats inferenceStats() {
        return this.inferenceStats;
    }

    public final Map<String, JsonData> ingest() {
        return this.ingest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("pipeline_count");
        generator.write(this.pipelineCount);
        if (this.inferenceStats != null) {
            generator.writeKey("inference_stats");
            this.inferenceStats.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ingest)) {
            generator.writeKey("ingest");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.ingest.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::pipelineCount, JsonpDeserializer.integerDeserializer(), "pipeline_count");
        op.add(Builder::inferenceStats, TrainedModelInferenceStats._DESERIALIZER, "inference_stats");
        op.add(Builder::ingest, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "ingest");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelStats> {
        private String modelId;
        private Integer pipelineCount;
        @Nullable
        private TrainedModelInferenceStats inferenceStats;
        @Nullable
        private Map<String, JsonData> ingest;

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder pipelineCount(int value) {
            this.pipelineCount = value;
            return this;
        }

        public final Builder inferenceStats(@Nullable TrainedModelInferenceStats value) {
            this.inferenceStats = value;
            return this;
        }

        public final Builder inferenceStats(Function<TrainedModelInferenceStats.Builder, ObjectBuilder<TrainedModelInferenceStats>> fn) {
            return this.inferenceStats(fn.apply(new TrainedModelInferenceStats.Builder()).build());
        }

        public final Builder ingest(Map<String, JsonData> map) {
            this.ingest = Builder._mapPutAll(this.ingest, map);
            return this;
        }

        public final Builder ingest(String key, JsonData value) {
            this.ingest = Builder._mapPut(this.ingest, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelStats build() {
            this._checkSingleUse();
            return new TrainedModelStats(this);
        }
    }
}

