/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.elasticsearch.core.search.TotalHits;
import co.elastic.clients.elasticsearch.eql.HitsEvent;
import co.elastic.clients.elasticsearch.eql.HitsSequence;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EqlHits<TEvent>
implements JsonpSerializable {
    @Nullable
    private final TotalHits total;
    private final List<HitsEvent<TEvent>> events;
    private final List<HitsSequence<TEvent>> sequences;
    @Nullable
    private final JsonpSerializer<TEvent> tEventSerializer;
    public static final JsonpDeserializer<EqlHits<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> EqlHits.createEqlHitsDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:eql._types.TEvent")));

    private EqlHits(Builder<TEvent> builder) {
        this.total = ((Builder)builder).total;
        this.events = ApiTypeHelper.unmodifiable(((Builder)builder).events);
        this.sequences = ApiTypeHelper.unmodifiable(((Builder)builder).sequences);
        this.tEventSerializer = ((Builder)builder).tEventSerializer;
    }

    public static <TEvent> EqlHits<TEvent> of(Function<Builder<TEvent>, ObjectBuilder<EqlHits<TEvent>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TotalHits total() {
        return this.total;
    }

    public final List<HitsEvent<TEvent>> events() {
        return this.events;
    }

    public final List<HitsSequence<TEvent>> sequences() {
        return this.sequences;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.events)) {
            generator.writeKey("events");
            generator.writeStartArray();
            for (HitsEvent<TEvent> hitsEvent : this.events) {
                hitsEvent.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.sequences)) {
            generator.writeKey("sequences");
            generator.writeStartArray();
            for (HitsSequence hitsSequence : this.sequences) {
                hitsSequence.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <TEvent> JsonpDeserializer<EqlHits<TEvent>> createEqlHitsDeserializer(JsonpDeserializer<TEvent> tEventDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> EqlHits.setupEqlHitsDeserializer(op, tEventDeserializer));
    }

    protected static <TEvent> void setupEqlHitsDeserializer(ObjectDeserializer<Builder<TEvent>> op, JsonpDeserializer<TEvent> tEventDeserializer) {
        op.add(Builder::total, TotalHits._DESERIALIZER, "total");
        op.add(Builder::events, JsonpDeserializer.arrayDeserializer(HitsEvent.createHitsEventDeserializer(tEventDeserializer)), "events");
        op.add(Builder::sequences, JsonpDeserializer.arrayDeserializer(HitsSequence.createHitsSequenceDeserializer(tEventDeserializer)), "sequences");
    }

    public static class Builder<TEvent>
    extends WithJsonObjectBuilderBase<Builder<TEvent>>
    implements ObjectBuilder<EqlHits<TEvent>> {
        @Nullable
        private TotalHits total;
        @Nullable
        private List<HitsEvent<TEvent>> events;
        @Nullable
        private List<HitsSequence<TEvent>> sequences;
        @Nullable
        private JsonpSerializer<TEvent> tEventSerializer;

        public final Builder<TEvent> total(@Nullable TotalHits value) {
            this.total = value;
            return this;
        }

        public final Builder<TEvent> total(Function<TotalHits.Builder, ObjectBuilder<TotalHits>> fn) {
            return this.total(fn.apply(new TotalHits.Builder()).build());
        }

        public final Builder<TEvent> events(List<HitsEvent<TEvent>> list) {
            this.events = Builder._listAddAll(this.events, list);
            return this;
        }

        public final Builder<TEvent> events(HitsEvent<TEvent> value, HitsEvent<TEvent> ... values) {
            this.events = Builder._listAdd(this.events, value, values);
            return this;
        }

        public final Builder<TEvent> events(Function<HitsEvent.Builder<TEvent>, ObjectBuilder<HitsEvent<TEvent>>> fn) {
            return this.events(fn.apply(new HitsEvent.Builder()).build(), new HitsEvent[0]);
        }

        public final Builder<TEvent> sequences(List<HitsSequence<TEvent>> list) {
            this.sequences = Builder._listAddAll(this.sequences, list);
            return this;
        }

        public final Builder<TEvent> sequences(HitsSequence<TEvent> value, HitsSequence<TEvent> ... values) {
            this.sequences = Builder._listAdd(this.sequences, value, values);
            return this;
        }

        public final Builder<TEvent> sequences(Function<HitsSequence.Builder<TEvent>, ObjectBuilder<HitsSequence<TEvent>>> fn) {
            return this.sequences(fn.apply(new HitsSequence.Builder()).build(), new HitsSequence[0]);
        }

        public final Builder<TEvent> tEventSerializer(@Nullable JsonpSerializer<TEvent> value) {
            this.tEventSerializer = value;
            return this;
        }

        @Override
        protected Builder<TEvent> self() {
            return this;
        }

        @Override
        public EqlHits<TEvent> build() {
            this._checkSingleUse();
            return new EqlHits(this);
        }
    }
}

