/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps;

import cn.zhxu.okhttps.Cancelable;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.HttpTask;
import cn.zhxu.okhttps.OkHttpsException;
import cn.zhxu.okhttps.internal.AbstractHttpClient;
import cn.zhxu.okhttps.internal.RealHttpResult;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import okhttp3.Call;

public class SHttpTask
extends HttpTask<SHttpTask> {
    public SHttpTask(AbstractHttpClient httpImpl, String url) {
        super(httpImpl, url);
    }

    @Override
    public boolean isSyncHttp() {
        return true;
    }

    public HttpResult get() {
        return this.request("GET");
    }

    public HttpResult head() {
        return this.request("HEAD");
    }

    public HttpResult post() {
        return this.request("POST");
    }

    public HttpResult put() {
        return this.request("PUT");
    }

    public HttpResult patch() {
        return this.request("PATCH");
    }

    public HttpResult delete() {
        return this.request("DELETE");
    }

    public HttpResult request(String method) {
        if (method == null || method.isEmpty()) {
            throw new IllegalArgumentException("HTTP \u8bf7\u6c42\u65b9\u6cd5 method \u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        RealHttpResult result = new RealHttpResult(this, this.httpClient.executor());
        SyncHttpCall httpCall = new SyncHttpCall();
        this.registeTagTask(httpCall);
        CountDownLatch latch = new CountDownLatch(1);
        this.httpClient.preprocess(this, () -> {
            SyncHttpCall syncHttpCall = httpCall;
            synchronized (syncHttpCall) {
                if (httpCall.canceled) {
                    result.exception(HttpResult.State.CANCELED, null);
                    latch.countDown();
                    return;
                }
                httpCall.call = this.prepareCall(method);
            }
            try {
                result.response(httpCall.call.execute());
                httpCall.done = true;
            }
            catch (IOException e) {
                result.exception(this.toState(e), e);
            }
            finally {
                latch.countDown();
            }
        }, this.skipPreproc, this.skipSerialPreproc);
        boolean timeout = false;
        if (result.getState() == null) {
            timeout = this.timeoutAwait(latch);
        }
        this.removeTagTask();
        if (timeout) {
            httpCall.cancel();
            return this.timeoutResult();
        }
        IOException e = result.getError();
        HttpResult.State state = result.getState();
        if (e != null && state != HttpResult.State.CANCELED && !this.nothrow) {
            throw new OkHttpsException(state, "\u540c\u6b65\u8bf7\u6c42\u5f02\u5e38\uff1a" + this.getUrl(), e);
        }
        return result;
    }

    static class SyncHttpCall
    implements Cancelable {
        Call call;
        boolean done = false;
        boolean canceled = false;

        SyncHttpCall() {
        }

        @Override
        public synchronized boolean cancel() {
            if (this.done) {
                return false;
            }
            if (this.call != null) {
                this.call.cancel();
            }
            this.canceled = true;
            return true;
        }
    }
}

