/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps;

import cn.zhxu.data.ArrayListMap;
import cn.zhxu.data.ListMap;
import cn.zhxu.okhttps.BodyPara;
import cn.zhxu.okhttps.Cancelable;
import cn.zhxu.okhttps.FilePara;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.OkHttpsException;
import cn.zhxu.okhttps.Platform;
import cn.zhxu.okhttps.Process;
import cn.zhxu.okhttps.TaskExecutor;
import cn.zhxu.okhttps.internal.AbstractHttpClient;
import cn.zhxu.okhttps.internal.FixedRequestBody;
import cn.zhxu.okhttps.internal.ProcessRequestBody;
import cn.zhxu.okhttps.internal.RealHttpResult;
import cn.zhxu.okhttps.internal.StreamRequestBody;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;

public abstract class HttpTask<C extends HttpTask<C>>
implements Cancelable {
    private static final String DOT = ".";
    private static final String MULTIPART = "multipart/";
    private static final String FORM = "x-www-form-urlencoded";
    protected final AbstractHttpClient httpClient;
    protected boolean nothrow;
    protected boolean nextOnIO = false;
    private final String urlPath;
    private String tag;
    private ListMap<String> headers;
    private ListMap<Object> pathParams;
    private ListMap<Object> urlParams;
    private ListMap<Object> bodyParams;
    private ListMap<FilePara> files;
    private Object requestBody;
    private String bodyType;
    private String boundary;
    private Consumer<Process> onProcess;
    private boolean processOnIO;
    private long stepBytes = 0L;
    private double stepRate = -1.0;
    private Object object;
    private AbstractHttpClient.TagTask tagTask;
    private Cancelable canceler;
    private Charset charset;
    protected boolean skipPreproc = false;
    protected boolean skipSerialPreproc = false;

    public HttpTask(AbstractHttpClient httpClient, String urlPath) {
        this.httpClient = httpClient;
        this.charset = httpClient.charset();
        this.bodyType = httpClient.bodyType();
        this.urlPath = urlPath;
    }

    public String getUrl() {
        return this.urlPath;
    }

    public boolean isWebsocket() {
        return false;
    }

    public boolean isSyncHttp() {
        return false;
    }

    public boolean isAsyncHttp() {
        return false;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public boolean isTagged(String tag) {
        String theTag = this.tag;
        if (theTag != null && tag != null) {
            return theTag.equals(tag) || theTag.startsWith(tag + DOT) || theTag.endsWith(DOT + tag) || theTag.contains(DOT + tag + DOT);
        }
        return false;
    }

    public ListMap<String> getHeaders() {
        return this.headers;
    }

    public ListMap<Object> getPathParas() {
        return this.pathParams;
    }

    public ListMap<Object> getUrlParas() {
        return this.urlParams;
    }

    public ListMap<Object> getBodyParas() {
        return this.bodyParams;
    }

    public ListMap<FilePara> getFileParas() {
        return this.files;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public Object getBound() {
        return this.object;
    }

    public C nothrow() {
        this.nothrow = true;
        return (C)this;
    }

    public C skipPreproc() {
        this.skipPreproc = true;
        return (C)this;
    }

    public C skipSerialPreproc() {
        this.skipSerialPreproc = true;
        return (C)this;
    }

    public C tag(String tag) {
        if (tag != null) {
            this.tag = this.tag != null ? this.tag + DOT + tag : tag;
            this.updateTagTask();
        }
        return (C)this;
    }

    public C charset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
        return (C)this;
    }

    public C bodyType(String type) {
        if (type != null) {
            this.bodyType = type.toLowerCase();
        }
        return (C)this;
    }

    public C nextOnIO() {
        this.nextOnIO = true;
        return (C)this;
    }

    public C bind(Object object) {
        this.object = object;
        return (C)this;
    }

    public C basicAuth(String username, String password) {
        byte[] authData = (username + ':' + password).getBytes(StandardCharsets.UTF_8);
        byte[] authBytes = Base64.getEncoder().encode(authData);
        String authStr = new String(authBytes, StandardCharsets.UTF_8);
        return this.addHeader("Authorization", "Basic " + authStr);
    }

    public C bearerAuth(String token) {
        return this.addHeader("Authorization", "Bearer " + token);
    }

    public C addHeader(String name, String value) {
        if (name != null && value != null) {
            if (this.headers == null) {
                this.headers = new ArrayListMap();
            }
            this.headers.put(name, (Object)value);
        }
        return (C)this;
    }

    public C addHeader(Map<String, String> headers) {
        if (headers != null) {
            if (this.headers == null) {
                this.headers = new ArrayListMap();
            }
            this.headers.putAll(headers);
        }
        return (C)this;
    }

    public C setRange(long rangeStart) {
        return this.addHeader("Range", "bytes=" + rangeStart + "-");
    }

    public C setRange(long rangeStart, long rangeEnd) {
        return this.addHeader("Range", "bytes=" + rangeStart + "-" + rangeEnd);
    }

    public C setOnProcess(Consumer<Process> onProcess) {
        this.onProcess = onProcess;
        this.processOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return (C)this;
    }

    public C stepBytes(long stepBytes) {
        this.stepBytes = stepBytes;
        return (C)this;
    }

    public C stepRate(double stepRate) {
        this.stepRate = stepRate;
        return (C)this;
    }

    public C addPathPara(String name, Object value) {
        if (name != null && value != null) {
            if (this.pathParams == null) {
                this.pathParams = new ArrayListMap();
            }
            this.pathParams.put(name, (Object)value.toString());
        }
        return (C)this;
    }

    public C addPathPara(Map<String, ?> params) {
        if (this.pathParams == null) {
            this.pathParams = new ArrayListMap();
        }
        if (params != null) {
            this.pathParams.putAll(params);
        }
        return (C)this;
    }

    public C addUrlPara(String name, Object value) {
        if (name != null && value != null) {
            if (this.urlParams == null) {
                this.urlParams = new ArrayListMap();
            }
            this.urlParams.put(name, (Object)value.toString());
        }
        return (C)this;
    }

    public C addUrlPara(Map<String, ?> params) {
        if (this.urlParams == null) {
            this.urlParams = new ArrayListMap();
        }
        if (params != null) {
            this.urlParams.putAll(params);
        }
        return (C)this;
    }

    public C addBodyPara(String name, Object value) {
        if (name != null && value != null) {
            if (this.bodyParams == null) {
                this.bodyParams = new ArrayListMap();
            }
            this.bodyParams.put(name, value);
        }
        return (C)this;
    }

    public C addBodyPara(String name, String type, Object value) {
        if (name != null && value != null) {
            if (this.bodyParams == null) {
                this.bodyParams = new ArrayListMap();
            }
            if (type == null) {
                this.bodyParams.put(name, value);
            } else {
                this.bodyParams.put(name, (Object)new BodyPara(type, value));
            }
        }
        return (C)this;
    }

    public C addBodyPara(Map<String, ?> params) {
        if (this.bodyParams == null) {
            this.bodyParams = new ArrayListMap();
        }
        if (params != null) {
            this.bodyParams.putAll(params);
        }
        return (C)this;
    }

    public C setBodyPara(Object body) {
        this.requestBody = body;
        return (C)this;
    }

    public C addFilePara(String name, String filePath) {
        return this.addFilePara(name, new File(filePath));
    }

    public C addFilePara(String name, String type, String filePath) {
        return this.addFilePara(name, type, new File(filePath));
    }

    public C addFilePara(String name, File file) {
        if (file != null && file.exists()) {
            String fileName = file.getName();
            String type = fileName.substring(fileName.lastIndexOf(DOT) + 1);
            return this.addFilePara(name, type, file);
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, File file) {
        if (name != null && file != null && file.exists()) {
            if (this.files == null) {
                this.files = new ArrayListMap();
            }
            this.files.put(name, (Object)new FilePara(type, file.getName(), file));
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, byte[] content) {
        return this.addFilePara(name, type, name + DOT + type, content);
    }

    public C addFilePara(String name, byte[] content, String fileName) {
        if (fileName != null) {
            int dotIdx = fileName.indexOf(DOT);
            if (dotIdx >= 0 && dotIdx < fileName.length() - 1) {
                String type = fileName.substring(dotIdx + 1);
                return this.addFilePara(name, type, fileName, content);
            }
            return this.addFilePara(name, null, fileName, content);
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, String fileName, byte[] content) {
        if (name != null && content != null) {
            if (this.files == null) {
                this.files = new ArrayListMap();
            }
            this.files.put(name, (Object)new FilePara(type, fileName, content));
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, InputStream stream) {
        return this.addFilePara(name, type, name + DOT + type, stream);
    }

    public C addFilePara(String name, InputStream stream, String fileName) {
        if (fileName != null) {
            int dotIdx = fileName.indexOf(DOT);
            if (dotIdx >= 0 && dotIdx < fileName.length() - 1) {
                String type = fileName.substring(dotIdx + 1);
                return this.addFilePara(name, type, fileName, stream);
            }
            return this.addFilePara(name, null, fileName, stream);
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, String fileName, InputStream stream) {
        if (name != null && stream != null) {
            if (this.files == null) {
                this.files = new ArrayListMap();
            }
            this.files.put(name, (Object)new FilePara(type, fileName, stream));
        }
        return (C)this;
    }

    public String boundary() {
        return this.boundary;
    }

    public C boundary(String boundary) {
        this.boundary = boundary;
        return (C)this;
    }

    @Override
    public boolean cancel() {
        if (this.canceler != null) {
            return this.canceler.cancel();
        }
        return false;
    }

    protected void registeTagTask(Cancelable canceler) {
        if (this.tag != null && this.tagTask == null) {
            this.tagTask = this.httpClient.addTagTask(this.tag, canceler, this);
        }
        this.canceler = canceler;
    }

    private void updateTagTask() {
        if (this.tagTask != null) {
            this.tagTask.setTag(this.tag);
        } else if (this.canceler != null) {
            this.registeTagTask(this.canceler);
        }
    }

    protected void removeTagTask() {
        if (this.tag != null) {
            this.httpClient.removeTagTask(this);
        }
    }

    protected Call prepareCall(String method) {
        Request request = this.prepareRequest(method.toUpperCase());
        return this.httpClient.request(request);
    }

    protected Request prepareRequest(String method) {
        boolean bodyCanUsed = HttpMethod.permitsRequestBody((String)method);
        this.assertNotConflict(!bodyCanUsed);
        Request.Builder builder = new Request.Builder().url(this.buildUrlPath());
        this.buildHeaders(builder);
        if (bodyCanUsed) {
            RequestBody reqBody = this.buildRequestBody();
            if (this.onProcess != null) {
                long contentLength = this.contentLength(reqBody);
                if (this.stepRate > 0.0 && this.stepRate <= 1.0) {
                    this.stepBytes = (long)((double)contentLength * this.stepRate);
                }
                if (this.stepBytes <= 0L) {
                    this.stepBytes = 8192L;
                }
                reqBody = new ProcessRequestBody(reqBody, this.onProcess, this.httpClient.executor().getExecutor(this.processOnIO), contentLength, this.stepBytes);
            } else {
                reqBody = new FixedRequestBody(reqBody);
            }
            builder.method(method, reqBody);
        } else {
            builder.method(method, null);
        }
        if (this.tag != null) {
            builder.tag(String.class, (Object)this.tag);
        }
        return builder.build();
    }

    private long contentLength(RequestBody reqBody) {
        try {
            return reqBody.contentLength();
        }
        catch (IOException e) {
            throw new OkHttpsException("\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u4f53\u957f\u5ea6", e);
        }
    }

    private void buildHeaders(Request.Builder builder) {
        if (this.headers != null) {
            this.headers.forEach((name, value) -> {
                if (value == null) {
                    return;
                }
                builder.addHeader(name, value);
            });
        }
    }

    protected HttpResult.State toState(IOException e) {
        if (e instanceof SocketTimeoutException) {
            return HttpResult.State.TIMEOUT;
        }
        if (e instanceof UnknownHostException || e instanceof ConnectException) {
            return HttpResult.State.NETWORK_ERROR;
        }
        String msg = e.getMessage();
        if (msg != null && ("Canceled".equals(msg) || e instanceof SocketException && (msg.startsWith("Socket operation on nonsocket") || "Socket closed".equals(msg)))) {
            return HttpResult.State.CANCELED;
        }
        return HttpResult.State.EXCEPTION;
    }

    private RequestBody buildRequestBody() {
        if (this.bodyParams != null && ("form-data".equals(this.bodyType) || this.bodyType.startsWith(MULTIPART)) || this.files != null) {
            MultipartBody.Builder builder = this.multipartBodyBuilder();
            if (this.bodyParams != null) {
                this.bodyParams.forEach((key, value) -> {
                    String bodyValue;
                    if (value == null) {
                        return;
                    }
                    MediaType contentType = null;
                    if (value instanceof BodyPara) {
                        BodyPara para = (BodyPara)value;
                        contentType = this.httpClient.mediaType(para.getType());
                        bodyValue = para.getValue().toString();
                    } else {
                        bodyValue = value.toString();
                    }
                    byte[] content = bodyValue.getBytes(this.charset);
                    RequestBody body = RequestBody.create((MediaType)contentType, (byte[])content);
                    builder.addPart(MultipartBody.Part.createFormData((String)key, null, (RequestBody)body));
                });
            }
            if (this.files != null) {
                this.files.forEach((name, file) -> {
                    MediaType type = this.httpClient.mediaType(file.getType());
                    builder.addFormDataPart(name, file.getFileName(), file.toRequestBody(type));
                });
            }
            return builder.build();
        }
        if (this.requestBody != null) {
            return this.toRequestBody(this.requestBody);
        }
        if (this.bodyParams == null) {
            return this.emptyRequestBody();
        }
        if ("form".equals(this.bodyType) || this.bodyType.endsWith(FORM)) {
            FormBody.Builder builder = new FormBody.Builder(this.charset);
            this.bodyParams.forEach((key, value) -> {
                if (value == null) {
                    return;
                }
                builder.add(key, value.toString());
            });
            return builder.build();
        }
        return this.toRequestBody(this.bodyParams);
    }

    private MultipartBody.Builder multipartBodyBuilder() {
        MultipartBody.Builder builder = this.boundary != null ? new MultipartBody.Builder(this.boundary) : new MultipartBody.Builder();
        if (this.bodyType.startsWith(MULTIPART)) {
            try {
                builder.setType(MediaType.get((String)this.bodyType));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            builder.setType(MultipartBody.FORM);
        }
        return builder;
    }

    private RequestBody emptyRequestBody() {
        if ("form-data".equalsIgnoreCase(this.bodyType)) {
            return new MultipartBody.Builder().setType(MultipartBody.FORM).build();
        }
        return RequestBody.create((MediaType)this.mediaType(), (byte[])new byte[0]);
    }

    private MediaType mediaType() {
        return this.httpClient.executor().doMsgConvert(this.bodyType, null).mediaType(this.charset);
    }

    private RequestBody toRequestBody(Object bodyObj) {
        if (bodyObj instanceof byte[] || bodyObj instanceof String) {
            byte[] body = bodyObj instanceof byte[] ? (byte[])bodyObj : ((String)bodyObj).getBytes(this.charset);
            return RequestBody.create((MediaType)this.mediaType(), (byte[])body);
        }
        if (bodyObj instanceof InputStream) {
            return new StreamRequestBody(this.mediaType(), (InputStream)bodyObj);
        }
        TaskExecutor.Data<byte[]> data = this.httpClient.executor().doMsgConvert(this.bodyType, c -> c.serialize(bodyObj, this.charset));
        return RequestBody.create((MediaType)data.mediaType(this.charset), (byte[])((byte[])data.data));
    }

    private String buildUrlPath() {
        if (Platform.isBlank(this.urlPath)) {
            throw new OkHttpsException("url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder(this.urlPath);
        if (this.pathParams != null) {
            this.pathParams.forEach((name, value) -> {
                String target = "{" + name + "}";
                int start = sb.indexOf(target);
                if (start < 0) {
                    throw new OkHttpsException("PathPara [ " + name + " ] \u4e0d\u5b58\u5728\u4e8e url [ " + this.urlPath + " ]");
                }
                String newValue = value != null ? value.toString() : "";
                sb.replace(start, start + target.length(), newValue);
            });
        }
        if (this.urlParams != null) {
            if (sb.indexOf("?") >= 0) {
                int lastIndex = sb.length() - 1;
                if (sb.lastIndexOf("?") < lastIndex) {
                    if (sb.lastIndexOf("=") < sb.lastIndexOf("?") + 2) {
                        throw new OkHttpsException("url \u683c\u5f0f\u9519\u8bef\uff0c'?' \u540e\u6ca1\u6709\u53d1\u73b0 '='");
                    }
                    if (sb.lastIndexOf("&") < lastIndex) {
                        sb.append('&');
                    }
                }
            } else {
                sb.append('?');
            }
            this.urlParams.forEach((name, value) -> {
                if (value == null) {
                    return;
                }
                sb.append((String)name).append('=').append(value).append('&');
            });
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    protected void assertNotConflict(boolean bodyCantUsed) {
        if (bodyCantUsed) {
            if (this.requestBody != null) {
                throw new OkHttpsException("GET | HEAD request can not call setBodyPara(..) method!");
            }
            if (HttpTask.isNotEmpty(this.bodyParams)) {
                throw new OkHttpsException("GET | HEAD request can not call addBodyPara(..) method!");
            }
            if (HttpTask.isNotEmpty(this.files)) {
                throw new OkHttpsException("GET | HEAD request can not call addFilePara(..) method!");
            }
        }
        if (this.requestBody != null) {
            if (HttpTask.isNotEmpty(this.bodyParams)) {
                throw new OkHttpsException("can not call addBodyPara(..) and setBodyPara(..) at the same time!");
            }
            if (HttpTask.isNotEmpty(this.files)) {
                throw new OkHttpsException("can not call addFilePara(..) and setBodyPara(..) at the same time!");
            }
        }
    }

    private static boolean isNotEmpty(Map<String, ?> map) {
        return map != null && !map.isEmpty();
    }

    protected boolean timeoutAwait(CountDownLatch latch) {
        try {
            return !latch.await(this.httpClient.preprocTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new OkHttpsException("execute timeout: " + this.urlPath, e);
        }
    }

    protected HttpResult timeoutResult() {
        if (this.nothrow) {
            return new RealHttpResult(this, HttpResult.State.TIMEOUT);
        }
        throw new OkHttpsException(HttpResult.State.TIMEOUT, "execute timeout: " + this.urlPath);
    }

    public Charset charset(Response response) {
        ResponseBody b = response.body();
        MediaType type = b != null ? b.contentType() : null;
        return type != null ? type.charset(this.charset) : this.charset;
    }

    protected void execute(Runnable command, boolean onIo) {
        this.httpClient.executor().execute(command, onIo);
    }

    public AbstractHttpClient httpClient() {
        return this.httpClient;
    }
}

