/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps;

import cn.zhxu.data.ListMap;
import cn.zhxu.okhttps.Download;
import cn.zhxu.okhttps.HttpTask;
import cn.zhxu.okhttps.Process;
import cn.zhxu.okhttps.TaskExecutor;
import cn.zhxu.okhttps.Toable;
import cn.zhxu.okhttps.internal.RealHttpResult;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Response;

public interface HttpResult {
    public static HttpResult of(Response response) {
        return HttpResult.of(response, null);
    }

    public static HttpResult of(Response response, TaskExecutor taskExecutor) {
        if (response != null) {
            return new RealHttpResult(null, response, taskExecutor);
        }
        throw new IllegalArgumentException("response \u4e0d\u80fd\u4e3a\u7a7a");
    }

    public static HttpResult of(HttpTask<?> task, Response response) {
        if (task != null && response != null) {
            return new RealHttpResult(task, response, task.httpClient.executor());
        }
        throw new IllegalArgumentException("task \u4e0e response \u4e0d\u80fd\u4e3a\u7a7a");
    }

    public State getState();

    public int getStatus();

    public boolean isSuccessful();

    @Deprecated
    public Headers getHeaders();

    public ListMap<String> allHeaders();

    public List<String> getHeaders(String var1);

    public String getHeader(String var1);

    public long getContentLength();

    public Body getBody();

    public HttpTask<?> getTask();

    public IOException getError();

    public HttpResult close();

    public static interface Body
    extends Toable {
        @Deprecated
        public MediaType getType();

        public long getLength();

        public Body nextOnIO();

        public Body setOnProcess(Consumer<Process> var1);

        public Body stepBytes(long var1);

        public Body stepRate(double var1);

        public Body setRangeIgnored();

        public Download toFile(String var1);

        public Download toFile(File var1);

        public Download toFolder(String var1);

        public Download toFolder(File var1);

        public Body cache();

        public Body close();
    }

    public static enum State {
        EXCEPTION,
        CANCELED,
        RESPONSED,
        TIMEOUT,
        NETWORK_ERROR;

    }
}

