/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.platform;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.UploadPretreatment;
import cn.xuyanwu.spring.file.storage.exception.FileStorageRuntimeException;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class LocalFileStorage
implements FileStorage {
    private String basePath;
    private String platform;
    private String domain;

    @Override
    public void close() {
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String path = fileInfo.getPath();
        File newFile = FileUtil.touch((String)(this.basePath + path), (String)fileInfo.getFilename());
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + path + fileInfo.getFilename());
        try {
            pre.getFileWrapper().transferTo(newFile);
            byte[] thumbnailBytes = pre.getThumbnailBytes();
            if (thumbnailBytes != null) {
                fileInfo.setThUrl(this.domain + path + fileInfo.getThFilename());
                FileUtil.writeBytes((byte[])thumbnailBytes, (String)(this.basePath + path + fileInfo.getThFilename()));
            }
            return true;
        }
        catch (IOException e) {
            FileUtil.del((File)newFile);
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        if (fileInfo.getThFilename() != null) {
            FileUtil.del((File)new File(fileInfo.getBasePath() + fileInfo.getPath(), fileInfo.getThFilename()));
        }
        return FileUtil.del((File)new File(fileInfo.getBasePath() + fileInfo.getPath(), fileInfo.getFilename()));
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        return new File(fileInfo.getBasePath() + fileInfo.getPath(), fileInfo.getFilename()).exists();
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (BufferedInputStream in = FileUtil.getInputStream((String)(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename()));){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        try (BufferedInputStream in = FileUtil.getInputStream((String)(fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename()));){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}

