/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.springframework.lang.Nullable;
import org.springframework.web.multipart.MultipartFile;

public class MockMultipartFile
implements MultipartFile {
    private final String name;
    private final String originalFilename;
    @Nullable
    private final String contentType;
    private final byte[] bytes;

    public MockMultipartFile(String name, InputStream in) {
        this(name, "", null, IoUtil.readBytes((InputStream)in));
    }

    public MockMultipartFile(String name, @Nullable byte[] bytes) {
        this(name, "", null, bytes);
    }

    public MockMultipartFile(String name, @Nullable String originalFilename, @Nullable String contentType, InputStream in) {
        this(name, originalFilename, contentType, IoUtil.readBytes((InputStream)in));
    }

    public MockMultipartFile(@Nullable String name, @Nullable String originalFilename, @Nullable String contentType, @Nullable byte[] bytes) {
        this.name = name != null ? name : "";
        this.originalFilename = originalFilename != null ? originalFilename : "";
        this.contentType = contentType;
        this.bytes = bytes != null ? bytes : new byte[]{};
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public long getSize() {
        return this.bytes.length;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void transferTo(File dest) {
        FileUtil.writeBytes((byte[])this.bytes, (File)dest);
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

