/*
 * Decompiled with CFR 0.152.
 */
package cn.sticki.spel.validator.jakarta;

import cn.sticki.spel.validator.core.SpelValidContext;
import cn.sticki.spel.validator.core.SpelValidExecutor;
import cn.sticki.spel.validator.core.parse.SpelParser;
import cn.sticki.spel.validator.core.result.FieldError;
import cn.sticki.spel.validator.core.result.ObjectValidResult;
import cn.sticki.spel.validator.jakarta.SpelValid;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class SpelValidator
implements ConstraintValidator<SpelValid, Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpelValidator.class);
    private SpelValid spelValid;

    public void initialize(SpelValid constraintAnnotation) {
        this.spelValid = constraintAnnotation;
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (!this.spelValid.condition().isEmpty() && !((Boolean)SpelParser.parse((String)this.spelValid.condition(), (Object)value, Boolean.class)).booleanValue()) {
            log.debug("SpelValid condition is not satisfied, skip validation, condition: {}", (Object)this.spelValid.condition());
            return true;
        }
        SpelValidContext spelValidContext = SpelValidContext.builder().locale(LocaleContextHolder.getLocale()).build();
        ObjectValidResult validateObjectResult = SpelValidExecutor.validateObject((Object)value, (String[])this.spelValid.spelGroups(), (SpelValidContext)spelValidContext);
        this.buildConstraintViolation(validateObjectResult, context);
        return validateObjectResult.noneError();
    }

    private void buildConstraintViolation(ObjectValidResult validateObjectResult, ConstraintValidatorContext context) {
        if (validateObjectResult.noneError()) {
            return;
        }
        context.disableDefaultConstraintViolation();
        for (FieldError error : validateObjectResult.getErrors()) {
            context.buildConstraintViolationWithTemplate(error.getErrorMessage()).addPropertyNode(error.getFieldName()).addConstraintViolation();
        }
    }
}

