/*
 * Decompiled with CFR 0.152.
 */
package cn.sticki.spel.validator.constraintvalidator;

import cn.sticki.spel.validator.constrain.SpelSize;
import cn.sticki.spel.validator.core.SpelConstraintValidator;
import cn.sticki.spel.validator.core.parse.SpelParser;
import cn.sticki.spel.validator.core.result.FieldValidResult;
import cn.sticki.spel.validator.core.util.CalcLengthUtil;
import java.lang.reflect.Field;
import java.util.Set;

public class SpelSizeValidator
implements SpelConstraintValidator<SpelSize> {
    public FieldValidResult isValid(SpelSize annotation, Object obj, Field field) throws IllegalAccessException {
        Object fieldValue = field.get(obj);
        if (fieldValue == null) {
            return FieldValidResult.success();
        }
        int size = CalcLengthUtil.calcFieldSize((Object)fieldValue);
        Integer min = (Integer)SpelParser.parse((String)annotation.min(), (Object)obj, Integer.class);
        Integer max = (Integer)SpelParser.parse((String)annotation.max(), (Object)obj, Integer.class);
        if (size < min || size > max) {
            return FieldValidResult.of((boolean)false, (Object[])new Object[]{min, max});
        }
        return FieldValidResult.success();
    }

    public Set<Class<?>> supportType() {
        return CalcLengthUtil.SUPPORT_TYPE;
    }
}

