/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.MD5Utils;
import cn.smarthse.common.util.passwordLog.Md5Utils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysMenuV3Service;
import cn.smarthse.modules.health.thirdOrganization.dao.sys.SysUserMapper;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.entity.sys.SysSearchParam;
import cn.smarthse.modules.health.thirdOrganization.entity.sys.SysUser;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.thirdOrganization.service.sys.ISysUserService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysUserServiceImpl
extends BaseServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    @Autowired
    private IThirdOrganizationService thirdOrganizationService;
    @Autowired
    private RedisClient redisClient;
    @DubboReference
    private ISysMenuV3Service sysMenuV3Service;

    public SysUser setPasswordInfo(SysUser user) {
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        String plainPassword = DigestUtils.md5Hex((String)"Zyj@2022");
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        user.setIsDefaultPwd(Boolean.valueOf(true));
        return user;
    }

    public SysUser getUserByuserame(String username) {
        if (StrUtil.isBlank((CharSequence)username)) {
            return null;
        }
        SysUser param = new SysUser();
        param.setUsername(username);
        username = username.replace("\uff08", "(");
        username = username.replace("\uff09", ")");
        param.setHalfUsername(SpringEncryptUtils.encrypt((String)username));
        username = username.replace("(", "\uff08");
        username = username.replace(")", "\uff09");
        param.setFullUsername(SpringEncryptUtils.encrypt((String)username));
        param.setUsername(StrUtil.toUpperCase((CharSequence)param.getUsername()));
        param.setHalfUsername(StrUtil.toUpperCase((CharSequence)param.getHalfUsername()));
        param.setFullUsername(StrUtil.toUpperCase((CharSequence)param.getFullUsername()));
        SysUser orgUser = ((SysUserMapper)this.dao).selectOrgUserByUsername(param);
        return orgUser;
    }

    public SysUser getTrusteeshipUserByUsername(String username) {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("username", (Object)username).andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("roleCode", (Object)1);
        return (SysUser)this.getOneByExample(example);
    }

    public SysUser getUserInfoByUserId(Long userId) {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("id", (Object)userId).andEqualTo("isValid", (Object)Boolean.TRUE);
        return (SysUser)this.getOneByExample(example);
    }

    @Transactional(readOnly=false)
    public void deleteByOrgIds(List<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            return;
        }
        ((SysUserMapper)this.dao).deleteByOrgIds(orgIds);
    }

    @Transactional(readOnly=false)
    public void deleteManagerUser(Long orgId) {
        this.logger.info("\u5220\u9664deleteManagerUser:{}", (Object)orgId);
        ((SysUserMapper)this.dao).deleteManagerUser(orgId);
    }

    public List<SysUser> listAllAdmin() {
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("isManger", (Object)true).andEqualTo("isValid", (Object)Boolean.TRUE);
        return this.getListByExample(example);
    }

    @Transactional(readOnly=false)
    public void updatePassStateThreeMonth() {
        ((SysUserMapper)this.dao).updatePassStateThreeMonth();
    }

    @Transactional(readOnly=false)
    public void recoverUserByOrgId(Long orgId) {
        ((SysUserMapper)this.dao).recoverUserByOrgId(orgId);
    }

    public PageInfo<SysUser> getUserListByCid(JqGridParam param, Long cid, String keyWord) {
        if (param == null || cid == null) {
            return new PageInfo();
        }
        SysSearchParam sysSearchParam = new SysSearchParam();
        sysSearchParam.setKeyWord(keyWord);
        sysSearchParam.setCid(cid);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SysUser> list = ((SysUserMapper)this.dao).getUserListByCid(sysSearchParam);
        return new PageInfo(list);
    }

    public Boolean haveThisUserName(String username) {
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("username", (Object)username).andEqualTo("isValid", (Object)Boolean.TRUE);
        List list = this.getListByExample(example);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean haveThisUserName(String username, Long cid) {
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("username", (Object)username).andEqualTo("isValid", (Object)Boolean.TRUE).andEqualTo("cid", (Object)cid);
        List list = this.getListByExample(example);
        return list != null && list.size() > 0;
    }

    public Boolean checkEmail(String email, Long userId) {
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("email", (Object)email).andEqualTo("isValid", (Object)Boolean.TRUE);
        SysUser record = (SysUser)this.getOneByExample(example);
        return record == null || record.getId().equals(userId);
    }

    public Boolean checkPassWord(Long userId, String passWord) {
        SysUser user = (SysUser)this.getById(userId);
        String plain = Encodes.unescapeHtml((String)passWord);
        byte[] salt = Digests.generateSalt((int)8);
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        String md5pass = Encodes.hexEncode((byte[])hashPassword);
        if (md5pass.equals(user.getPassword())) {
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void addMulti(List<SysUser> list) {
        for (SysUser sysUser : list) {
            this.add(sysUser);
        }
    }

    @Transactional(readOnly=false)
    public void disAbleUserByOrgId(Long orgId, Boolean isForbidden) {
        ((SysUserMapper)this.dao).disAbleUserByOrgId(orgId, isForbidden);
    }

    private void setInitPassword(SysUser user) {
        String plain = Encodes.unescapeHtml((String)user.getPassword());
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
    }

    @Transactional
    public SysUser register(SysUser sysUser) {
        sysUser.setUsername(sysUser.getUsername());
        sysUser.setCid(sysUser.getCid());
        this.setInitPassword(sysUser);
        sysUser.setEmail(sysUser.getEmail());
        sysUser.setCreateDate(new Date());
        sysUser.setUpdateDate(new Date());
        sysUser.setDataScope(Integer.valueOf(1));
        sysUser.setFaceId(Long.valueOf(0L));
        sysUser.setFullname(sysUser.getUsername());
        sysUser.setIsForbidden(Boolean.valueOf(false));
        sysUser.setCancelForbiddenTime(new Date());
        sysUser.setIsManger(Boolean.valueOf(true));
        sysUser.setIsValid(Boolean.valueOf(true));
        sysUser.setResource(Integer.valueOf(3));
        this.logger.info("\u521b\u5efa\u7528\u6237: {}", (Object)sysUser.getUsername());
        ((SysUserMapper)this.dao).insertSelective(sysUser);
        return sysUser;
    }

    public Boolean isExistsManager(Long orgId) {
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)orgId).andEqualTo("isManger", (Object)Boolean.TRUE).andEqualTo("isValid", (Object)Boolean.TRUE);
        return this.getOneByExample(example) != null;
    }

    public Boolean isHaveThisUserName(String username, Long excludeId) {
        if (StrUtil.isBlank((CharSequence)username)) {
            throw new HealthException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("username", (Object)username).andEqualTo("isValid", (Object)Boolean.TRUE);
        if (Objects.nonNull(excludeId)) {
            c.andNotEqualTo("id", (Object)excludeId);
        }
        return this.getCountByExample(example) > 0;
    }

    public Boolean isHaveThisName(List<String> nameList) {
        if (CollUtil.isEmpty(nameList)) {
            throw new HealthException("\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andIn("username", nameList).andEqualTo("isValid", (Object)Boolean.TRUE);
        return this.getCountByExample(example) > 0;
    }

    @Transactional
    public Boolean createSysUser(List<Long> idList, Long loginUserId) {
        if (Objects.isNull(loginUserId)) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u521b\u5efa\u8d26\u53f7\u7684\u673a\u6784");
        }
        List thirdOrganizationV3List = this.thirdOrganizationService.getListByIds(idList.stream().map(String::valueOf).collect(Collectors.joining(",")));
        if (CollUtil.isEmpty((Collection)thirdOrganizationV3List)) {
            throw new HealthException("\u8981\u521b\u5efa\u8d26\u53f7\u7684\u673a\u6784\u5df2\u4e0d\u5b58\u5728");
        }
        List<String> nameList = thirdOrganizationV3List.stream().map(ThirdOrganization::getName).collect(Collectors.toList());
        if (this.isHaveThisName(nameList).booleanValue()) {
            throw new HealthException("\u8981\u521b\u5efa\u8d26\u53f7\u7684\u673a\u6784\u9ed8\u8ba4\u540d\u79f0\u5df2\u5b58\u5728");
        }
        List<SysUser> sysUserList = this.getUserInfoByCidList(idList);
        if (CollUtil.isNotEmpty(sysUserList)) {
            Set cidList = sysUserList.stream().filter(SysUser::getIsManger).map(SysUser::getCid).collect(Collectors.toSet());
            idList.removeIf(i -> cidList.stream().anyMatch(j -> j.equals(i)));
            if (CollUtil.isEmpty(idList)) {
                throw new HealthException("\u8bf7\u9009\u62e9\u8981\u521b\u5efa\u8d26\u53f7\u7684\u673a\u6784");
            }
        }
        Date date = new Date();
        ArrayList<SysUser> addList = new ArrayList<SysUser>(thirdOrganizationV3List.size());
        for (ThirdOrganization org : thirdOrganizationV3List) {
            long userId = IdUtil.getSnowflakeNextId();
            SysUser user = new SysUser().setId(Long.valueOf(userId)).setCid(org.getId()).setUsername(org.getName()).setFullname(org.getName()).setIsForbidden(Boolean.FALSE).setIsManger(Boolean.TRUE).setIsValid(Boolean.TRUE).setCancelForbiddenTime(date).setCreateBy(loginUserId).setCreateDate(date);
            this.sysMenuV3Service.insertThirdUserRole(Long.valueOf(userId), org.getOrgTypes(), Boolean.TRUE.booleanValue());
            user = this.setPasswordInfo(user);
            addList.add(user);
        }
        this.addMulti(addList);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean deleteByUserId(Long userId, Long loginUserId) {
        if (Objects.isNull(userId)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7528\u6237");
        }
        SysUser user = this.getUserInfoByUserId(userId);
        if (Objects.isNull(user)) {
            throw new HealthException("\u8be5\u7528\u6237\u5df2\u4e0d\u5b58\u5728");
        }
        SysUser entity = new SysUser();
        entity.setId(userId);
        this.delete(entity, loginUserId);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean deleteByOrgId(Long orgId, Long loginUserId) {
        if (Objects.isNull(orgId)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u6240\u6709\u8d26\u53f7\u7684\u673a\u6784");
        }
        SysUser entity = new SysUser();
        entity.setCid(orgId);
        this.delete(entity, loginUserId);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean deleteByOrgIdList(List<Long> orgIdList, Long loginUserId) {
        if (CollUtil.isEmpty(orgIdList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u6240\u6709\u8d26\u53f7\u7684\u673a\u6784");
        }
        SysUser entity = new SysUser();
        entity.setIsValid(Boolean.FALSE);
        this.setUpdateInfo(entity, loginUserId);
        Example example = new Example(SysUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("cid", orgIdList).andEqualTo("isValid", (Object)Boolean.TRUE);
        return ((SysUserMapper)this.dao).updateByExampleSelective(entity, example) > 0;
    }

    @Transactional
    public Boolean enableOrDisable(Long id, Boolean isForbidden, Long loginUserId) {
        if (Objects.isNull(id)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u7528\u6237");
        }
        SysUser sysUser = this.getUserInfoByUserId(id);
        if (Objects.isNull(sysUser)) {
            throw new HealthException("\u8be5\u7528\u6237\u5df2\u4e0d\u5b58\u5728");
        }
        Example example = new Example(SysUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)Boolean.TRUE);
        SysUser entity = new SysUser();
        if (Boolean.TRUE.equals(isForbidden)) {
            criteria.andEqualTo("cid", (Object)sysUser.getCid());
            entity.setIsForbidden(Boolean.TRUE);
            entity.setForbiddenTime(new Date());
        } else {
            criteria.andEqualTo("id", (Object)id);
            entity.setIsForbidden(Boolean.FALSE);
            entity.setCancelForbiddenTime(new Date());
        }
        this.setUpdateInfo(entity, loginUserId);
        return ((SysUserMapper)this.dao).updateByExampleSelective(entity, example) > 0;
    }

    @Transactional
    public Boolean resetPassword(Long id, Long loginUserId) {
        boolean b;
        if (Objects.isNull(id)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u91cd\u7f6e\u5bc6\u7801\u7684\u7528\u6237");
        }
        SysUser sysUser = this.getUserInfoByUserId(id);
        if (Objects.isNull(sysUser)) {
            throw new HealthException("\u8be5\u7528\u6237\u5df2\u4e0d\u5b58\u5728");
        }
        SysUser user = new SysUser();
        user.setId(id);
        this.setUpdateInfo(user, loginUserId);
        user = this.setPasswordInfo(user);
        boolean bl = b = ((SysUserMapper)this.dao).updateByPrimaryKeySelective(user) > 0;
        if (b) {
            this.redisClient.del(new String[]{"org-web" + Md5Utils.hash((String)sysUser.getUsername())});
        }
        return b;
    }

    public List<SysUser> getUserInfoByCidList(List<Long> cidList) {
        if (CollUtil.isEmpty(cidList)) {
            return Collections.emptyList();
        }
        Example example = new Example(SysUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("cid", cidList).andEqualTo("isValid", (Object)Boolean.TRUE);
        return ((SysUserMapper)this.dao).selectByExample(example);
    }

    @Transactional
    public List<SysUser> isDefaultPwdList() {
        Example example = new Example(SysUser.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isDefaultPwd", (Object)Boolean.FALSE).andEqualTo("isValid", (Object)Boolean.TRUE);
        List list = ((SysUserMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        String defaultPwdMD5 = MD5Utils.getMD5String((String)"Zyj@2022");
        String defaultSupervisePwdMD5 = MD5Utils.getMD5String((String)"Zjs@2022");
        List<SysUser> rst = list.parallelStream().filter(user -> {
            byte[] salt = Encodes.hexDecode((String)user.getSalt());
            byte[] hashPassword1 = Digests.sha1((byte[])defaultPwdMD5.getBytes(), (byte[])salt, (int)1024);
            String inputPasswordHash1 = Encodes.hexEncode((byte[])hashPassword1);
            byte[] hashPassword2 = Digests.sha1((byte[])defaultSupervisePwdMD5.getBytes(), (byte[])salt, (int)1024);
            String inputPasswordHash2 = Encodes.hexEncode((byte[])hashPassword2);
            return Objects.equals(inputPasswordHash1, user.getPassword()) || Objects.equals(inputPasswordHash2, user.getPassword());
        }).collect(Collectors.toList());
        this.batchUpdateOrInsert(rst, SysUserMapper.class, (e, mapper) -> mapper.updateByPrimaryKeySelective(e));
        return rst;
    }

    public SysUser getUserByuserameAndCid(String username, Long cid) {
        String enUsername = SpringEncryptUtils.encrypt((String)username);
        Example example = new Example(SysUser.class);
        example.createCriteria().andEqualTo("username", (Object)enUsername).andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)Global.TRUE);
        return (SysUser)this.getOneByExample(example);
    }
}

