/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.log.LogSourceEnum;
import cn.smarthse.modules.datacentre.model.log.SysLog;
import cn.smarthse.modules.datacentre.provider.log.IShareCommonLogService;
import cn.smarthse.modules.health.thirdOrganization.dao.sys.SysLogMapper;
import cn.smarthse.modules.health.thirdOrganization.model.sys.OrgLoginNum;
import cn.smarthse.modules.health.thirdOrganization.model.sys.OrgLoginNumQueryParam;
import cn.smarthse.modules.health.thirdOrganization.service.sys.ISysLogService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysLogServiceImpl
extends BaseServiceImpl<SysLogMapper, cn.smarthse.modules.health.entity.sys.SysLog>
implements ISysLogService {
    @DubboReference
    private IShareCommonLogService shareCommonLogService;

    @Transactional(readOnly=false)
    public void addLog(cn.smarthse.modules.health.entity.sys.SysLog log) {
        SysLog clog = new SysLog();
        BeanUtils.copyProperties((Object)log, (Object)clog);
        clog.setLogSource(LogSourceEnum.organization.getCode());
        if (log.getSysArea() != null) {
            clog.setProvinceId(log.getSysArea().getProvinceId());
            clog.setCityId(log.getSysArea().getCityId());
            clog.setAreaId(log.getSysArea().getAreaId());
            clog.setStreetId(log.getSysArea().getStreetId());
        }
        this.shareCommonLogService.addLog(clog);
    }

    public PageInfo<cn.smarthse.modules.health.entity.sys.SysLog> getList(JqGridParam param) {
        Example example = new Example(cn.smarthse.modules.health.entity.sys.SysLog.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)param.getCid());
        c.andEqualTo("isValid", (Object)Global.TRUE);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = null;
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            example.setOrderByClause(param.getSidx() + " " + param.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        list = this.getListByExample(example);
        return new PageInfo(list);
    }

    public PageInfo<cn.smarthse.modules.health.entity.sys.SysLog> getErrorList(JqGridParam param) {
        Example example = new Example(cn.smarthse.modules.health.entity.sys.SysLog.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.FALSE);
        c.andEqualTo("type", (Object)0);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = null;
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            example.setOrderByClause(param.getSidx() + " " + param.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        list = this.getListByExample(example);
        return new PageInfo(list);
    }

    public PageInfo<OrgLoginNum> queryLoginNum(OrgLoginNumQueryParam param) {
        if (param.getOrgIds() != null && param.getOrgIds().isEmpty()) {
            param.getOrgIds().add(-1L);
        }
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List<OrgLoginNum> list = ((SysLogMapper)this.dao).queryLoginNum(param);
        return new PageInfo(list);
    }
}

