/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.sys.impl;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.thirdOrganization.dao.sys.SysAreaStandardMapper;
import cn.smarthse.modules.health.thirdOrganization.model.sys.SysAreaStandard;
import cn.smarthse.modules.health.thirdOrganization.service.sys.AreaService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class AreaServiceImpl
extends BaseServiceImpl<SysAreaStandardMapper, SysAreaStandard>
implements AreaService {
    public JqGridData<SysAreaStandard> getGridData(JqGridParam param, SysAreaStandard queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Example example = new Example(SysAreaStandard.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true);
        if (queryParam != null) {
            if (queryParam.getLevel() != null) {
                c.andEqualTo("level", (Object)queryParam.getLevel());
            }
            if (queryParam.getName() != null && !"".equals(queryParam.getName())) {
                c.andLike("name", "%" + queryParam.getName() + "%");
            }
            if (queryParam.getProvinceId() != null) {
                c.andEqualTo("provinceId", (Object)queryParam.getProvinceId());
            }
            if (queryParam.getCityId() != null) {
                c.andEqualTo("cityId", (Object)queryParam.getCityId());
            }
            if (queryParam.getAreaId() != null) {
                c.andEqualTo("areaId", (Object)queryParam.getAreaId());
            }
        }
        List list = this.getListByExample(example);
        PageInfo page = new PageInfo(list);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    public List<SysAreaStandard> getCascadeByLevel(Long areaId, int level) {
        Example example = new Example(SysAreaStandard.class);
        if (level == 1) {
            example.createCriteria().andEqualTo("level", (Object)level).andEqualTo("isValid", (Object)true);
        } else if (level == 2) {
            example.createCriteria().andEqualTo("provinceId", (Object)areaId).andEqualTo("isValid", (Object)true);
        } else if (level == 3) {
            example.createCriteria().andEqualTo("cityId", (Object)areaId).andEqualTo("isValid", (Object)true);
        } else if (level == 4) {
            example.createCriteria().andEqualTo("areaId", (Object)areaId).andEqualTo("isValid", (Object)true);
        }
        return ((SysAreaStandardMapper)this.dao).selectByExample(example);
    }

    public List<SysAreaStandard> getSysAreaListByPid(Long pid) {
        Example example = new Example(SysAreaStandard.class);
        example.createCriteria().andEqualTo("parentId", (Object)pid).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("id asc");
        return ((SysAreaStandardMapper)this.dao).selectByExample(example);
    }

    public List<SysAreaStandard> getAllSysAreaList() {
        Example example = new Example(SysAreaStandard.class);
        example.createCriteria().andEqualTo("isValid", (Object)true);
        example.setOrderByClause("level asc");
        return ((SysAreaStandardMapper)this.dao).selectByExample(example);
    }

    public Long getAreaProvinceId(Long areaId) {
        if (areaId == null) {
            return 330000000000L;
        }
        Long provinceId = ((SysAreaStandardMapper)this.dao).selectAreaProvinceId(areaId);
        return provinceId;
    }

    public SysAreaStandard get(Long id) {
        return ((SysAreaStandardMapper)this.dao).getSysAreaByIdBigData(id);
    }

    public List<SysAreaStandard> getProvince() {
        Example example = new Example(SysAreaStandard.class);
        example.createCriteria().andEqualTo("parentId", (Object)0).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("id asc");
        return ((SysAreaStandardMapper)this.dao).selectByExample(example);
    }

    public List<SysAreaStandard> getChildren(Long sysareaId) {
        if (sysareaId == null) {
            return new ArrayList<SysAreaStandard>();
        }
        return ((SysAreaStandardMapper)this.dao).selectParentId(sysareaId);
    }

    public List<SysAreaStandard> getChildrenDc(Long sysareaId) {
        if (sysareaId == null) {
            return new ArrayList<SysAreaStandard>();
        }
        return ((SysAreaStandardMapper)this.dao).selectParentId(sysareaId);
    }

    public Map getAreaList(Long areaId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<SysAreaStandard> provinceList = this.getChildrenDc(0L);
        List<SysAreaStandard> cityList = null;
        List<SysAreaStandard> areaList = null;
        List<SysAreaStandard> streetList = null;
        map.put("provinceList", provinceList);
        SysAreaStandard area = this.getSysAreaStandardCacheById(areaId);
        if (area == null) {
            return map;
        }
        switch (area.getLevel()) {
            case 1: {
                map.put("provinceId", area.getProvinceId());
                break;
            }
            case 2: {
                map.put("provinceId", area.getProvinceId());
                cityList = this.getChildrenDc(area.getProvinceId());
                map.put("cityList", cityList);
                map.put("cityId", area.getCityId());
                break;
            }
            case 3: {
                map.put("provinceId", area.getProvinceId());
                cityList = this.getChildrenDc(area.getProvinceId());
                map.put("cityList", cityList);
                map.put("cityId", area.getCityId());
                areaList = this.getChildrenDc(area.getCityId());
                map.put("areaList", areaList);
                map.put("areaId", area.getAreaId());
                break;
            }
            case 4: {
                map.put("provinceId", area.getProvinceId());
                cityList = this.getChildrenDc(area.getProvinceId());
                map.put("cityList", cityList);
                map.put("cityId", area.getCityId());
                areaList = this.getChildrenDc(area.getCityId());
                map.put("areaList", areaList);
                map.put("areaId", area.getAreaId());
                streetList = this.getChildrenDc(area.getAreaId());
                map.put("streetList", streetList);
                map.put("streetId", area.getStreetId());
                break;
            }
        }
        return map;
    }

    public Map getAreaListFromDc(Long areaId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<SysAreaStandard> provinceList = this.getChildrenDc(0L);
        List<SysAreaStandard> cityList = null;
        List<SysAreaStandard> areaList = null;
        List<SysAreaStandard> streetList = null;
        map.put("provinceList", provinceList);
        SysAreaStandard area = this.getSysAreaByIdBigData(areaId);
        if (area == null) {
            return map;
        }
        switch (area.getLevel()) {
            case 1: {
                map.put("provinceId", area.getProvinceId());
                break;
            }
            case 2: {
                map.put("provinceId", area.getProvinceId());
                cityList = this.getChildrenDc(area.getProvinceId());
                map.put("cityList", cityList);
                map.put("cityId", area.getCityId());
                break;
            }
            case 3: {
                map.put("provinceId", area.getProvinceId());
                cityList = this.getChildrenDc(area.getProvinceId());
                map.put("cityList", cityList);
                map.put("cityId", area.getCityId());
                areaList = this.getChildrenDc(area.getCityId());
                map.put("areaList", areaList);
                map.put("areaId", area.getAreaId());
                break;
            }
            case 4: {
                map.put("provinceId", area.getProvinceId());
                cityList = this.getChildrenDc(area.getProvinceId());
                map.put("cityList", cityList);
                map.put("cityId", area.getCityId());
                areaList = this.getChildrenDc(area.getCityId());
                map.put("areaList", areaList);
                map.put("areaId", area.getAreaId());
                streetList = this.getChildrenDc(area.getAreaId());
                map.put("streetList", streetList);
                map.put("streetId", area.getStreetId());
                break;
            }
        }
        return map;
    }

    public List<SysAreaStandard> getCitys() {
        Example example = new Example(SysAreaStandard.class);
        example.createCriteria().andEqualTo("level", (Object)2).andNotEqualTo("provinceName", null).andEqualTo("isValid", (Object)true);
        example.setOrderByClause(" id asc");
        return ((SysAreaStandardMapper)this.dao).selectByExample(example);
    }

    public String getCityNames(String areaIds) {
        if (StringUtil.isEmpty((String)areaIds)) {
            return null;
        }
        List<SysAreaStandard> list = this.getListByIds(areaIds);
        if (list.size() == 0) {
            return null;
        }
        StringBuffer cityNames = new StringBuffer();
        list.forEach(area -> cityNames.append(area.getProvinceCityName()).append("\u3001"));
        return cityNames.substring(0, cityNames.length() - 1);
    }

    public SysAreaStandard getSysAreaStandardCacheById(Long id) {
        return ((SysAreaStandardMapper)this.dao).getSysAreaByIdBigData(id);
    }

    public SysAreaStandard getSysAreaByIdBigData(Long id) {
        if (id == null) {
            return null;
        }
        return ((SysAreaStandardMapper)this.dao).getSysAreaByIdBigData(id);
    }

    public String getFullName(Long areaId) {
        SysAreaStandard s;
        ArrayList<String> names = new ArrayList<String>();
        Map map = this.getAreaList(areaId);
        Long level1 = (Long)map.get("provinceId");
        Long level2 = (Long)map.get("cityId");
        Long level3 = (Long)map.get("areaId");
        if (level1 != null && (s = this.getSysAreaStandardCacheById(level1)) != null && !StringUtil.isEmpty((String)s.getName())) {
            names.add(s.getName());
        }
        if (level2 != null && (s = this.getSysAreaStandardCacheById(level2)) != null && !StringUtil.isEmpty((String)s.getName())) {
            names.add(s.getName());
        }
        if (level3 != null && (s = this.getSysAreaStandardCacheById(level3)) != null && !StringUtil.isEmpty((String)s.getName())) {
            names.add(s.getName());
        }
        if (names.size() > 0) {
            return String.join((CharSequence)",", names);
        }
        return "";
    }

    public String getFullName2(Long areaId, String splitStr) {
        SysAreaStandard area = this.get(areaId);
        if (area != null && StringUtils.isNotBlank((String)area.getProvinceName())) {
            StringBuffer sb = new StringBuffer("");
            sb.append(area.getProvinceName());
            if (StringUtils.isNotBlank((String)area.getCityName())) {
                sb.append(splitStr).append(area.getCityName());
            }
            if (StringUtils.isNotBlank((String)area.getAreaName())) {
                sb.append(splitStr).append(area.getAreaName());
            }
            return sb.toString();
        }
        return "";
    }

    public List<SysAreaStandard> getProvinces() {
        Example example = new Example(SysAreaStandard.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("level", (Object)1).andIsNotNull("shortName");
        return this.getListByExample(example);
    }

    public Long getProvinceAreaIdByName(String name) {
        Example example = new Example(SysAreaStandard.class);
        example.createCriteria().andEqualTo("level", (Object)1).andLike("name", "%" + name + "%").andEqualTo("isValid", (Object)true);
        example.setOrderByClause(" id asc");
        List list = ((SysAreaStandardMapper)this.dao).selectByExample(example);
        Long areaId = null;
        if (list != null && list.size() > 0) {
            areaId = ((SysAreaStandard)list.get(0)).getId();
        }
        return areaId;
    }

    public List<SysAreaStandard> getZJAreaList() {
        Example example = new Example(SysAreaStandard.class);
        example.createCriteria().andEqualTo("provinceId", (Object)330000000000L).andEqualTo("isValid", (Object)true);
        example.setOrderByClause("level desc");
        return ((SysAreaStandardMapper)this.dao).selectByExample(example);
    }
}

