/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.outpackcompany.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyOutpackVO;
import cn.smarthse.modules.datacentre.model.LaborDispatchSituationVO;
import cn.smarthse.modules.datacentre.model.PhcPhysicalStaffCheckVO;
import cn.smarthse.modules.datacentre.model.PhyDataMatchVo;
import cn.smarthse.modules.datacentre.model.companyoutpack.CompanyOutpackModel;
import cn.smarthse.modules.datacentre.model.companyoutpack.CompanyOutpackSearchModel;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckOutpackCompanyMatch;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckOutpackCompanyMatchWorkList;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfoVO;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryService;
import cn.smarthse.modules.health.thirdOrganization.dao.outpackcompany.OutpackCompanyMapper;
import cn.smarthse.modules.health.thirdOrganization.service.outpackcompany.IOutpackCompanyService;
import cn.smarthse.modules.health.thirdOrganization.service.sys.ISysAreaService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
@DubboService
@Transactional(readOnly=true)
public class OutpackCompanyServiceImpl
extends BaseServiceImpl<OutpackCompanyMapper, Company>
implements IOutpackCompanyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OutpackCompanyServiceImpl.class);
    @Autowired
    private RedisClient redisClient;
    private static final String CACHE_NAME = "OutpackCompanyServiceImpl";
    @Resource
    private OutpackCompanyMapper outpackCompanyMapper;
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    private DataSourceTransactionManager txManager;
    @DubboReference
    private IKeyFactoryService iKeyFactoryService;
    @Autowired
    protected IdWorker idworker;

    public PageInfo<CompanyOutpackVO> getDelegateUnitList(JqGridParam param, CompanyOutpackSearchModel model) {
        PageMethod.startPage((int)param.getPage(), (int)param.getRows());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String beginTime = null;
        String endTime = null;
        if (param.getBeginTime() != null) {
            beginTime = sdf.format(param.getBeginTime());
        }
        if (param.getEndTime() != null) {
            endTime = sdf.format(param.getEndTime());
        }
        List<PhcPhysicalStaffCheckInfo> validPhyList = this.outpackCompanyMapper.selectDelegateUnitList(model, param, beginTime, endTime);
        PageInfo validPhyPage = new PageInfo(validPhyList);
        List<String> validUccList = validPhyList.stream().map(PhcPhysicalStaffCheckInfo::getCreditCode).collect(Collectors.toList());
        ArrayList comOutpackVoRet = new ArrayList();
        if (!validUccList.isEmpty()) {
            List<Company> companyList = this.outpackCompanyMapper.selectCompanyInfoByUccBatch(validUccList);
            List<LaborDispatchSituationVO> situationVoList = this.outpackCompanyMapper.selectCompanyPersonPhyNumInfoBatch(validUccList);
            validPhyList.forEach(sta -> {
                CompanyOutpackVO vo = new CompanyOutpackVO();
                String creditCode = sta.getCreditCode();
                Company company = companyList.stream().filter(c -> Objects.equals(creditCode, c.getUnifiedSocialCc())).findFirst().orElse(new Company());
                vo.setCid(company.getId());
                vo.setCompanyName(company.getName());
                vo.setUnifiedSocialCc(creditCode);
                vo.setAddress(company.getRegisterAddress());
                comOutpackVoRet.add(vo);
            });
            comOutpackVoRet.forEach(vo -> {
                String ucc = vo.getUnifiedSocialCc();
                List oneList = situationVoList.stream().filter(s -> ucc.equals(s.getCreditCode())).collect(Collectors.toList());
                if (oneList.isEmpty()) {
                    vo.setEmpNum(Integer.valueOf(0));
                    vo.setLaborDispatchNum(Integer.valueOf(0));
                } else {
                    LaborDispatchSituationVO vo1 = oneList.stream().filter(m -> m.getIsOc() == false).findFirst().orElse(null);
                    LaborDispatchSituationVO vo2 = oneList.stream().filter(LaborDispatchSituationVO::getIsOc).findFirst().orElse(null);
                    vo.setEmpNum(Integer.valueOf(vo1 == null ? 0 : vo1.getEmpCount()));
                    vo.setLaborDispatchNum(Integer.valueOf(vo2 == null ? 0 : vo2.getEmpCount()));
                    boolean hasNeedToMatch = vo2 != null && vo2.getIsOc() != false && vo2.getOverMatchCount() < vo2.getEmpCount();
                    vo.setHasNeedToMatch(Boolean.valueOf(hasNeedToMatch));
                }
            });
        }
        PageInfo voPage = new PageInfo(comOutpackVoRet);
        BeanUtils.copyProperties((Object)validPhyPage, (Object)voPage);
        voPage.setList(comOutpackVoRet);
        return voPage;
    }

    public PageInfo<CompanyOutpackVO> getDelegateUnitListNew(JqGridParam pageParam, CompanyOutpackSearchModel outParam) {
        Page page = PageMethod.startPage((int)pageParam.getPage(), (int)pageParam.getRows());
        List<PhcPhysicalStaffCheckInfo> validPhyList = this.outpackCompanyMapper.selectDelegateUnitListNew(outParam);
        List<String> validUccList = validPhyList.stream().map(PhcPhysicalStaffCheckInfo::getCreditCode).collect(Collectors.toList());
        ArrayList comOutpackVoRet = new ArrayList();
        if (CollUtil.isNotEmpty(validUccList)) {
            List<Company> companyList = this.outpackCompanyMapper.selectCompanyInfoByUccBatch(validUccList);
            List<LaborDispatchSituationVO> situationVoList = this.outpackCompanyMapper.selectCompanyPersonPhyNumInfoBatch(validUccList);
            validPhyList.forEach(sta -> {
                CompanyOutpackVO vo = new CompanyOutpackVO();
                String creditCode = sta.getCreditCode();
                Company company = companyList.stream().filter(c -> Objects.equals(creditCode, c.getUnifiedSocialCc())).findFirst().orElse(new Company());
                vo.setCid(company.getId());
                vo.setCompanyName(company.getName());
                vo.setUnifiedSocialCc(creditCode);
                vo.setAddress(company.getRegisterAddress());
                comOutpackVoRet.add(vo);
            });
            comOutpackVoRet.forEach(vo -> {
                String ucc = vo.getUnifiedSocialCc();
                List oneList = situationVoList.stream().filter(s -> ucc.equals(s.getCreditCode())).collect(Collectors.toList());
                if (oneList.isEmpty()) {
                    vo.setEmpNum(Integer.valueOf(0));
                    vo.setLaborDispatchNum(Integer.valueOf(0));
                } else {
                    LaborDispatchSituationVO vo1 = oneList.stream().filter(m -> m.getIsOc() == false).findFirst().orElse(null);
                    LaborDispatchSituationVO vo2 = oneList.stream().filter(LaborDispatchSituationVO::getIsOc).findFirst().orElse(null);
                    vo.setEmpNum(Integer.valueOf(vo1 == null ? 0 : vo1.getEmpCount()));
                    vo.setLaborDispatchNum(Integer.valueOf(vo2 == null ? 0 : vo2.getEmpCount()));
                    boolean hasNeedToMatch = vo2 != null && vo2.getIsOc() != false && vo2.getOverMatchCount() < vo2.getEmpCount();
                    vo.setHasNeedToMatch(Boolean.valueOf(hasNeedToMatch));
                }
            });
        }
        PageInfo voPage = new PageInfo(comOutpackVoRet);
        BeanUtils.copyProperties((Object)page, (Object)voPage);
        voPage.setList(comOutpackVoRet);
        return voPage;
    }

    @Deprecated
    public PageInfo<PhcPhysicalStaffCheckVO> getPhysicalPersonList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer type, String date) {
        Long cid = searchVo.getCid();
        String ucc = searchVo.getUnifiedSocialCc();
        if (ucc == null || "".equals(ucc.trim())) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff01");
        }
        PageMethod.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcPhysicalStaffCheckVO> voList = this.outpackCompanyMapper.selectPhysicalPersonList(searchVo, ucc, null, type);
        List<String> uccList = voList.stream().filter(l -> l.getEmployerNameEmployer() == null).map(PhcPhysicalStaffCheckVO::getCreditCodeEmployer).collect(Collectors.toList());
        if (!uccList.isEmpty()) {
            List<Company> companyList = this.outpackCompanyMapper.selectCompanyInfoByUccBatch(uccList);
            voList.forEach(l -> {
                if (l.getEmployerNameEmployer() == null) {
                    companyList.stream().filter(c -> Objects.equals(c.getUnifiedSocialCc(), l.getCreditCodeEmployer())).findFirst().ifPresent(company -> l.setEmployerNameEmployer(company.getName()));
                }
            });
        }
        return new PageInfo(voList);
    }

    public PageInfo<PhcPhysicalStaffCheckVO> getPhysicalPersonResultList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer type, String date) {
        Long cid = searchVo.getCid();
        String ucc = searchVo.getUnifiedSocialCc();
        if (ucc == null || "".equals(ucc.trim())) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff01");
        }
        PageMethod.startPage((int)param.getPage(), (int)param.getRows());
        List<PhcPhysicalStaffCheckVO> voResultList = this.outpackCompanyMapper.selectPhysicalPersonResultList(searchVo, ucc, null, type, searchVo.getMatchingType());
        List<String> uccList = voResultList.stream().filter(l -> l.getEmployerNameEmployer() == null).map(PhcPhysicalStaffCheckVO::getCreditCodeEmployer).collect(Collectors.toList());
        if (!uccList.isEmpty()) {
            List<Company> companyList = this.outpackCompanyMapper.selectCompanyInfoByUccBatch(uccList);
            voResultList.forEach(l -> {
                if (l.getEmployerNameEmployer() == null) {
                    companyList.stream().filter(c -> Objects.equals(c.getUnifiedSocialCc(), l.getCreditCodeEmployer())).findFirst().ifPresent(company -> l.setEmployerNameEmployer(company.getName()));
                }
            });
        }
        return new PageInfo(voResultList);
    }

    public PageInfo<LaborDispatchSituationVO> getPhysicalPersonByYearResultList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer type, String date) {
        Long cid = searchVo.getCid();
        Company company = this.outpackCompanyMapper.selectCompanyInfoByCid(cid);
        if (company == null) {
            throw new ServiceException("\u4f01\u4e1a\u4e0d\u5b58\u5728\uff01");
        }
        String ucc = company.getUnifiedSocialCc();
        Integer year = searchVo.getYear();
        PageMethod.startPage((int)param.getPage(), (int)param.getRows());
        List<LaborDispatchSituationVO> laborDispatchSituationVOS = this.outpackCompanyMapper.selectPhysicalPersonByYearResultList(ucc, year);
        laborDispatchSituationVOS.forEach(v -> {
            v.setCid(cid);
            v.setName(company.getName());
            v.setAddress(company.getRegisterAddress());
        });
        return new PageInfo(laborDispatchSituationVOS);
    }

    public PageInfo<LaborDispatchSituationVO> getPhysicalPersonByMonthResultList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer type, String date) {
        boolean yearBlank;
        boolean uccBlank;
        String ucc = searchVo.getUnifiedSocialCc();
        boolean bl = uccBlank = ucc == null || "".equals(ucc.trim());
        if (uccBlank) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff01");
        }
        boolean bl2 = yearBlank = searchVo.getYear() == null;
        if (yearBlank) {
            throw new ServiceException("\u8bf7\u4f20\u5165\u5e74\u4efd\uff01");
        }
        PageMethod.startPage((int)param.getPage(), (int)param.getRows());
        List<LaborDispatchSituationVO> laborDispatchSituationVOS = this.outpackCompanyMapper.selectPhysicalPersonByMonthResultList(searchVo.getUnifiedSocialCc(), searchVo.getYear(), searchVo.getMonth());
        List<Company> companies = this.outpackCompanyMapper.selectCompanyInfoByUcc(ucc);
        if (companies != null && !companies.isEmpty()) {
            Company company = companies.get(0);
            for (LaborDispatchSituationVO v : laborDispatchSituationVOS) {
                v.setCid(company.getId());
                v.setName(company.getName());
                v.setAddress(company.getRegisterAddress());
            }
        }
        return new PageInfo(laborDispatchSituationVOS);
    }

    public List<CompanyOutpackModel> getActualEmpUnit(String unifiedSocialCc, String keyword) {
        List<CompanyOutpackModel> companyOutpackModels = this.outpackCompanyMapper.selectActualEmpUnit(unifiedSocialCc);
        return companyOutpackModels;
    }

    public PageInfo<CompanyOutpackModel> getAllActualEmpUnit(JqGridParam jqGridParam, String keyword) {
        Page page = PageMethod.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        this.outpackCompanyMapper.selectAllActualEmpUnit(keyword);
        return new PageInfo((List)page);
    }

    @Deprecated
    public List<PhcPhysicalStaffCheckVO> getPersonMatchDataList(String unifiedSocialCc, String personKeyword, Integer type) {
        List<PhcPhysicalStaffCheckVO> phcPhysicalStaffCheckVOS = this.outpackCompanyMapper.selectPhysicalPersonList(null, unifiedSocialCc, personKeyword, type);
        List<PhcPhysicalStaffCheckVO> collect = phcPhysicalStaffCheckVOS.stream().filter(o -> "1".equals(o.getIsOc()) && "0".equals(o.getIsMatch())).collect(Collectors.toList());
        return collect;
    }

    public List<PhcPhysicalStaffCheckVO> getPersonMatchResultDataList(PhcPhysicalCheckSearchVo searchVo, String unifiedSocialCc, String keyword, Integer type) {
        List<PhcPhysicalStaffCheckVO> phcPhysicalStaffCheckVOS = this.outpackCompanyMapper.selectPhysicalPersonResultList(searchVo, unifiedSocialCc, keyword, type, null);
        boolean hasWorkListId = searchVo != null && searchVo.getWorkListId() != null && searchVo.getWorkListId() > 0L;
        List<Object> collect = phcPhysicalStaffCheckVOS;
        if (!hasWorkListId) {
            collect = phcPhysicalStaffCheckVOS.stream().filter(o -> "1".equals(o.getIsOc()) && "0".equals(o.getIsMatch())).collect(Collectors.toList());
        }
        return collect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String matchPersonActualCompany(List<PhcPhysicalStaffCheckInfoVO> voList) {
        List<PhcPhysicalCheckOutpackCompanyMatch> selectMatchList = this.outpackCompanyMapper.selectMatchInfo(voList);
        Long workListId = null;
        if (selectMatchList != null && !selectMatchList.isEmpty()) {
            PhcPhysicalCheckOutpackCompanyMatch match = selectMatchList.get(0);
            workListId = match.getMatchWorkListId();
            this.doDeleteOriginalMatch(selectMatchList);
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            String cids = null;
            if (voList != null && !voList.isEmpty()) {
                List<Long> idList = voList.stream().map(PhcPhysicalStaffCheckInfoVO::getId).collect(Collectors.toList());
                List<PhcPhysicalStaffCheckInfo> staffResult = this.outpackCompanyMapper.selectPhcPhysicalStaffCheckInfo(idList);
                ArrayList<PhcPhysicalCheckOutpackCompanyMatch> matchList = new ArrayList<PhcPhysicalCheckOutpackCompanyMatch>();
                for (PhcPhysicalStaffCheckInfo staff : staffResult) {
                    PhcPhysicalStaffCheckInfoVO paramInfo = voList.stream().filter(v -> staff.getId().equals(v.getId())).findFirst().orElse(null);
                    if (paramInfo != null) {
                        workListId = paramInfo.getWorkListId();
                    }
                    PhcPhysicalCheckOutpackCompanyMatch match = new PhcPhysicalCheckOutpackCompanyMatch();
                    match.setId(Long.valueOf(this.idworker.nextId()));
                    match.setStaffCheckId(staff.getId());
                    match.setStaffName(staff.getName());
                    match.setIdCard(staff.getIdcardCode());
                    Byte matchingType = paramInfo.getMatchingType() == null || paramInfo.getMatchingType() == 0 ? (byte)0 : paramInfo.getMatchingType();
                    match.setMatchingType(matchingType);
                    match.setCheckTime(staff.getCheckTime());
                    String checkType = staff.getBodyCheckType().trim();
                    boolean isBlank = "".equals(checkType);
                    match.setBodyCheckType(isBlank ? null : Integer.valueOf(checkType));
                    match.setConclusion(staff.getConclusion());
                    match.setSourceId(staff.getSourceId());
                    match.setOrgCode(staff.getOrgCode());
                    if (staff.getCid() == null) {
                        List<Company> outpacks = this.outpackCompanyMapper.selectCompanyInfoByUcc(staff.getCreditCode());
                        if (outpacks == null || outpacks.isEmpty()) return "\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u4e0d\u5b58\u5728\uff01";
                        Company outpack = outpacks.get(0);
                        match.setOutpackCid(outpack.getId());
                        match.setOutpackUcc(outpack.getUnifiedSocialCc());
                    } else {
                        match.setOutpackCid(staff.getCid());
                        match.setOutpackUcc(staff.getCreditCode());
                    }
                    String actualUcc = paramInfo.getActualUcc();
                    if (actualUcc != null && !"".equals(actualUcc.trim())) {
                        Company company = this.outpackCompanyMapper.selectCompanyInfoByUcc(actualUcc).get(0);
                        match.setCompanyCid(company.getId());
                        match.setCompanyUcc(company.getUnifiedSocialCc());
                    } else if (staff.getActualEmployerId() == null) {
                        List<Company> companies = this.outpackCompanyMapper.selectCompanyInfoByUcc(staff.getCreditCodeEmployer());
                        cids = companies.stream().map(c -> c.getId().toString()).collect(Collectors.joining(","));
                        if (companies == null || companies.isEmpty()) return "\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u4e0d\u5b58\u5728\uff01";
                        Company company = companies.get(0);
                        match.setCompanyCid(company.getId());
                        match.setCompanyUcc(company.getUnifiedSocialCc());
                    } else {
                        match.setCompanyCid(staff.getActualEmployerId());
                        cids = String.valueOf(staff.getActualEmployerId());
                        match.setCompanyUcc(staff.getCreditCodeEmployer());
                    }
                    matchList.add(match);
                }
                for (PhcPhysicalCheckOutpackCompanyMatch match : matchList) {
                    match.setMatchWorkListId(workListId);
                }
                this.outpackCompanyMapper.macthDataList(matchList);
                if (cids == null || !"".equals(cids)) {
                    // empty if block
                }
            }
            this.txManager.commit(status);
            return "success";
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            return "\u5339\u914d\u5931\u8d25\uff01";
        }
    }

    @Transactional
    public void removeMacthWorkList(Long workListId) {
        if (workListId == null) {
            return;
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            this.outpackCompanyMapper.deleteMatchPersonList(workListId);
            this.outpackCompanyMapper.deletePhyCheckMatch(workListId);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            log.error("error", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String applyMatchPersonActualCompany(List<PhcPhysicalStaffCheckInfoVO> voList) {
        List<PhcPhysicalCheckOutpackCompanyMatch> selectMatchList = this.outpackCompanyMapper.selectMatchInfo(voList);
        if (selectMatchList != null && !selectMatchList.isEmpty()) {
            this.doDeleteOriginalMatch(selectMatchList);
        }
        PhcPhysicalCheckOutpackCompanyMatchWorkList dbWorkList = null;
        if (voList.get(0).getWorkListId() != null) {
            dbWorkList = this.outpackCompanyMapper.queryPhysicalWorkListByPk(voList.get(0).getWorkListId());
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            String cids = null;
            if (voList != null && !voList.isEmpty()) {
                Long relWorkListId;
                List<Long> idList = voList.stream().map(PhcPhysicalStaffCheckInfoVO::getId).collect(Collectors.toList());
                List<PhcPhysicalStaffCheckInfo> staffResult = this.outpackCompanyMapper.selectPhcPhysicalStaffCheckInfo(idList);
                ArrayList<PhcPhysicalCheckOutpackCompanyMatch> matchList = new ArrayList<PhcPhysicalCheckOutpackCompanyMatch>();
                String outpackRegisterAddress = null;
                for (PhcPhysicalStaffCheckInfo staff : staffResult) {
                    PhcPhysicalStaffCheckInfoVO paramInfo = voList.stream().filter(v -> staff.getId().equals(v.getId())).findFirst().orElse(null);
                    PhcPhysicalCheckOutpackCompanyMatch match = new PhcPhysicalCheckOutpackCompanyMatch();
                    match.setId(Long.valueOf(this.idworker.nextId()));
                    match.setStaffCheckId(staff.getId());
                    match.setStaffName(staff.getName());
                    match.setIdCard(staff.getIdcardCode());
                    Byte matchingType = paramInfo.getMatchingType() == null || paramInfo.getMatchingType() == 0 ? (byte)0 : paramInfo.getMatchingType();
                    match.setMatchingType(matchingType);
                    match.setCheckTime(staff.getCheckTime());
                    String checkType = staff.getBodyCheckType().trim();
                    boolean isBlank = "".equals(checkType);
                    match.setBodyCheckType(isBlank ? null : Integer.valueOf(checkType));
                    match.setConclusion(staff.getConclusion());
                    match.setSourceId(staff.getSourceId());
                    match.setOrgCode(staff.getOrgCode());
                    if (staff.getCid() == null) {
                        List<Company> outpacks = this.outpackCompanyMapper.selectCompanyInfoByUcc(staff.getCreditCode());
                        if (outpacks == null || outpacks.isEmpty()) return "\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u4e0d\u5b58\u5728\uff01";
                        Company outpack = outpacks.get(0);
                        outpackRegisterAddress = outpack.getRegisterAddress();
                        match.setOutpackCid(outpack.getId());
                        match.setOutpackUcc(outpack.getUnifiedSocialCc());
                    } else {
                        match.setOutpackCid(staff.getCid());
                        match.setOutpackUcc(staff.getCreditCode());
                    }
                    String actualUcc = paramInfo.getActualUcc();
                    if (actualUcc != null && !"".equals(actualUcc.trim())) {
                        Company company = this.outpackCompanyMapper.selectCompanyInfoByUcc(actualUcc).get(0);
                        match.setCompanyCid(company.getId());
                        match.setCompanyUcc(company.getUnifiedSocialCc());
                    } else if (staff.getActualEmployerId() == null) {
                        List<Company> companies = this.outpackCompanyMapper.selectCompanyInfoByUcc(staff.getCreditCodeEmployer());
                        cids = companies.stream().map(c -> c.getId().toString()).collect(Collectors.joining(","));
                        if (companies == null || companies.isEmpty()) return "\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u4e0d\u5b58\u5728\uff01";
                        Company company = companies.get(0);
                        match.setCompanyCid(company.getId());
                        match.setCompanyUcc(company.getUnifiedSocialCc());
                    } else {
                        match.setCompanyCid(staff.getActualEmployerId());
                        cids = String.valueOf(staff.getActualEmployerId());
                        match.setCompanyUcc(staff.getCreditCodeEmployer());
                    }
                    matchList.add(match);
                }
                if (dbWorkList != null) {
                    relWorkListId = dbWorkList.getId();
                } else {
                    PhcPhysicalCheckOutpackCompanyMatch m = (PhcPhysicalCheckOutpackCompanyMatch)matchList.get(0);
                    PhcPhysicalCheckOutpackCompanyMatchWorkList workList = new PhcPhysicalCheckOutpackCompanyMatchWorkList();
                    workList.setId(Long.valueOf(this.idworker.nextId()));
                    workList.setMatchTime(null);
                    workList.setOutpackCid(m.getOutpackCid());
                    workList.setOutpackUcc(m.getOutpackUcc());
                    workList.setOutpackName(m.getOutpackName());
                    workList.setOutpackAddress(outpackRegisterAddress);
                    workList.setMatchState(Byte.valueOf((byte)0));
                    Date date = new Date();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    workList.setCreateDate(sdf.format(date));
                    workList.setCreateBy(null);
                    workList.setUpdateDate(sdf.format(date));
                    workList.setUpdateBy(null);
                    workList.setIsValid(String.valueOf(1));
                    this.outpackCompanyMapper.applyMacthWorkList(workList);
                    relWorkListId = workList.getId();
                }
                matchList.forEach(v -> v.setMatchWorkListId(relWorkListId));
                this.outpackCompanyMapper.macthDataList(matchList);
                if (cids == null || !"".equals(cids)) {
                    // empty if block
                }
            }
            this.txManager.commit(status);
            return "success";
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            return "\u5339\u914d\u5931\u8d25\uff01";
        }
    }

    public PhcPhysicalCheckOutpackCompanyMatchWorkList getPhysicalWorkListByPk(Long workListId) {
        return this.outpackCompanyMapper.queryPhysicalWorkListByPk(workListId);
    }

    public Long addNewWorkList(Long cid) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        PhcPhysicalCheckOutpackCompanyMatchWorkList workList = new PhcPhysicalCheckOutpackCompanyMatchWorkList();
        try {
            workList.setId(Long.valueOf(this.idworker.nextId()));
            workList.setMatchTime(null);
            workList.setOutpackCid(cid);
            Company company = this.outpackCompanyMapper.selectCompanyInfoByCid(cid);
            if (company != null) {
                workList.setOutpackUcc(company.getUnifiedSocialCc());
                workList.setOutpackName(company.getName());
                workList.setOutpackAddress(company.getRegisterAddress());
                workList.setAreaId(company.getAreaId());
            }
            workList.setMatchState(Byte.valueOf((byte)0));
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            workList.setCreateDate(sdf.format(date));
            workList.setCreateBy(null);
            workList.setUpdateDate(sdf.format(date));
            workList.setUpdateBy(null);
            workList.setIsValid(String.valueOf(1));
            this.outpackCompanyMapper.applyMacthWorkList(workList);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            log.error("error", (Throwable)e);
        }
        return workList.getId();
    }

    private void doDeleteOriginalMatch(List<PhcPhysicalCheckOutpackCompanyMatch> selectMatchList) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            this.outpackCompanyMapper.doDeleteOriginalMatch(selectMatchList);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            log.error("error", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String matchPersonActualCompanyNotAudit(List<PhcPhysicalStaffCheckInfoVO> voList) {
        List<PhcPhysicalCheckOutpackCompanyMatch> selectMatchList = this.outpackCompanyMapper.selectMatchInfo(voList);
        if (selectMatchList != null && !selectMatchList.isEmpty()) {
            return "\u76f8\u5173\u4eba\u5458\u5df2\u5339\u914d\uff01";
        }
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            String cids = null;
            if (voList != null && !voList.isEmpty()) {
                List<Long> idList = voList.stream().map(PhcPhysicalStaffCheckInfoVO::getId).collect(Collectors.toList());
                List<PhcPhysicalStaffCheckInfo> staffResult = this.outpackCompanyMapper.selectPhcPhysicalStaffCheckInfo(idList);
                ArrayList<PhcPhysicalCheckOutpackCompanyMatch> matchList = new ArrayList<PhcPhysicalCheckOutpackCompanyMatch>();
                for (PhcPhysicalStaffCheckInfo staff : staffResult) {
                    PhcPhysicalStaffCheckInfoVO paramInfo = voList.stream().filter(v -> staff.getId().equals(v.getId())).findFirst().orElse(null);
                    PhcPhysicalCheckOutpackCompanyMatch match = new PhcPhysicalCheckOutpackCompanyMatch();
                    match.setId(Long.valueOf(this.idworker.nextId()));
                    match.setStaffCheckId(staff.getId());
                    match.setStaffName(staff.getName());
                    match.setIdCard(staff.getIdcardCode());
                    match.setMatchingType(Byte.valueOf((byte)(paramInfo.getMatchingType() != null ? 1 : 0)));
                    match.setCheckTime(staff.getCheckTime());
                    String checkType = staff.getBodyCheckType().trim();
                    boolean isBlank = "".equals(checkType);
                    match.setBodyCheckType(isBlank ? null : Integer.valueOf(checkType));
                    match.setConclusion(staff.getConclusion());
                    match.setSourceId(staff.getSourceId());
                    match.setOrgCode(staff.getOrgCode());
                    if (staff.getCid() == null) {
                        List<Company> outpacks = this.outpackCompanyMapper.selectCompanyInfoByUcc(staff.getCreditCode());
                        if (outpacks == null || outpacks.isEmpty()) return "\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u4e0d\u5b58\u5728\uff01";
                        Company outpack = outpacks.get(0);
                        match.setOutpackCid(outpack.getId());
                        match.setOutpackUcc(outpack.getUnifiedSocialCc());
                    } else {
                        match.setOutpackCid(staff.getCid());
                        match.setOutpackUcc(staff.getCreditCode());
                    }
                    String actualUcc = paramInfo.getActualUcc();
                    if (actualUcc != null && !"".equals(actualUcc.trim())) {
                        Company company = this.outpackCompanyMapper.selectCompanyInfoByUcc(actualUcc).get(0);
                        match.setCompanyCid(company.getId());
                        match.setCompanyUcc(company.getUnifiedSocialCc());
                    } else if (staff.getActualEmployerId() == null) {
                        List<Company> companies = this.outpackCompanyMapper.selectCompanyInfoByUcc(staff.getCreditCodeEmployer());
                        cids = companies.stream().map(c -> c.getId().toString()).collect(Collectors.joining(","));
                        if (companies == null || companies.isEmpty()) return "\u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u4e0d\u5b58\u5728\uff01";
                        Company company = companies.get(0);
                        match.setCompanyCid(company.getId());
                        match.setCompanyUcc(company.getUnifiedSocialCc());
                    } else {
                        match.setCompanyCid(staff.getActualEmployerId());
                        cids = String.valueOf(staff.getActualEmployerId());
                        match.setCompanyUcc(staff.getCreditCodeEmployer());
                    }
                    matchList.add(match);
                }
                this.outpackCompanyMapper.macthDataList(matchList);
                if (cids == null || !"".equals(cids)) {
                    // empty if block
                }
            }
            this.txManager.commit(status);
            return "success";
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            return "\u5339\u914d\u5931\u8d25\uff01";
        }
    }

    public String cancelUnMatch(List<PhcPhysicalStaffCheckInfoVO> voList) {
        List<PhcPhysicalCheckOutpackCompanyMatch> dbMatchList = this.outpackCompanyMapper.selectMatchInfo(voList);
        for (PhcPhysicalCheckOutpackCompanyMatch dbMatch : dbMatchList) {
            boolean unMatch = Objects.equals(dbMatch.getMatchingType(), (byte)0);
            if (unMatch) continue;
            throw new ServiceException("\u6570\u636e\u4e0d\u662f\u65e0\u9700\u5339\u914d\u7c7b\u578b\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        if (voList != null && !voList.isEmpty()) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                voList.forEach(v -> v.setMatchingType(Byte.valueOf((byte)-1)));
                ((OutpackCompanyMapper)this.dao).cancelUnMatchOneByPk(voList);
                this.txManager.commit(status);
            }
            catch (Exception e) {
                this.txManager.rollback(status);
                e.printStackTrace();
                log.error("error", (Throwable)e);
            }
        }
        return "\u64cd\u4f5c\u6210\u529f";
    }

    public String matchTypeChange(String idStr, Byte matchingType) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        try {
            String[] split = idStr.split(",");
            List<String> idList = Arrays.asList(split);
            List<Long> ids = idList.stream().map(Long::parseLong).collect(Collectors.toList());
            ((OutpackCompanyMapper)this.dao).matchTypeChange(ids, matchingType);
            this.txManager.commit(status);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            e.printStackTrace();
            log.error("error", (Throwable)e);
        }
        return "\u53d8\u66f4\u6210\u529f";
    }

    @Transactional
    public void completeMatchConfirmation(Long workListId) {
        this.outpackCompanyMapper.updateMatchInfo(workListId);
        this.outpackCompanyMapper.updateMatchWorkListInfo(workListId);
    }

    public String confirmMatchingTypeInTheRange(Long cid, String ucc, String companyName, Integer year, Integer month) {
        boolean noValid;
        boolean bl = noValid = ucc == null || "".equals(ucc.trim()) || year == null || month == null;
        if (!noValid) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
            try {
                this.outpackCompanyMapper.confirmMatchingTypeInTheRange(ucc, year, month);
                this.txManager.commit(status);
                log.info("end");
            }
            catch (Exception e) {
                this.txManager.rollback(status);
                e.printStackTrace();
                log.error("error", (Throwable)e);
            }
        }
        return "\u5339\u914d\u5b8c\u6210";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhcPhysicalStaffCheckVO> getCompanyInfoFromExcel(String ossfile, Long userAreaId, Byte level) {
        List<PhcPhysicalStaffCheckVO> list = null;
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)ExcelUtil.getInstance().getOssInputStream(ossfile));
        }
        catch (Exception e) {
        }
        finally {
            if (Objects.nonNull(wb)) {
                try {
                    Sheet sheet = wb.getSheetAt(0);
                    list = this.getCompanyInfoFromSheetOcOrComStateChange(sheet, userAreaId, level);
                    wb.close();
                }
                catch (IOException e) {
                    log.error("\u4fe1\u606f\u53d8\u66f4\u4f01\u4e1a\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return list;
    }

    private List<PhcPhysicalStaffCheckVO> getCompanyInfoFromSheetOcOrComStateChange(Sheet sheet, Long userAreaId, Byte level) {
        ArrayList<PhcPhysicalStaffCheckVO> list = new ArrayList<PhcPhysicalStaffCheckVO>();
        int rowIndex = 0;
        int cellIndex = 8;
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (++rowIndex == 1) continue;
            PhcPhysicalStaffCheckVO vo = new PhcPhysicalStaffCheckVO();
            vo.setHaveError(Boolean.valueOf(false));
            vo.setErrorReason("");
            Boolean noContent = false;
            block11: for (int i = 0; i <= cellIndex; ++i) {
                Cell cell = row.getCell(i);
                if (cell != null) {
                    cell.setCellType(CellType.STRING);
                }
                switch (i) {
                    case 0: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            noContent = true;
                            String serrial = cell.getStringCellValue().trim();
                            if (StringUtils.isLong((String)serrial)) {
                                vo.setSerial(Long.valueOf(Long.parseLong(serrial)));
                                continue block11;
                            }
                            vo.setHaveError(Boolean.valueOf(false));
                            vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57;<br/>");
                            continue block11;
                        }
                        vo.setHaveError(Boolean.valueOf(true));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e8f\u53f7\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block11;
                    }
                    case 1: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String bodyCheckName = cell.getStringCellValue().trim();
                            vo.setBodyCheckName(bodyCheckName);
                            noContent = true;
                            continue block11;
                        }
                        vo.setHaveError(Boolean.valueOf(true));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u4f53\u68c0\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block11;
                    }
                    case 2: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String staffName = cell.getStringCellValue().trim();
                            vo.setName(staffName);
                            noContent = true;
                            continue block11;
                        }
                        vo.setHaveError(Boolean.valueOf(true));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u59d3\u540d\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block11;
                    }
                    case 3: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String sex = cell.getStringCellValue().trim();
                            vo.setSexCode(sex);
                            noContent = true;
                            continue block11;
                        }
                        vo.setHaveError(Boolean.valueOf(true));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u6027\u522b\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block11;
                    }
                    case 4: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String age = cell.getStringCellValue().trim();
                            vo.setAge(age);
                            noContent = true;
                            continue block11;
                        }
                        vo.setHaveError(Boolean.valueOf(true));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5e74\u9f84\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block11;
                    }
                    case 5: {
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            String checkTime = cell.getStringCellValue().trim();
                            vo.setCheckTime(checkTime);
                            noContent = true;
                            continue block11;
                        }
                        vo.setHaveError(Boolean.valueOf(true));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u4f53\u68c0\u65f6\u95f4\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block11;
                    }
                    case 6: {
                        String ucc;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            ucc = cell.getStringCellValue().trim();
                            vo.setCreditCodeEmployer(ucc);
                            noContent = true;
                            continue block11;
                        }
                        vo.setHaveError(Boolean.valueOf(true));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801 \u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                        continue block11;
                    }
                    case 7: {
                        String ucc;
                        if (cell != null && StringUtils.isNotEmpty((String)cell.getStringCellValue())) {
                            ucc = cell.getStringCellValue().trim();
                            vo.setEmployerNameEmployer(ucc);
                            noContent = true;
                            continue block11;
                        }
                        vo.setHaveError(Boolean.valueOf(true));
                        vo.setErrorReason(vo.getErrorReason() + "\u884c\u53f7\uff1a" + rowIndex + ", \u5217\u53f7\uff1a" + this.getExcelColName(i + 1) + ", \u5b9e\u9645\u7528\u5de5\u5355\u4f4d\u540d\u79f0 \u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a;<br/>");
                    }
                }
            }
            if (!noContent.booleanValue()) break;
            list.add(vo);
        }
        return list;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private Boolean isInJurisdiction(Long userAreaId, Byte level, Long areaId, Long supervisionAreaId) {
        if (level != null && userAreaId != null && areaId != null) {
            String userAreaStr = userAreaId.toString();
            String areaIdStr = areaId.toString();
            if (level.intValue() == 1) {
                return supervisionAreaId == null ? areaIdStr.startsWith(userAreaStr.substring(0, 2)) : supervisionAreaId.toString().startsWith(userAreaStr.substring(0, 2));
            }
            if (level.intValue() == 2) {
                return supervisionAreaId == null ? areaIdStr.startsWith(userAreaStr.substring(0, 4)) : supervisionAreaId.toString().startsWith(userAreaStr.substring(0, 4));
            }
            if (level.intValue() == 3) {
                return supervisionAreaId == null ? areaIdStr.startsWith(userAreaStr.substring(0, 6)) : supervisionAreaId.toString().startsWith(userAreaStr.substring(0, 6));
            }
            return false;
        }
        return false;
    }

    @Transactional
    public Integer addCompanyChangeInfoFromExcel(List<PhcPhysicalStaffCheckVO> list, Long updateBy, Long workListId) {
        ArrayList<PhcPhysicalStaffCheckInfoVO> callList = new ArrayList<PhcPhysicalStaffCheckInfoVO>();
        for (PhcPhysicalStaffCheckVO vo : list) {
            PhcPhysicalStaffCheckInfoVO v = new PhcPhysicalStaffCheckInfoVO();
            v.setId(vo.getSerial());
            v.setName(vo.getName());
            v.setActualUcc(vo.getCreditCodeEmployer());
            v.setMatchingType(Byte.valueOf((byte)1));
            v.setWorkListId(workListId);
            callList.add(v);
        }
        this.matchPersonActualCompany(callList);
        return callList.size();
    }

    public PageInfo<PhyDataMatchVo> getPhyDataMatchingList(Long areaId, JqGridParam param, String keyword) {
        PageMethod.startPage((int)param.getPage(), (int)param.getRows());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String beginTime = null;
        String endTime = null;
        if (param.getBeginTime() != null) {
            beginTime = sdf.format(param.getBeginTime());
        }
        if (param.getEndTime() != null) {
            endTime = sdf.format(param.getEndTime());
        }
        List<PhyDataMatchVo> phyDataMatchingList = this.outpackCompanyMapper.getPhyDataMatchingList(areaId, param, beginTime, endTime);
        PageInfo info = new PageInfo(phyDataMatchingList);
        return info;
    }

    public Integer getNeedAuditMatchNum(Long workListId) {
        return this.outpackCompanyMapper.getNeedAuditMatchNum(workListId);
    }

    @Transactional
    public void updateExistOutpackCompany() {
        ((OutpackCompanyMapper)this.dao).deleteExistOutpackCompany();
        ((OutpackCompanyMapper)this.dao).insertExistOutpackCompany();
    }
}

