/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.org.imp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelRowContent;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckThirdOrg;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckThirdOrgService;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysMenuV3Service;
import cn.smarthse.modules.health.thirdOrganization.cache.OrgImportTempCache;
import cn.smarthse.modules.health.thirdOrganization.component.AppraiseParser;
import cn.smarthse.modules.health.thirdOrganization.component.CheckEvaluateParser;
import cn.smarthse.modules.health.thirdOrganization.component.DiagnoseParser;
import cn.smarthse.modules.health.thirdOrganization.component.OrgImportParser;
import cn.smarthse.modules.health.thirdOrganization.component.PhysicalExamParser;
import cn.smarthse.modules.health.thirdOrganization.component.TrainParser;
import cn.smarthse.modules.health.thirdOrganization.dao.org.ThirdOrganizationMapper;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfo;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfoDic;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgLinkWay;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgLogout;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.entity.sys.SysUser;
import cn.smarthse.modules.health.thirdOrganization.enums.org.ThirdOrgSourceEnum;
import cn.smarthse.modules.health.thirdOrganization.enums.org.ThirdOrgTypeEnum;
import cn.smarthse.modules.health.thirdOrganization.model.org.AddResult;
import cn.smarthse.modules.health.thirdOrganization.model.org.HideOrgParam;
import cn.smarthse.modules.health.thirdOrganization.model.org.ImportParam;
import cn.smarthse.modules.health.thirdOrganization.model.org.ImportResult;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgDeleteParam;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgInfoDicTypeEnum;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgQueryParamModel;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgUpdateDto;
import cn.smarthse.modules.health.thirdOrganization.model.org.ParseError;
import cn.smarthse.modules.health.thirdOrganization.model.org.SuperviseOrgListVo;
import cn.smarthse.modules.health.thirdOrganization.model.sys.SysUserRegisterParam;
import cn.smarthse.modules.health.thirdOrganization.model.v3.org.ThirdOrgUserV3AddParam;
import cn.smarthse.modules.health.thirdOrganization.model.v3.org.ThirdOrgUserV3EditParam;
import cn.smarthse.modules.health.thirdOrganization.model.v3.org.ThirdOrgUserV3ListParam;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgInfoService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgLinkWayService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgLogoutService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgQualificationService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.thirdOrganization.service.sys.ISysUserService;
import cn.smarthse.modules.health.thirdOrganization.vo.v3.org.ThirdOrgUserV3ListVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.snowflake.IdWorker;
import cn.smarthse.util.common.JsonUtils;
import cn.smarthse.util.common.excel.model.ExcelModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class ThirdOrganizationServiceImp
extends BaseServiceImpl<ThirdOrganizationMapper, ThirdOrganization>
implements IThirdOrganizationService {
    @DubboReference(check=false)
    private IHcCheckThirdOrgService hcCheckThirdOrgService;
    @Autowired
    private IThirdOrgInfoService orgInfoService;
    @Autowired
    private IThirdOrgQualificationService qualificationService;
    @Autowired
    private IThirdOrgLogoutService orgLogoutService;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @Autowired
    private IThirdOrgInfoService thirdOrgInfoService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private OrgImportTempCache orgImportTempCache;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private IThirdOrgLinkWayService thirdOrgLinkWayService;
    @Autowired
    private IdWorker snowFlake;
    @DubboReference
    private IOrganizationService organizationService;
    @DubboReference
    private IOrganizationUserService organizationUserService;
    @DubboReference
    private ISysMenuV3Service menuV3Service;
    private Map<String, Integer> orderNumMap = new ConcurrentHashMap<String, Integer>();
    private CheckEvaluateParser checkEvaluateParser;
    private DiagnoseParser diagnoseParser;
    private PhysicalExamParser physicalExamParser;

    @PostConstruct
    public void init() {
        this.checkEvaluateParser = new CheckEvaluateParser(this.thirdOrgInfoService, this.sysAreaProvideService);
        this.diagnoseParser = new DiagnoseParser(this.thirdOrgInfoService, this.sysAreaProvideService);
        this.physicalExamParser = new PhysicalExamParser(this.thirdOrgInfoService, this.sysAreaProvideService);
    }

    private OrgImportParser getParser(String sheetName) {
        if (sheetName.equals("\u8bca\u65ad\u673a\u6784")) {
            return new DiagnoseParser(this.thirdOrgInfoService, this.sysAreaProvideService);
        }
        if (sheetName.equals("\u4f53\u68c0\u673a\u6784")) {
            return new PhysicalExamParser(this.thirdOrgInfoService, this.sysAreaProvideService);
        }
        if (sheetName.equals("\u6280\u672f\u670d\u52a1\u673a\u6784")) {
            return new CheckEvaluateParser(this.thirdOrgInfoService, this.sysAreaProvideService);
        }
        if (sheetName.equals("\u57f9\u8bad\u673a\u6784")) {
            return new TrainParser(this.thirdOrgInfoService, this.sysAreaProvideService);
        }
        if (sheetName.equals("\u9274\u5b9a\u673a\u6784")) {
            return new AppraiseParser(this.thirdOrgInfoService, this.sysAreaProvideService);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public synchronized Integer add(ThirdOrganization thirdOrganization, List<ThirdOrgInfo> orgInfoList, Integer addType) {
        return this.addBySituation(thirdOrganization, orgInfoList, addType);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public AddResult addAndGetResult(ThirdOrganization thirdOrganization, List<ThirdOrgInfo> orgInfoList, Integer addType) {
        AddResult result = new AddResult();
        Long notRealOrgId = thirdOrganization.getId();
        thirdOrganization.setId(null);
        Integer r = this.add(thirdOrganization, orgInfoList, addType);
        if (notRealOrgId != null && notRealOrgId < 0L) {
            this.thirdOrgLinkWayService.updateOrgIdByNotRealOrgId(thirdOrganization.getId(), Long.valueOf(-notRealOrgId.longValue()));
        }
        result.setResult(r);
        result.setOrganization(thirdOrganization);
        return result;
    }

    private Integer addBySituation(ThirdOrganization thirdOrganization, List<ThirdOrgInfo> orgInfoList, Integer addType) {
        Example example = new Example(ThirdOrganization.class);
        example.createCriteria().andEqualTo("isValid", (Object)true);
        List<ThirdOrganization> all = this.getListByExample(example);
        if (addType.equals(0)) {
            Integer situationCode = this.getSituationCode(thirdOrganization, all);
            if (!situationCode.equals(0)) {
                return situationCode;
            }
            this.doAdd(thirdOrganization, orgInfoList);
            return 0;
        }
        if (addType.equals(3)) {
            ThirdOrganization situation3Old = this.getSituation3Old(thirdOrganization, all);
            String orgType = thirdOrganization.getOrgTypes();
            this.fillData(thirdOrganization, situation3Old, orgInfoList);
            thirdOrganization.setOrgTypes(thirdOrganization.getOrgTypes() + "," + orgType);
            thirdOrganization.setIsValid(Boolean.valueOf(true));
            this.update(thirdOrganization, orgInfoList);
            return 0;
        }
        if (addType.equals(4)) {
            thirdOrganization.setCreditCode(this.getCreditCodeAndOrderNum(thirdOrganization.getCreditCode(), all));
            this.doAdd(thirdOrganization, orgInfoList);
            return 0;
        }
        throw new RuntimeException("\u6dfb\u52a0\u673a\u6784\u65f6\u72b6\u6001\u9519\u8bef");
    }

    private void doAdd(ThirdOrganization thirdOrganization, List<ThirdOrgInfo> orgInfoList) {
        this.add(thirdOrganization);
        this.orgInfoService.update(orgInfoList, thirdOrganization.getId());
        this.qualificationService.initDefault(thirdOrganization.getId(), thirdOrganization.getOrgTypes());
        HcCheckThirdOrg hcCheckThirdOrg = new HcCheckThirdOrg();
        hcCheckThirdOrg.setThirdOrgId(thirdOrganization.getId());
        hcCheckThirdOrg.setThirdOrgName(thirdOrganization.getName());
        this.hcCheckThirdOrgService.addOrUpdateById(hcCheckThirdOrg);
    }

    private Integer getSituationCode(ThirdOrganization thirdOrganization, List<ThirdOrganization> all) {
        if (this.isSituation1(thirdOrganization, all)) {
            return 1;
        }
        if (this.isSituation2(thirdOrganization, all)) {
            return 2;
        }
        if (this.isSituation3(thirdOrganization, all)) {
            return 3;
        }
        if (this.isSituation4(thirdOrganization, all)) {
            return 4;
        }
        return 0;
    }

    private boolean isSituation1(ThirdOrganization thirdOrganization, List<ThirdOrganization> all) {
        for (ThirdOrganization old : all) {
            if (!old.getName().equals(thirdOrganization.getName())) continue;
            return !this.creditCodeIsEqual(old.getCreditCode(), thirdOrganization.getCreditCode());
        }
        return false;
    }

    private boolean isSituation2(ThirdOrganization thirdOrganization, List<ThirdOrganization> all) {
        for (ThirdOrganization old : all) {
            if (!old.getName().equals(thirdOrganization.getName())) continue;
            return old.getOrgTypes().contains(thirdOrganization.getOrgTypes()) && this.creditCodeIsEqual(old.getCreditCode(), thirdOrganization.getCreditCode());
        }
        return false;
    }

    private boolean isSituation3(ThirdOrganization thirdOrganization, List<ThirdOrganization> all) {
        for (ThirdOrganization old : all) {
            if (!old.getName().equals(thirdOrganization.getName())) continue;
            return !old.getOrgTypes().contains(thirdOrganization.getOrgTypes()) && this.creditCodeIsEqual(old.getCreditCode(), thirdOrganization.getCreditCode());
        }
        return false;
    }

    private ThirdOrganization getSituation3Old(ThirdOrganization thirdOrganization, List<ThirdOrganization> all) {
        for (ThirdOrganization old : all) {
            if (!old.getName().equals(thirdOrganization.getName()) || old.getOrgTypes().contains(thirdOrganization.getOrgTypes()) || !this.creditCodeIsEqual(old.getCreditCode(), thirdOrganization.getCreditCode())) continue;
            return old;
        }
        return null;
    }

    private boolean isSituation4(ThirdOrganization thirdOrganization, List<ThirdOrganization> all) {
        for (ThirdOrganization old : all) {
            if (!this.creditCodeIsEqual(old.getCreditCode(), thirdOrganization.getCreditCode()) || !this.haveCreditCode(thirdOrganization.getOrgTypes())) continue;
            return !old.getName().equals(thirdOrganization.getName());
        }
        return false;
    }

    public void addMany(List<OrgUpdateDto> list) {
        this.threadPoolExecutor.execute(() -> {
            this.logger.info("\u5f02\u6b65\u6279\u91cf\u6dfb\u52a0\u673a\u6784start,\u673a\u6784\u6570\u91cf:" + list.size());
            this.doAddMany(list, false);
            this.logger.info("\u5f02\u6b65\u6279\u91cf\u6dfb\u52a0\u673a\u6784end");
        });
    }

    private void doAddMany(List<OrgUpdateDto> list, Boolean createUser) {
        for (OrgUpdateDto orgUpdateDto : list) {
            ThirdOrganization thirdOrganization = orgUpdateDto.getThirdOrganization();
            ThirdOrganization to = this.add(orgUpdateDto.getThirdOrganization());
            if (orgUpdateDto.getCanService() != null) {
                this.logout(to.getId(), orgUpdateDto.getAreaId(), (Boolean)(orgUpdateDto.getCanService() == false ? 1 : 0), (Long)0L);
            }
            if (orgUpdateDto.getLinkWayAreaId() != null) {
                ThirdOrgLinkWay tolw = new ThirdOrgLinkWay();
                tolw.setAreaId(orgUpdateDto.getLinkWayAreaId());
                tolw.setAreaName(orgUpdateDto.getLinkWayAreaName());
                tolw.setThirdOrgId(to.getId());
                tolw.setLinkMan(to.getContactName());
                tolw.setLinkTel(to.getContactPhone());
                this.thirdOrgLinkWayService.add((Object)tolw, to.getCreateBy(), null);
            }
            List otherDicInfo = this.orgInfoService.getOtherDicInfo(orgUpdateDto.getThirdOrganization().getId(), orgUpdateDto.getThirdOrganization().getOrgType());
            orgUpdateDto.getThirdOrgInfoList().addAll(otherDicInfo);
            this.orgInfoService.update(orgUpdateDto.getThirdOrgInfoList(), thirdOrganization.getId());
            this.qualificationService.initDefault(thirdOrganization.getId(), thirdOrganization.getOrgTypes());
            HcCheckThirdOrg hcCheckThirdOrg = new HcCheckThirdOrg();
            hcCheckThirdOrg.setThirdOrgId(thirdOrganization.getId());
            hcCheckThirdOrg.setThirdOrgName(thirdOrganization.getName());
            this.hcCheckThirdOrgService.addOrUpdateById(hcCheckThirdOrg);
        }
        if (createUser != null && createUser.booleanValue()) {
            LinkedList<SysUser> users = new LinkedList<SysUser>();
            for (OrgUpdateDto dto : list) {
                users.add(this.createUser(dto.getThirdOrganization()));
            }
            this.sysUserService.addMulti(users);
        }
    }

    private void doUpdateMany(List<OrgUpdateDto> list, Boolean createUser) {
        for (OrgUpdateDto orgUpdateDto : list) {
            ThirdOrganization thirdOrganization = orgUpdateDto.getThirdOrganization();
            ThirdOrganization to = this.add(orgUpdateDto.getThirdOrganization());
            if (orgUpdateDto.getLinkWayAreaId() != null) {
                ThirdOrgLinkWay tolw = new ThirdOrgLinkWay();
                tolw.setAreaId(orgUpdateDto.getLinkWayAreaId());
                tolw.setAreaName(orgUpdateDto.getLinkWayAreaName());
                tolw.setThirdOrgId(to.getId());
                tolw.setLinkMan(to.getContactName());
                tolw.setLinkTel(to.getContactPhone());
                this.thirdOrgLinkWayService.add((Object)tolw, to.getCreateBy(), null);
            }
            this.update(thirdOrganization, orgUpdateDto.getThirdOrgInfoList());
            if (orgUpdateDto.getCanService() == null) continue;
            this.logout(to.getId(), orgUpdateDto.getAreaId(), (Boolean)(orgUpdateDto.getCanService() == false ? 1 : 0), (Long)0L);
        }
        if (createUser != null && createUser.booleanValue()) {
            JqGridParam param = new JqGridParam();
            param.setRows(1);
            param.setPage(1);
            LinkedList<SysUser> users = new LinkedList<SysUser>();
            for (OrgUpdateDto dto : list) {
                PageInfo pageInfo = this.sysUserService.getUserListByCid(param, dto.getThirdOrganization().getId(), null);
                if (pageInfo.getTotal() > 0L) continue;
                users.add(this.createUser(dto.getThirdOrganization()));
            }
            this.sysUserService.addMulti(users);
        }
    }

    private void copyProperties(ThirdOrganization newOrg, ThirdOrganization old) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] pds;
        BeanInfo beanInfo = Introspector.getBeanInfo(ThirdOrganization.class, Object.class);
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            Method readMethod = pd.getReadMethod();
            Object result1 = readMethod.invoke((Object)newOrg, new Object[0]);
            Object result2 = readMethod.invoke((Object)old, new Object[0]);
            if (result1 == null || result2 != null) continue;
            Method writeMethod = pd.getWriteMethod();
            writeMethod.invoke((Object)old, result1);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public void update(ThirdOrganization thirdOrganization, List<ThirdOrgInfo> orgInfoList) {
        thirdOrganization.setUpdateDate(new Date());
        this.updateByPrimaryKey(thirdOrganization, thirdOrganization.getUpdateBy());
        this.orgInfoService.update(orgInfoList, thirdOrganization.getId());
        this.qualificationService.initDefault(thirdOrganization.getId(), thirdOrganization.getOrgTypes());
        HcCheckThirdOrg hcCheckThirdOrg = new HcCheckThirdOrg();
        hcCheckThirdOrg.setThirdOrgId(thirdOrganization.getId());
        hcCheckThirdOrg.setThirdOrgName(thirdOrganization.getName());
        this.hcCheckThirdOrgService.addOrUpdateById(hcCheckThirdOrg);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void updateByType(ThirdOrganization thirdOrganization, Integer type, List<ThirdOrgInfo> orgInfoList) {
        Long provinceId = thirdOrganization.getProvinceId();
        Long cityId = thirdOrganization.getCityId();
        Long areaId = thirdOrganization.getAreaId();
        String provinceName = null;
        String cityName = null;
        String areaName = null;
        if (provinceId != null) {
            provinceName = ((ThirdOrganizationMapper)this.dao).queryProvinceName(provinceId);
        }
        if (cityId != null) {
            cityName = ((ThirdOrganizationMapper)this.dao).queryCityName(cityId);
        }
        if (areaId != null) {
            areaName = ((ThirdOrganizationMapper)this.dao).queryAreaName(areaId);
        }
        thirdOrganization.setProvinceName(provinceName);
        thirdOrganization.setCityName(cityName);
        thirdOrganization.setAreaName(areaName);
        if (type != null && type > 0) {
            List otherDicInfo = this.orgInfoService.getOtherDicInfo(thirdOrganization.getId(), type);
            orgInfoList.addAll(otherDicInfo);
        }
        this.update(thirdOrganization, orgInfoList);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void updateWqyyOrgNameInfoByUcc(ThirdOrganization org) {
        if (org == null || org.getCreditCode() == null) {
            return;
        }
        ((ThirdOrganizationMapper)this.dao).updateWqyyOrgNameInfoByUcc(org);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void delete(Long orgId, Long userId) {
        ThirdOrganization thirdOrganization = new ThirdOrganization();
        thirdOrganization.setId(orgId);
        this.setUpdateInfo(thirdOrganization, userId);
        thirdOrganization.setIsValid(Boolean.valueOf(false));
        thirdOrganization.setDeleteTime(new Date());
        ((ThirdOrganizationMapper)this.dao).updateByPrimaryKeySelective(thirdOrganization);
        this.delFromMemoryCache(orgId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteMulti(List<Long> orgIds, Long userId) {
        ((ThirdOrganizationMapper)this.dao).deleteMulti(orgIds, userId);
        orgIds.forEach(id -> this.delFromMemoryCache((Long)id));
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteMulti(OrgDeleteParam orgDeleteParam) {
        ((ThirdOrganizationMapper)this.dao).deleteMultiByParam(orgDeleteParam);
        orgDeleteParam.getOrgIds().forEach(id -> this.delFromMemoryCache((Long)id));
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void recover(Long orgId, Long userId) {
        ThirdOrganization thirdOrganization = new ThirdOrganization();
        thirdOrganization.setId(orgId);
        this.setUpdateInfo(thirdOrganization, userId);
        thirdOrganization.setIsValid(Boolean.valueOf(true));
        thirdOrganization.setBusinessStatus(Byte.valueOf((byte)1));
        ((ThirdOrganizationMapper)this.dao).updateByPrimaryKeySelective(thirdOrganization);
    }

    public PageInfo<SuperviseOrgListVo> queryPage(OrgQueryParamModel paramModel) {
        PageHelper.startPage((int)paramModel.getPage(), (int)paramModel.getRows());
        if (paramModel.getOrgIds() != null && paramModel.getOrgIds().isEmpty()) {
            return new PageInfo(new ArrayList());
        }
        String orgTypes = paramModel.getOrgTypes();
        if (StrUtil.isNotBlank((CharSequence)orgTypes)) {
            paramModel.setOrgTypeList(Arrays.asList(orgTypes.split(",")));
        }
        if (paramModel.getLoginUserAreaId() != null && paramModel.getLoginUserAreaId() != 0L) {
            List<Long> orgIdByAreaId;
            AreaModel areamode;
            OrgQueryParamModel org = new OrgQueryParamModel();
            BeanUtils.copyProperties((Object)paramModel, (Object)org);
            if (org.getOrgAreaId() != null && (areamode = this.sysAreaProvideService.getAreaById(org.getOrgAreaId())) != null) {
                org.setOrgAreaId(areamode.getProvinceId());
                org.setOrgAreaLevel(Byte.valueOf((byte)1));
            }
            if (CollectionUtils.isEmpty(orgIdByAreaId = ((ThirdOrganizationMapper)this.dao).getOrgIdByAreaId(org))) {
                return new PageInfo(new ArrayList());
            }
            ArrayList<Long> orgIds = paramModel.getOrgIds();
            if (orgIds == null) {
                orgIds = new ArrayList<Long>();
            }
            orgIds.addAll(orgIdByAreaId);
            paramModel.setOrgIds(orgIds);
        }
        List<SuperviseOrgListVo> list = ((ThirdOrganizationMapper)this.dao).queryList(paramModel);
        return new PageInfo(list);
    }

    public PageInfo<SuperviseOrgListVo> getOrgListData(OrgQueryParamModel param) {
        String orgTypes = param.getOrgTypes();
        if (StrUtil.isNotBlank((CharSequence)orgTypes)) {
            param.setOrgTypeList(Arrays.asList(orgTypes.split(",")));
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo((List)((Page)((ThirdOrganizationMapper)this.dao).getOrgListData(param)));
    }

    public List<SuperviseOrgListVo> queryList(OrgQueryParamModel paramModel) {
        String orgTypes = paramModel.getOrgTypes();
        if (orgTypes != null && orgTypes.length() > 0) {
            paramModel.setOrgTypeList(Arrays.asList(orgTypes.split(",")));
        }
        List<SuperviseOrgListVo> list = null;
        list = paramModel.getCid() != null && !paramModel.getCid().equals(0L) ? ((ThirdOrganizationMapper)this.dao).queryBlocList(paramModel) : ((ThirdOrganizationMapper)this.dao).queryList(paramModel);
        return list;
    }

    public PageInfo<SuperviseOrgListVo> queryPageAndServiceRange(OrgQueryParamModel paramModel) {
        PageInfo<SuperviseOrgListVo> pageInfo = this.queryPage(paramModel);
        for (SuperviseOrgListVo org : pageInfo.getList()) {
            org.setDetectionOrgServiceRange(this.getDetectionServiceRange(org.getId()));
        }
        return pageInfo;
    }

    public SuperviseOrgListVo getOrgDetailInfo(Long id) {
        List examTypes;
        StringBuilder sb;
        ThirdOrganization org = (ThirdOrganization)this.getById(id);
        SuperviseOrgListVo vo = new SuperviseOrgListVo();
        BeanUtils.copyProperties((Object)org, (Object)vo);
        if (vo.getAreaId() != null) {
            AreaModel area = this.sysAreaProvideService.getAreaById(vo.getAreaId());
            sb = new StringBuilder();
            if (area.getProvinceName() != null) {
                sb.append(area.getProvinceName());
            }
            if (area.getCityName() != null) {
                sb.append(area.getCityName());
            }
            if (area.getAreaName() != null) {
                sb.append(area.getAreaName());
            }
            if (area.getStreetName() != null) {
                sb.append(area.getStreetName());
            }
            if (vo.getAddress() != null) {
                sb.append(vo.getAddress());
            }
            vo.setAddressDetail(sb.toString());
        }
        if (org.getOrgTypes().contains("2") && !(examTypes = this.orgInfoService.getExamTypes(id)).isEmpty()) {
            sb = new StringBuilder();
            examTypes.forEach(type -> {
                sb.append(type.getName());
                sb.append(",");
            });
            vo.setExamTypes(sb.substring(0, sb.length() - 1));
        }
        if (org.getOrgTypes().contains("1")) {
            vo.setDetectionOrgServiceRange(this.orgInfoService.getDetectionServiceRange(id));
            vo.setDetectionOrgServeRange(this.orgInfoService.getDetectionServeRange(id));
        }
        return vo;
    }

    public List<ThirdOrgInfoDic> getDetectionServiceRange(Long cid) {
        return this.orgInfoService.getDetectionServiceRange(cid);
    }

    @Transactional(readOnly=false)
    public void logout(Long orgId, Long areaId, Boolean logout, Long loginUerId) {
        if (logout == null) {
            return;
        }
        this.orgLogoutService.logout(orgId, areaId, logout, loginUerId);
    }

    @Transactional(readOnly=false)
    public void logout(List<Long> orgIds, Long areaId, Boolean logout, Long loginUerId) {
        if (orgIds == null || orgIds.isEmpty()) {
            return;
        }
        for (Long orgId : orgIds) {
            this.orgLogoutService.logout(orgId, areaId, logout, loginUerId);
        }
    }

    @Transactional(readOnly=false)
    public void blocLogout(Long orgId, Long cid, Boolean logout, Long loginUerId) {
        this.orgLogoutService.blocLogout(orgId, cid, logout, loginUerId);
    }

    public List<ThirdOrgLogout> getAllLogout(Long areaId) {
        return this.orgLogoutService.getAllLogout(areaId);
    }

    public List<ThirdOrgLogout> getBlocAllLogout(Long cid) {
        return this.orgLogoutService.getBlocAllLogout(cid);
    }

    public List<ThirdOrganization> getAllByIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<ThirdOrganization>();
        }
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andIn("id", ids);
        return ((ThirdOrganizationMapper)this.dao).selectByExample(example);
    }

    private ThirdOrganization getByName(String name, Integer orgType, Long cid) {
        List list;
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("name", (Object)name).andLike("orgTypes", "%" + orgType + "%").andEqualTo("isValid", (Object)true);
        if (cid != null && !cid.equals(0L)) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        return (list = ((ThirdOrganizationMapper)this.dao).selectByExample(example)) != null && list.size() > 0 ? (ThirdOrganization)list.get(0) : null;
    }

    private ThirdOrganization getByName(String name, Long cid) {
        List list;
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("name", (Object)name).andEqualTo("isValid", (Object)true);
        if (cid != null && !cid.equals(0L)) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        return (list = ((ThirdOrganizationMapper)this.dao).selectByExample(example)) != null && list.size() > 0 ? (ThirdOrganization)list.get(0) : null;
    }

    public ThirdOrganization getByCreditCode(String creditCode) {
        if (StringUtils.isEmpty((CharSequence)creditCode)) {
            return null;
        }
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("creditCode", (Object)creditCode).andEqualTo("isValid", (Object)true);
        return (ThirdOrganization)this.getOneByExample(example);
    }

    public ThirdOrgLogout getLogout(Long id) {
        return this.orgLogoutService.getLogout(id);
    }

    public Map<String, Long> queryByTypes(Integer ... orgTypes) {
        if (orgTypes == null || orgTypes.length == 0) {
            return new HashMap<String, Long>(0);
        }
        List<ThirdOrganization> list = ((ThirdOrganizationMapper)this.dao).selectMapByTypes(Arrays.asList(orgTypes));
        HashMap<String, Long> map = new HashMap<String, Long>(list.size());
        for (ThirdOrganization org : list) {
            map.put(org.getName(), org.getId());
        }
        return map;
    }

    public Map<String, Long> queryByType(int orgType) {
        List<ThirdOrganization> list = ((ThirdOrganizationMapper)this.dao).selectMapByType(orgType);
        HashMap<String, Long> map = new HashMap<String, Long>(list.size());
        for (ThirdOrganization org : list) {
            map.put(org.getName(), org.getId());
        }
        return map;
    }

    public Integer existBycreditCode(String creditCode) {
        ThirdOrganization old = this.getByCreditCode(creditCode);
        if (old != null) {
            return -1;
        }
        return 1;
    }

    @Transactional(readOnly=false)
    public synchronized ImportResult importOrg(ImportParam importParam) {
        this.logger.info("\u5bfc\u5165\u673a\u6784:\u533a\u57dfid:{}", (Object)importParam.getAreaId());
        ImportResult importResult = this.createImportResult();
        if (importParam.getImportType().equals(2)) {
            List<OrgUpdateDto> list = this.orgImportTempCache.get(importParam.getImportNo());
            if (list == null) {
                return importResult;
            }
            list.forEach(s -> {
                s.setLinkWayAreaId(importParam.getAreaId());
                s.setLinkWayAreaName(importParam.getAreaName());
            });
            this.doImport(list, importParam.getUserId(), importParam.getCreateUser(), true, true);
            return importResult;
        }
        if (importParam.getLastImport() != null && importParam.getLastImport().booleanValue()) {
            this.orgImportTempCache.delete(importParam.getImportNo());
        }
        Boolean isCreateUser = importParam.getCreateUser();
        importResult.setCreateUser(isCreateUser);
        List<ThirdOrganization> all = this.getListByExample(new Example(ThirdOrganization.class));
        LinkedList<OrgUpdateDto> allList = new LinkedList<OrgUpdateDto>();
        ExcelModel excelModel = importParam.getExcelModel();
        for (SheetModel sheet : excelModel.getSheets()) {
            OrgImportParser parser = this.getParser(sheet.getSheetName());
            if (parser == null) {
                throw new RuntimeException("\u673a\u6784\u5bfc\u5165\u89e3\u6790\u5668\u4e0d\u5b58\u5728,\u673a\u6784\u7c7b\u578b:" + sheet.getSheetName());
            }
            parser.setAreaId(importParam.getAreaId());
            allList.addAll(parser.parse(sheet));
        }
        this.checkError1(importResult, allList, all);
        if (!importResult.getErrors1().isEmpty()) {
            return importResult;
        }
        this.checkError2(importResult, allList, all);
        this.checkError3(importResult, allList, all);
        this.checkRepeatNameOrg(importResult, allList, all);
        if (importResult.getResultCode().equals(0)) {
            allList.forEach(s -> {
                s.setLinkWayAreaId(importParam.getAreaId());
                s.setLinkWayAreaName(importParam.getAreaName());
            });
            this.doImport(allList, importParam.getUserId(), importParam.getCreateUser(), true, true);
        } else {
            if (!importResult.getErrors1().isEmpty()) {
                return importResult;
            }
            long importNo = this.snowFlake.nextId();
            this.orgImportTempCache.put(importNo, allList);
            importResult.setImportNo(Long.valueOf(importNo));
        }
        return importResult;
    }

    @Transactional(readOnly=false)
    public void updateHidden(HideOrgParam param) {
        if (param.getOrgIds() == null || param.getOrgIds().isEmpty()) {
            return;
        }
        ((ThirdOrganizationMapper)this.dao).updateHidden(param);
    }

    private void checkError1(ImportResult importResult, List<OrgUpdateDto> allList, List<ThirdOrganization> all) {
        HashMap<CallSite, ThirdOrganization> nameMap = new HashMap<CallSite, ThirdOrganization>();
        HashMap<CallSite, ThirdOrganization> creditCodeMap = new HashMap<CallSite, ThirdOrganization>();
        for (OrgUpdateDto dto : allList) {
            ParseError parseError_1;
            ParseError parseError_2;
            ThirdOrganization org = dto.getThirdOrganization();
            ParseError parseError = this.createParseError(org);
            StringBuilder err1 = this.validateData(org);
            if (!this.isEmpty(org.getName()).booleanValue() && !this.isEmpty(org.getCreditCode()).booleanValue()) {
                for (ThirdOrganization old : all) {
                    if (!old.getName().equals(org.getName()) || !this.haveCreditCode("" + org.getOrgType()) || this.creditCodeIsEqual(org.getCreditCode(), old.getCreditCode())) continue;
                    err1.append("\u673a\u6784\u540d\u79f0\u4e0e\u5e93\u4e2d\u673a\u6784\u540d\u79f0\u4e00\u81f4\u4f46\u4fe1\u4ee3\u7801\u4e0d\u4e00\u81f4<br>");
                }
            }
            if (!this.isEmpty(err1.toString()).booleanValue()) {
                parseError.setErrorMsg(err1.toString());
                importResult.getErrors1().add(parseError);
            }
            if (!this.isEmpty(org.getName()).booleanValue()) {
                String nameKey = org.getOrgTypes() + "-" + org.getName();
                if (!nameMap.containsKey(nameKey)) {
                    nameMap.put((CallSite)((Object)nameKey), org);
                } else {
                    parseError_2 = this.createParseError((ThirdOrganization)nameMap.get(nameKey));
                    parseError_2.setErrorMsg("\u673a\u6784\u540d\u79f0\u91cd\u590d");
                    importResult.getErrors1().add(parseError_2);
                    parseError_1 = this.createParseError(org);
                    parseError_1.setErrorMsg("\u673a\u6784\u540d\u79f0\u91cd\u590d");
                    importResult.getErrors1().add(parseError_1);
                }
            }
            if (this.isEmpty(org.getCreditCode()).booleanValue()) continue;
            String creditCodeKey = org.getOrgTypes() + "-" + org.getCreditCode();
            if (!creditCodeMap.containsKey(creditCodeKey)) {
                creditCodeMap.put((CallSite)((Object)creditCodeKey), org);
                continue;
            }
            parseError_2 = this.createParseError((ThirdOrganization)creditCodeMap.get(creditCodeKey));
            parseError_2.setErrorMsg("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u91cd\u590d");
            importResult.getErrors1().add(parseError_2);
            parseError_1 = this.createParseError(org);
            parseError_1.setErrorMsg("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u91cd\u590d");
            importResult.getErrors1().add(parseError_1);
        }
        if (!importResult.getErrors1().isEmpty()) {
            importResult.setResultCode(Integer.valueOf(1));
        }
    }

    private void checkError2(ImportResult importResult, List<OrgUpdateDto> allList, List<ThirdOrganization> all) {
        for (OrgUpdateDto dto : allList) {
            ThirdOrganization org = dto.getThirdOrganization();
            ParseError parseError = this.createParseError(org);
            if (this.isEmpty(org.getName()).booleanValue() || this.haveCreditCode(org.getOrgTypes()) && this.isEmpty(org.getCreditCode()).booleanValue()) continue;
            StringBuilder sb = new StringBuilder();
            for (ThirdOrganization old : all) {
                if (!old.getName().equals(org.getName()) || !old.getOrgTypes().contains(org.getOrgTypes())) continue;
                if (this.haveCreditCode(org.getOrgTypes())) {
                    if (!this.creditCodeIsEqual(org.getCreditCode(), old.getCreditCode())) continue;
                    sb.append("\u662f\u5426\u586b\u5145\u6570\u636e?");
                    this.fillData(org, old, dto.getThirdOrgInfoList());
                    continue;
                }
                sb.append("\u662f\u5426\u586b\u5145\u6570\u636e?");
                this.fillData(org, old, dto.getThirdOrgInfoList());
            }
            if (this.isEmpty(sb.toString()).booleanValue()) continue;
            parseError.setErrorMsg(sb.toString());
            importResult.setResultCode(Integer.valueOf(1));
            importResult.getErrors2().add(parseError);
        }
    }

    private void checkError3(ImportResult importResult, List<OrgUpdateDto> allList, List<ThirdOrganization> all) {
        HashSet<String> names = new HashSet<String>();
        for (OrgUpdateDto dto : allList) {
            ThirdOrganization org = dto.getThirdOrganization();
            if (this.isEmpty(org.getName()).booleanValue() || this.haveCreditCode(org.getOrgTypes()) && this.isEmpty(org.getCreditCode()).booleanValue() || !this.haveCreditCode(org.getOrgTypes())) continue;
            StringBuilder sb = new StringBuilder();
            for (ThirdOrganization thirdOrganization : all) {
                if (!this.creditCodeIsEqual(org.getCreditCode(), thirdOrganization.getCreditCode()) || org.getName().equals(thirdOrganization.getName())) continue;
                sb.append("\u662f\u5426\u521b\u5efa\u65b0\u673a\u6784\uff08\u4fe1\u4ee3\u7801\u548c\u7cfb\u7edf\u5df2\u6709\u91cd\u590d\uff09");
                break;
            }
            ParseError parseError = this.createParseError(org);
            if (!this.isEmpty(sb.toString()).booleanValue()) {
                parseError.setErrorMsg(sb.toString());
                importResult.setResultCode(Integer.valueOf(1));
                importResult.getErrors3().add(parseError);
            }
            if (org.getName() != null && names.contains(org.getName())) continue;
            sb = new StringBuilder();
            for (OrgUpdateDto dto2 : allList) {
                ThirdOrganization org2 = dto2.getThirdOrganization();
                if (this.isEmpty(org2.getName()).booleanValue() || this.haveCreditCode(org2.getOrgTypes()) && this.isEmpty(org2.getCreditCode()).booleanValue() || !this.haveCreditCode(org2.getOrgTypes()) || !this.creditCodeIsEqual(org.getCreditCode(), org2.getCreditCode()) || org.getName().equals(org2.getName())) continue;
                sb.append("\u662f\u5426\u521b\u5efa\u65b0\u673a\u6784\uff08\u4e0d\u540c\u7c7b\u578b\u4e4b\u95f4\u4fe1\u4ee3\u7801\u91cd\u590d\uff09");
                ParseError parseError2 = this.createParseError(org2);
                parseError2.setErrorMsg(sb.toString());
                importResult.setResultCode(Integer.valueOf(1));
                importResult.getErrors3().add(parseError2);
                names.add(org.getName());
                names.add(org2.getName());
                break;
            }
            if (this.isEmpty(sb.toString()).booleanValue()) continue;
            ParseError parseError2 = this.createParseError(org);
            parseError2.setErrorMsg(sb.toString());
            importResult.setResultCode(Integer.valueOf(1));
            importResult.getErrors3().add(parseError2);
        }
    }

    private void doImport(List<OrgUpdateDto> list, Long userId, Boolean createUser, Boolean add, Boolean update) {
        List<ThirdOrganization> all = this.getListByExample(new Example(ThirdOrganization.class));
        LinkedList<OrgUpdateDto> addList = new LinkedList<OrgUpdateDto>();
        LinkedList<OrgUpdateDto> updateList = new LinkedList<OrgUpdateDto>();
        this.logger.info("\u673a\u6784\u5bfc\u5165,\u5927\u5c0f:" + list.size());
        for (OrgUpdateDto dto : list) {
            ThirdOrganization org = dto.getThirdOrganization();
            if (org.getId() == null) {
                org.setCreateBy(userId);
                org.setCreateDate(new Date());
                addList.add(dto);
                org.setCreditCode(this.getCreditCodeAndOrderNum(org.getCreditCode(), all));
            } else {
                if (org.getIsValid() != null && org.getIsValid().equals(false)) {
                    org.setImportRecoverTime(new Date());
                }
                org.setIsValid(Boolean.valueOf(true));
                updateList.add(dto);
            }
            org.setUpdateBy(userId);
            org.setUpdateDate(new Date());
            org.setBusinessStatus(Byte.valueOf((byte)1));
            if (org.getLevel() == null) {
                org.setLevel(Integer.valueOf(0));
            }
            if (org.getRecordManageUnitDicId() == null) {
                org.setRecordManageUnitDicId(Long.valueOf(0L));
            }
            if (org.getCid() == null) {
                org.setCid(Long.valueOf(0L));
            }
            if (org.getLegalPerson() == null) {
                org.setLegalPerson("");
            }
            if (org.getLegalPersonPhone() == null) {
                org.setLegalPersonPhone("");
            }
            if (dto.getThirdOrgInfoList() != null) continue;
            dto.setThirdOrgInfoList(new LinkedList());
        }
        if (add.booleanValue()) {
            this.doAddMany(addList, createUser);
        }
        if (update.booleanValue()) {
            this.doUpdateMany(updateList, createUser);
        }
    }

    private ImportResult createImportResult() {
        ImportResult importResult = new ImportResult();
        importResult.setResultCode(Integer.valueOf(0));
        importResult.setErrors1(new LinkedList());
        importResult.setErrors2(new LinkedList());
        importResult.setErrors3(new LinkedList());
        importResult.setErrors4(new LinkedList());
        return importResult;
    }

    private void setInitPassword(SysUser user) {
        String plainPassword = DigestUtils.md5Hex((String)"Zyj@2022");
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
    }

    private SysUser createUser(ThirdOrganization org) {
        SysUser sysUser = new SysUser();
        sysUser.setUsername(org.getName());
        sysUser.setCid(org.getId());
        this.setInitPassword(sysUser);
        sysUser.setCreateBy(org.getCreateBy());
        sysUser.setCreateDate(new Date());
        sysUser.setUpdateBy(org.getUpdateBy());
        sysUser.setUpdateDate(new Date());
        sysUser.setDataScope(Integer.valueOf(1));
        sysUser.setFaceId(Long.valueOf(0L));
        sysUser.setFullname(sysUser.getUsername());
        sysUser.setIsForbidden(Boolean.valueOf(false));
        sysUser.setCancelForbiddenTime(new Date());
        sysUser.setIsManger(Boolean.valueOf(true));
        sysUser.setIsValid(Boolean.valueOf(true));
        this.logger.info("\u521b\u5efa\u7528\u6237:" + JsonUtils.toJsonString((Object)sysUser));
        return sysUser;
    }

    private void checkRepeatNameOrg(ImportResult importResult, List<OrgUpdateDto> allList, List<ThirdOrganization> all) {
        HashSet<Integer> types = new HashSet<Integer>();
        HashMap<String, ThirdOrganization> oldMap = new HashMap<String, ThirdOrganization>();
        for (ThirdOrganization organization : all) {
            oldMap.put(organization.getName(), organization);
        }
        HashMap<String, ThirdOrganization> map = new HashMap<String, ThirdOrganization>();
        Iterator<OrgUpdateDto> iterator = allList.iterator();
        while (iterator.hasNext()) {
            ParseError parseError;
            OrgUpdateDto dto = iterator.next();
            ThirdOrganization currentOrg = dto.getThirdOrganization();
            String key = currentOrg.getName();
            if (key == null || key.isEmpty()) continue;
            if (oldMap.containsKey(key = key.trim())) {
                ThirdOrganization old = (ThirdOrganization)oldMap.get(key);
                if (!(!this.creditCodeIsEqual(currentOrg.getCreditCode(), old.getCreditCode()) && this.haveCreditCode("" + currentOrg.getOrgType()) || old.getOrgTypes().contains(currentOrg.getOrgTypes()))) {
                    importResult.setResultCode(Integer.valueOf(1));
                    parseError = this.createParseError(dto.getThirdOrganization());
                    parseError.setErrorMsg(parseError.getErrorMsg() + "(\u540d\u79f0\u548c\u7cfb\u7edf\u5df2\u6709\u6570\u636e\u91cd\u590d)");
                    importResult.getErrors4().add(parseError);
                    Integer orgType = currentOrg.getOrgType();
                    this.fillData(currentOrg, old, dto.getThirdOrgInfoList());
                    currentOrg.setOrgTypes(old.getOrgTypes() + "," + orgType);
                    currentOrg.setOrgType(orgType);
                }
            }
            if (!map.containsKey(key)) {
                map.put(key, currentOrg);
                continue;
            }
            ThirdOrganization preOrg = (ThirdOrganization)map.get(key);
            if (preOrg.getOrgType().equals(currentOrg.getOrgType())) continue;
            if (this.haveCreditCode("" + currentOrg.getOrgType()) && this.haveCreditCode("" + preOrg.getOrgType()) && !this.creditCodeIsEqual(currentOrg.getCreditCode(), preOrg.getCreditCode())) {
                importResult.setResultCode(Integer.valueOf(1));
                parseError = this.createParseError(preOrg);
                parseError.setOrgName(key);
                parseError.setCreditCode(preOrg.getCreditCode());
                parseError.setErrorMsg("\u540d\u79f0\u4e00\u81f4\u4f46\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4");
                parseError.setOrgType(this.getOrgType("" + preOrg.getOrgType()));
                ParseError parseError2 = this.createParseError(currentOrg);
                parseError2.setOrgName(key);
                parseError2.setCreditCode(currentOrg.getCreditCode());
                parseError2.setErrorMsg("\u540d\u79f0\u4e00\u81f4\u4f46\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4");
                parseError2.setOrgType(this.getOrgType("" + currentOrg.getOrgType()));
                importResult.getErrors1().add(parseError);
                importResult.getErrors1().add(parseError2);
                continue;
            }
            importResult.setResultCode(Integer.valueOf(1));
            if (!types.contains(preOrg.getOrgType())) {
                ParseError parseError1 = this.createParseError(preOrg);
                parseError1.setErrorMsg(parseError1.getErrorMsg() + "(\u4e0d\u540c\u7c7b\u578b\u4e4b\u95f4\u540d\u79f0\u91cd\u590d)");
                importResult.getErrors4().add(parseError1);
                types.add(preOrg.getOrgType());
            }
            if (!types.contains(currentOrg.getOrgType())) {
                ParseError parseError2 = this.createParseError(currentOrg);
                parseError2.setErrorMsg(parseError2.getErrorMsg() + "(\u4e0d\u540c\u7c7b\u578b\u4e4b\u95f4\u540d\u79f0\u91cd\u590d)");
                importResult.getErrors4().add(parseError2);
                preOrg.setOrgTypes(preOrg.getOrgTypes() + "," + currentOrg.getOrgTypes());
                types.add(currentOrg.getOrgType());
            }
            iterator.remove();
        }
    }

    private String getOrgType(String typeCode) {
        switch (typeCode) {
            case "1": {
                return "\u68c0\u6d4b\u8bc4\u4ef7\u673a\u6784";
            }
            case "2": {
                return "\u4f53\u68c0\u673a\u6784";
            }
            case "4": {
                return "\u8bca\u65ad\u673a\u6784";
            }
            case "6": {
                return "\u57f9\u8bad\u673a\u6784";
            }
            case "8": {
                return "\u9274\u5b9a\u673a\u6784";
            }
        }
        return "";
    }

    private void fillData(ThirdOrganization newOrg, ThirdOrganization oldOrg, List<ThirdOrgInfo> infos) {
        BeanUtils.copyProperties((Object)oldOrg, (Object)newOrg, (String[])this.getNullPropertyNames(oldOrg));
        List oldInfos = this.thirdOrgInfoService.getByOrg(oldOrg.getId());
        for (ThirdOrgInfo old : oldInfos) {
            boolean in = false;
            for (ThirdOrgInfo info : infos) {
                if (!old.getInfoDicId().equals(info.getInfoDicId())) continue;
                in = true;
                break;
            }
            if (in) continue;
            infos.add(old);
        }
    }

    private String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null && !"".equals(srcValue)) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    private ParseError createParseError(ThirdOrganization organization) {
        ParseError parseError = new ParseError();
        parseError.setOrgType(this.getOrgType("" + organization.getOrgType()));
        parseError.setErrorMsg("\u662f\u5426\u662f\u540c\u4e00\u5bb6\u673a\u6784");
        parseError.setCreditCode(organization.getCreditCode());
        parseError.setOrgName(organization.getName());
        parseError.setExcelPosition(organization.getExcelPosition());
        return parseError;
    }

    private Boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean haveCreditCode(String orgType) {
        return "1,2,4,6".contains(orgType);
    }

    private Boolean validateCreditCode(String creditCode) {
        if (creditCode == null || creditCode.length() != 18) {
            return false;
        }
        return true;
    }

    private StringBuilder validateData(ThirdOrganization org) {
        StringBuilder sb = new StringBuilder();
        if (this.isEmpty(org.getName()).booleanValue()) {
            sb.append("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a<br/>");
        }
        if ((org.getOrgTypes().contains("1") || org.getOrgTypes().contains("2")) && (this.isEmpty(org.getLegalPerson()).booleanValue() || this.isEmpty(org.getLegalPersonPhone()).booleanValue())) {
            sb.append("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u548c\u6cd5\u5b9a\u4ee3\u8868\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a<br/>");
        }
        if (org.getAreaId() == null) {
            sb.append("\u884c\u653f\u533a\u57df\u6709\u8bef<br/>");
        }
        if (this.haveCreditCode(org.getOrgTypes())) {
            if (this.isEmpty(org.getCreditCode()).booleanValue()) {
                sb.append("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a<br/>");
            } else if (!this.validateCreditCode(org.getCreditCode()).booleanValue()) {
                sb.append("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e<br/>");
            }
        }
        return sb;
    }

    private synchronized String getCreditCodeAndOrderNum(String creditCode, List<ThirdOrganization> all) {
        if (creditCode == null) {
            return null;
        }
        Integer num = this.orderNumMap.get(creditCode = creditCode.split("-")[0]);
        if (num == null) {
            LinkedList<String> codes = new LinkedList<String>();
            for (ThirdOrganization old : all) {
                if (old.getCreditCode() == null || !old.getCreditCode().contains(creditCode)) continue;
                codes.add(old.getCreditCode());
            }
            if (!codes.isEmpty()) {
                codes.sort(String::compareTo);
                String last = (String)codes.get(codes.size() - 1);
                num = last.contains("-") ? Integer.valueOf(Integer.parseInt(last.split("-")[1])) : Integer.valueOf(0);
            } else {
                this.orderNumMap.put(creditCode, 0);
                return creditCode;
            }
        }
        num = num + 1;
        this.orderNumMap.put(creditCode, num);
        return creditCode + "-" + String.format("%03d", num);
    }

    private boolean creditCodeIsEqual(String code1, String code2) {
        if (code1 == null) {
            return code2 == null;
        }
        if (code2 == null) {
            return code1 == null;
        }
        return code1.split("-")[0].equals(code2.split("-")[0]);
    }

    @Transactional(readOnly=false)
    public void batchUpdateOrgs(Map<String, List<ExcelRowContent<SuperviseOrgListVo>>> excelDatas, Long userId, Long areaId) {
        ArrayList all = new ArrayList();
        for (String sheetName : excelDatas.keySet()) {
            all.addAll(excelDatas.get(sheetName));
        }
        for (ExcelRowContent erc : all) {
            SuperviseOrgListVo vo = (SuperviseOrgListVo)erc.getT();
            AreaModel area = this.sysAreaProvideService.getAreaByName(vo.getAreaName());
            if (area != null) {
                vo.setAreaId(area.getId());
            }
            vo.setAddress(vo.getAddressDetail());
            if (StringUtils.isNotEmpty((String)vo.getCanOutCheckStr()) && Integer.valueOf(2).equals(vo.getOrgType())) {
                vo.setCanOutCheck(Boolean.valueOf("\u662f".equals(vo.getCanOutCheckStr())));
            }
            if (vo.getCanServiceStr() != null && !vo.getCanServiceStr().isEmpty()) {
                if ("\u662f".equals(vo.getCanServiceStr())) {
                    vo.setLogout(Boolean.valueOf(false));
                } else {
                    vo.setLogout(Boolean.valueOf(true));
                }
            }
            ArrayList<ThirdOrgInfo> infoAll = new ArrayList<ThirdOrgInfo>();
            if (StringUtils.isNotEmpty((String)vo.getCheckAndProjStr()) && Integer.valueOf(2).equals(vo.getOrgType())) {
                infoAll.addAll(this.physicalExamParser.createOrgDicInfo(vo.getCheckAndProjStr()));
            }
            if (StringUtils.isNotEmpty((String)vo.getLevelName()) && Integer.valueOf(1).equals(vo.getOrgType())) {
                if ("\u7532\u7ea7".equals(vo.getLevelName())) {
                    vo.setLevel(Integer.valueOf(1));
                } else if ("\u4e59\u7ea7".equals(vo.getLevelName())) {
                    vo.setLevel(Integer.valueOf(2));
                } else if ("\u4e19\u7ea7".equals(vo.getLevelName())) {
                    vo.setLevel(Integer.valueOf(3));
                } else if ("\u65e0\u6b64\u8981\u6c42".equals(vo.getLevelName())) {
                    vo.setLevel(Integer.valueOf(4));
                }
            } else {
                vo.setLevel(Integer.valueOf(0));
            }
            if (StringUtils.isNotEmpty((String)vo.getServiceOrgName()) && Integer.valueOf(1).equals(vo.getOrgType())) {
                infoAll.addAll(this.checkEvaluateParser.createOrgDicInfo(vo.getServiceOrgName()));
            }
            if (StringUtils.isNotEmpty((String)vo.getServiceOrgEvaName()) && Integer.valueOf(1).equals(vo.getOrgType())) {
                infoAll.add(this.checkEvaluateParser.create6(vo.getServiceOrgEvaName()));
            }
            if (StringUtils.isNotEmpty((String)vo.getServiceOrgCheckName()) && Integer.valueOf(1).equals(vo.getOrgType())) {
                infoAll.add(this.checkEvaluateParser.create7(vo.getServiceOrgCheckName()));
            }
            if (StringUtils.isNotEmpty((String)vo.getDiagnoseProjects()) && Integer.valueOf(4).equals(vo.getOrgType())) {
                infoAll.addAll(this.diagnoseParser.createOrgDicInfo(vo.getDiagnoseProjects()));
            }
            infoAll.forEach(s -> s.setOrgId(vo.getId()));
            this.update(vo, userId);
            this.logout(vo.getId(), areaId, vo.getLogout(), userId);
            ArrayList<CallSite> types = new ArrayList<CallSite>();
            if (Integer.valueOf(2).equals(vo.getOrgType())) {
                types.add((CallSite)((Object)("" + OrgInfoDicTypeEnum.RECORD_CHECK_TYPE_AND_PROJECT.getType())));
            } else if (Integer.valueOf(1).equals(vo.getOrgType())) {
                types.add((CallSite)((Object)("" + OrgInfoDicTypeEnum.FIRST_BUSINESS.getType())));
                types.add((CallSite)((Object)("" + OrgInfoDicTypeEnum.SECOND_BUSINESS.getType())));
                types.add((CallSite)((Object)("" + OrgInfoDicTypeEnum.SERVICE_RANGE.getType())));
            } else if (Integer.valueOf(4).equals(vo.getOrgType())) {
                types.add((CallSite)((Object)("" + OrgInfoDicTypeEnum.DIAGNOSE_PROJECT.getType())));
            }
            if (types.size() <= 0) continue;
            this.thirdOrgInfoService.deleteByOrgIdAndDicTypes(vo.getId(), types);
            infoAll.forEach(s -> this.thirdOrgInfoService.add(s));
        }
    }

    public List<ThirdOrganization> getAll() {
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true);
        return ((ThirdOrganizationMapper)this.dao).selectByExample(example);
    }

    public ThirdOrganization getByName(String name) {
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("name", (Object)name).andEqualTo("isValid", (Object)1);
        List list = ((ThirdOrganizationMapper)this.dao).selectByExample(example);
        return list != null && !list.isEmpty() ? (ThirdOrganization)list.get(0) : null;
    }

    public boolean checkName(String orgName, Long id) {
        ThirdOrganization record = this.getByName(orgName);
        return record == null || record.getId().equals(id);
    }

    public Boolean haveOrg(Long provinceId, Long comAreaId) {
        OrgQueryParamModel queryModel = new OrgQueryParamModel();
        queryModel.setLoginUserAreaId(comAreaId);
        queryModel.setIsSuperUser(Boolean.valueOf(false));
        queryModel.setCid(null);
        queryModel.setProvinceId(provinceId);
        queryModel.setCanServiceInCurrentArea(Boolean.valueOf(true));
        queryModel.setBusinessStatus(Byte.valueOf((byte)1));
        queryModel.setUnLogout(Boolean.valueOf(true));
        queryModel.setOrgTypes("1,2,4,6,8");
        PageInfo<SuperviseOrgListVo> pageInfo = this.queryPage(queryModel);
        return pageInfo.getTotal() > 0L;
    }

    @Transactional(readOnly=false)
    public void updateCanServerOrg(Boolean canServer, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        ((ThirdOrganizationMapper)this.dao).updateCanServerOrg(canServer, ids);
    }

    public ThirdOrganization getThirdOrganizationInfo(Long orgId) {
        Example example = new Example(ThirdOrganization.class);
        example.createCriteria().andEqualTo("id", (Object)orgId).andEqualTo("isValid", (Object)true);
        return (ThirdOrganization)((ThirdOrganizationMapper)this.dao).selectOneByExample(example);
    }

    public List<ThirdOrganization> getThirdOrgByKeyword(String keyword) {
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria c = example.createCriteria();
        if (keyword != null) {
            c.andLike("name", "%" + keyword + "%");
        }
        c.andEqualTo("isValid", (Object)Global.TRUE);
        return this.getListByExample(example);
    }

    public List<String> getNeedCreateOrgCode(List<String> orgCodeList) {
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return new ArrayList<String>();
        }
        List<ThirdOrganization> existList = ((ThirdOrganizationMapper)this.dao).getExistOrgCode(orgCodeList);
        if (CollectionUtils.isEmpty(existList)) {
            return orgCodeList;
        }
        List collect = existList.stream().map(ThirdOrganization::getCreditCode).collect(Collectors.toList());
        for (String orgCode : orgCodeList) {
            if (collect.contains(orgCode)) continue;
            list.add(orgCode);
        }
        return list;
    }

    public List<ThirdOrganization> getOrgListByCreditCode(List<String> orgCodeList) {
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return new ArrayList<ThirdOrganization>();
        }
        return ((ThirdOrganizationMapper)this.dao).getExistOrgCode(orgCodeList);
    }

    public Map<String, ThirdOrganization> getMapByCreditCode(List<String> orgCodeList) {
        List<ThirdOrganization> list = this.getOrgListByCreditCode(orgCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<String, ThirdOrganization>();
        }
        return list.stream().collect(Collectors.toMap(ThirdOrganization::getCreditCode, Function.identity()));
    }

    @Transactional
    public void register(SysUserRegisterParam param) {
        Long orgId = param.getOrgId();
        if (param.getOrgId() == null) {
            ThirdOrganization org = new ThirdOrganization();
            org.setName(param.getOrgName());
            org.setCreditCode(param.getCreditCode());
            org.setContactName(param.getContactName());
            org.setContactPhone(param.getContactPhone());
            org.setLegalPerson(param.getLegalPerson());
            org.setLegalPersonPhone(param.getLegalPersonPhone());
            org.setOrgTypes(ThirdOrgTypeEnum.type12.getCode().toString());
            org.setCreateDate(new Date());
            org.setUpdateDate(new Date());
            org.setCreateBy(Long.valueOf(0L));
            org.setUpdateBy(Long.valueOf(0L));
            AreaModel area = this.sysAreaProvideService.getAreaById(param.getAreaId());
            if (area != null) {
                org.setProvinceId(area.getProvinceId());
                org.setCityId(area.getCityId());
                org.setAreaId(area.getAreaId());
                org.setProvinceName(area.getProvinceName());
                org.setCityName(area.getCityName());
                org.setAreaName(area.getAreaName());
                org.setDetailAreaId(area.getId());
                org.setServiceAreas(String.valueOf(area.getProvinceId()));
            } else {
                org.setServiceAreas("330000000000");
            }
            org.setAddress(param.getAddress());
            org.setOrgSource(ThirdOrgSourceEnum.register.getCode());
            ((ThirdOrganizationMapper)this.dao).insertSelective(org);
            orgId = org.getId();
        }
        SysUser sysUser = new SysUser();
        sysUser.setUsername(param.getOrgName());
        sysUser.setCid(orgId);
        sysUser.setPassword(param.getPassword());
        sysUser.setEmail(param.getEmail());
        sysUser.setIsDefaultPwd(Boolean.valueOf(false));
        sysUser.setPwdUpdateTime(new Date());
        sysUser.setResource(Integer.valueOf(ThirdOrgSourceEnum.register.getCode().intValue()));
        sysUser.setIsManger(Boolean.valueOf(this.sysUserService.isExistsManager(orgId) == false));
        sysUser.setCreateDate(new Date());
        sysUser.setDataScope(Integer.valueOf(1));
        sysUser.setFaceId(Long.valueOf(0L));
        sysUser.setFullname(param.getOrgName());
        sysUser.setIsForbidden(Boolean.valueOf(false));
        sysUser.setIsValid(Boolean.valueOf(true));
        SysUser user = this.sysUserService.register(sysUser);
        this.menuV3Service.insertThirdUserRole(user.getId(), ThirdOrgTypeEnum.type12.getCode().toString(), user.getIsManger().booleanValue());
    }

    public List<SysArea> getServiceIfContectZJS(Long areaId, String serviceAreas) {
        if (StringUtils.isBlank((CharSequence)serviceAreas)) {
            return Collections.emptyList();
        }
        List<Long> collect = Arrays.stream(serviceAreas.split(",")).map(Long::parseLong).collect(Collectors.toList());
        List<SysArea> serviceIfContectZJS = ((ThirdOrganizationMapper)this.dao).getServiceIfContectZJS(areaId, collect);
        return serviceIfContectZJS;
    }

    public JqGridData<ThirdOrgUserV3ListVo> getThirdOrgUserList(ThirdOrgUserV3ListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows(), (boolean)param.getCount());
        List<ThirdOrgUserV3ListVo> rst = ((ThirdOrganizationMapper)this.dao).getThirdOrgUserList(param);
        if (CollUtil.isNotEmpty(rst)) {
            Map orgMap = this.organizationService.getOrgMapByIdList(rst.stream().map(ThirdOrgUserV3ListVo::getSupervisionUnit).collect(Collectors.toSet()));
            for (ThirdOrgUserV3ListVo row : rst) {
                row.setSupervisionUnitName(orgMap.containsKey(row.getSupervisionUnit()) ? ((Organization)orgMap.get(row.getSupervisionUnit())).getName() : "");
                row.setOrgTypeMap(this.buildOrgTypeMap(row.getOrgTypes()));
                row.setOrgTypeStr(String.join((CharSequence)",", row.getOrgTypeMap().values()));
            }
        }
        return new JqGridData((Page)rst, (JqGridParam)param);
    }

    private Map<String, String> buildOrgTypeMap(String orgTypes) {
        return Arrays.stream(orgTypes.split(",")).filter(CharSequenceUtil::isNotBlank).mapToInt(s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.logger.error("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32 {} \u8f6c\u6362\u4e3a\u6574\u6570: {}", s, (Object)e.getMessage());
                return -1;
            }
        }).boxed().collect(Collectors.toMap(String::valueOf, ThirdOrgTypeEnum::getName, (v1, v2) -> v1));
    }

    public Boolean isHaveThisName(String name, Long excludeId) {
        if (StrUtil.isBlank((CharSequence)name)) {
            throw new HealthException("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("name", (Object)name).andEqualTo("isValid", (Object)Boolean.TRUE);
        if (Objects.nonNull(excludeId)) {
            c.andNotEqualTo("id", (Object)excludeId);
        }
        return this.getCountByExample(example) > 0;
    }

    public Boolean isHaveThisCreditCode(String creditCode, Long excludeId) {
        if (StrUtil.isBlank((CharSequence)creditCode)) {
            throw new HealthException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("creditCode", (Object)creditCode).andEqualTo("isValid", (Object)Boolean.TRUE);
        if (Objects.nonNull(excludeId)) {
            c.andNotEqualTo("id", (Object)excludeId);
        }
        return this.getCountByExample(example) > 0;
    }

    @Transactional
    public Boolean deleteByOrgId(Long orgId, Long loginUserId) {
        if (Objects.isNull(orgId)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u673a\u6784");
        }
        ThirdOrganization org = (ThirdOrganization)this.getById(orgId);
        if (Objects.isNull(org)) {
            throw new HealthException("\u8be5\u673a\u6784\u5df2\u4e0d\u5b58\u5728");
        }
        ThirdOrganization entity = new ThirdOrganization();
        entity.setId(orgId);
        this.delete(entity, loginUserId);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean deleteByOrgIdList(List<Long> orgIdList, Long loginUserId) {
        if (Objects.isNull(orgIdList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u673a\u6784");
        }
        ThirdOrganization entity = new ThirdOrganization();
        entity.setIsValid(Boolean.FALSE);
        this.setUpdateInfo(entity, loginUserId);
        Example example = new Example(ThirdOrganization.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("id", orgIdList).andEqualTo("isValid", (Object)Boolean.TRUE);
        return ((ThirdOrganizationMapper)this.dao).updateByExampleSelective(entity, example) > 0;
    }

    @Transactional
    public Boolean save(ThirdOrgUserV3AddParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (StrUtil.isBlank((CharSequence)param.getName())) {
            throw new HealthException("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)param.getUsername())) {
            throw new HealthException("\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)param.getCreditCode())) {
            throw new HealthException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)param.getOrgTypes())) {
            throw new HealthException("\u8bf7\u9009\u62e9\u673a\u6784\u7c7b\u578b");
        }
        if (Objects.isNull(param.getSupervisionUnit())) {
            throw new HealthException("\u8bf7\u9009\u62e9\u76d1\u7763\u5355\u4f4d");
        }
        if (Objects.isNull(param.getDetailAreaId())) {
            throw new HealthException("\u8bf7\u9009\u62e9\u673a\u6784\u5730\u5740");
        }
        OrganizationUser organizationUser = this.organizationUserService.getUserInfoById(param.getSupervisionUnit());
        if (Objects.isNull(organizationUser)) {
            throw new HealthException("\u8be5\u76d1\u7763\u5355\u4f4d\u5df2\u4e0d\u5b58\u5728");
        }
        if (this.isHaveThisName(param.getName(), null).booleanValue()) {
            throw new HealthException("\u8be5\u673a\u6784\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        if (this.sysUserService.isHaveThisUserName(param.getUsername(), null).booleanValue()) {
            throw new HealthException("\u8be5\u8d26\u53f7\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        ThirdOrganization org = new ThirdOrganization();
        org.setName(param.getName());
        org.setCreditCode(param.getCreditCode());
        org.setOrgTypes(param.getOrgTypes());
        org.setSupervisionUnit(param.getSupervisionUnit());
        org.setTestData(param.getTestData());
        org.setHidden(param.getHidden());
        org.setAddress(param.getAddress());
        org.setServiceAreas(param.getServiceAreas());
        org.setOrgSource(ThirdOrgSourceEnum.add.getCode());
        org.setIsValid(Boolean.TRUE);
        Optional.ofNullable(param.getDetailAreaId()).map(arg_0 -> ((ISysAreaProvideService)this.sysAreaProvideService).getAreaByIdV3(arg_0)).ifPresent(area -> {
            org.setDetailAreaId(param.getDetailAreaId());
            org.setProvinceId(area.getProvinceId());
            org.setProvinceName(area.getProvinceName());
            org.setCityId(area.getProvinceId());
            org.setCityName(area.getCityName());
            org.setAreaId(area.getProvinceId());
            org.setAreaName(area.getAreaName());
        });
        Optional.ofNullable(param.getSupervisionUnit()).map(arg_0 -> ((IOrganizationService)this.organizationService).getOrgById(arg_0)).ifPresent(organization -> org.setSupervisionAreaId(organization.getAreaId()));
        this.add(org, param.getLoginUserId(), null);
        SysUser user = new SysUser().setCid(org.getId()).setUsername(param.getUsername()).setFullname(param.getName()).setIsForbidden(param.getIsForbidden()).setIsManger(Boolean.TRUE).setIsValid(Boolean.TRUE);
        user = this.sysUserService.setPasswordInfo(user);
        if (Boolean.TRUE.equals(param.getIsForbidden())) {
            user.setForbiddenTime(new Date());
        } else {
            user.setCancelForbiddenTime(new Date());
        }
        this.sysUserService.add((Object)user, param.getLoginUserId(), null);
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean update(ThirdOrgUserV3EditParam param) {
        if (Objects.isNull(param.getLoginUserId())) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        OrganizationUser organizationUser = this.organizationUserService.getUserInfoById(param.getSupervisionUnit());
        if (Objects.isNull(organizationUser)) {
            throw new HealthException("\u8be5\u76d1\u7763\u5355\u4f4d\u5df2\u4e0d\u5b58\u5728");
        }
        if (this.isHaveThisName(param.getName(), param.getId()).booleanValue()) {
            throw new HealthException("\u8be5\u673a\u6784\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        ThirdOrganization org = new ThirdOrganization();
        org.setId(param.getId());
        org.setName(param.getName());
        org.setCreditCode(param.getCreditCode());
        org.setOrgTypes(param.getOrgTypes());
        org.setSupervisionUnit(param.getSupervisionUnit());
        org.setTestData(param.getTestData());
        org.setHidden(param.getHidden());
        Optional.ofNullable(param.getSupervisionUnit()).map(arg_0 -> ((IOrganizationService)this.organizationService).getOrgById(arg_0)).ifPresent(organization -> org.setSupervisionAreaId(organization.getAreaId()));
        this.update(org, param.getLoginUserId());
        return Boolean.TRUE;
    }

    @Transactional
    public Boolean delete(List<Long> idList, Long loginUserId) {
        if (Objects.isNull(loginUserId)) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u673a\u6784");
        }
        this.sysUserService.deleteByOrgIdList(idList, loginUserId);
        return this.deleteByOrgIdList(idList, loginUserId);
    }
}

