/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.org.imp;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.thirdOrganization.dao.org.ThirdOrgQualificationMapper;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgQualification;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgQualificationService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class ThirdOrgQualificationServiceImp
extends BaseServiceImpl<ThirdOrgQualificationMapper, ThirdOrgQualification>
implements IThirdOrgQualificationService {
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    @Async
    public synchronized void initDefault(Long orgId, String orgTypes) {
        if (orgTypes != null && !orgTypes.isEmpty()) {
            for (String s : orgTypes.split(",")) {
                Integer orgType = Integer.parseInt(s);
                if (this.isInit(orgId, orgType)) {
                    return;
                }
                if (orgType == 1) {
                    this.initDetection(orgId);
                    continue;
                }
                if (orgType == 2) {
                    this.initExamination(orgId);
                    continue;
                }
                if (orgType != 4) continue;
                this.initDiagnose(orgId);
            }
        }
    }

    public String getOccHealthQualificationFileIds(List<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            return null;
        }
        List<String> fileIds = ((ThirdOrgQualificationMapper)this.dao).getOccHealthQualificationFileIds(orgIds);
        return this.mergeFileIds(fileIds);
    }

    public String getHealthCheckQualificationFileIds(List<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            return null;
        }
        List<String> fileIds = ((ThirdOrgQualificationMapper)this.dao).getHealthCheckQualificationFileIds(orgIds);
        return this.mergeFileIds(fileIds);
    }

    public String getHealthCheckQualificationFileIdsByOrgIds(List<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            return null;
        }
        List<String> fileIds = ((ThirdOrgQualificationMapper)this.dao).getHealthCheckQualificationFileIdsByOrgIds(orgIds);
        return this.mergeFileIds(fileIds);
    }

    private String mergeFileIds(List<String> fileIds) {
        StringBuilder sb = new StringBuilder();
        for (String fileId : fileIds) {
            sb.append(fileId);
            sb.append(",");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    public PageInfo<ThirdOrgQualification> queryPage(JqGridParam jqGridParam, Long orgId, Integer qType) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        Example example = new Example(ThirdOrgQualification.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andEqualTo("type", (Object)qType).andEqualTo("orgId", (Object)orgId);
        List list = this.getListByExample(example);
        return new PageInfo(list);
    }

    private boolean isInit(Long orgId, Integer orgType) {
        Example example = new Example(ThirdOrgQualification.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("orgId", (Object)orgId).andEqualTo("type", (Object)orgType).andEqualTo("isValid", (Object)true);
        List list = ((ThirdOrgQualificationMapper)this.dao).selectByExample(example);
        return list != null && list.size() > 0;
    }

    private synchronized void initDetection(Long orgId) {
        List<ThirdOrgQualification> list = this.getList(orgId);
        for (ThirdOrgQualification thirdOrgQualification : list) {
            if (!thirdOrgQualification.getName().equals("\u8425\u4e1a\u6267\u7167")) continue;
            return;
        }
        ThirdOrgQualification q = new ThirdOrgQualification();
        q.setCreateBy(Long.valueOf(0L));
        q.setCreateDate(new Date());
        q.setUpdateBy(Long.valueOf(0L));
        q.setUpdateDate(new Date());
        q.setIsDefault(Boolean.valueOf(true));
        q.setName("\u8425\u4e1a\u6267\u7167");
        q.setOrgId(orgId);
        q.setType(Integer.valueOf(1));
        this.add(q);
        q.setId(null);
        q.setName("\u804c\u4e1a\u536b\u751f\u6280\u672f\u670d\u52a1\u673a\u6784\u8d44\u8d28\u8bc1\u4e66");
        this.add(q);
        q.setId(null);
        q.setName("\u8ba1\u91cf\u8ba4\u8bc1\u8bc1\u4e66");
        this.add(q);
    }

    private synchronized void initExamination(Long orgId) {
        List<ThirdOrgQualification> list = this.getList(orgId);
        for (ThirdOrgQualification thirdOrgQualification : list) {
            if (!thirdOrgQualification.getName().equals("\u533b\u7597\u673a\u6784\u6267\u4e1a\u8bb8\u53ef\u8bc1")) continue;
            return;
        }
        ThirdOrgQualification q = new ThirdOrgQualification();
        q.setCreateBy(Long.valueOf(0L));
        q.setCreateDate(new Date());
        q.setUpdateBy(Long.valueOf(0L));
        q.setUpdateDate(new Date());
        q.setIsDefault(Boolean.valueOf(true));
        q.setName("\u533b\u7597\u673a\u6784\u6267\u4e1a\u8bb8\u53ef\u8bc1");
        q.setOrgId(orgId);
        q.setType(Integer.valueOf(2));
        this.add(q);
    }

    private synchronized void initDiagnose(Long orgId) {
        String name = "\u533b\u7597\u673a\u6784\u6267\u4e1a\u8bb8\u53ef\u8bc1";
        List<ThirdOrgQualification> list = this.getList(orgId);
        for (ThirdOrgQualification thirdOrgQualification : list) {
            if (!thirdOrgQualification.getName().equals(name)) continue;
            return;
        }
        ThirdOrgQualification q = new ThirdOrgQualification();
        q.setCreateBy(Long.valueOf(0L));
        q.setCreateDate(new Date());
        q.setUpdateBy(Long.valueOf(0L));
        q.setUpdateDate(new Date());
        q.setIsDefault(Boolean.valueOf(true));
        q.setName(name);
        q.setOrgId(orgId);
        q.setType(Integer.valueOf(4));
        this.add(q);
    }

    List<ThirdOrgQualification> getList(Long orgId) {
        Example example = new Example(ThirdOrgQualification.class);
        example.createCriteria().andEqualTo("orgId", (Object)orgId).andEqualTo("isValid", (Object)true);
        return ((ThirdOrgQualificationMapper)this.dao).selectByExample(example);
    }
}

